/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors;

import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.fluid.Fluid;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.tags.ITagCollection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.roguelogix.biggerreactors.machine.client.CyaniteReprocessorScreen;
import net.roguelogix.biggerreactors.machine.containers.CyaniteReprocessorContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.container.HeatExchangerCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.container.HeatExchangerTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.screen.HeatExchangerCoolantPortScreen;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.screen.HeatExchangerTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.CommonReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ReactorAccessPortScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ReactorControlRodScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ReactorCoolantPortScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ReactorRedstonePortScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorAccessPortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorControlRodContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorRedstonePortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.turbine.client.BladeRenderer;
import net.roguelogix.biggerreactors.multiblocks.turbine.client.TurbineCoolantPortScreen;
import net.roguelogix.biggerreactors.multiblocks.turbine.client.TurbineTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.turbine.containers.TurbineCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.turbine.containers.TurbineTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorBearingTile;
import net.roguelogix.biggerreactors.registries.FluidTransitionRegistry;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;
import net.roguelogix.phosphophyllite.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="biggerreactors")
public class BiggerReactors {
    public static final String modid = "biggerreactors";
    public static final Logger LOGGER = LogManager.getLogger();
    public static DataPackRegistries dataPackRegistries;
    public static long lastRenderTime;

    public BiggerReactors() {
        new Registry();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onTagsUpdatedEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListenerEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopped);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(this::onRenderWorldLast);
        }
    }

    public void onAddReloadListenerEvent(AddReloadListenerEvent reloadListenerEvent) {
        dataPackRegistries = reloadListenerEvent.getDataPackRegistries();
    }

    public void onServerStopped(FMLServerStoppedEvent serverStoppedEvent) {
        dataPackRegistries = null;
    }

    public void onTagsUpdatedEvent(TagsUpdatedEvent.CustomTagTypes tagsUpdatedEvent) {
        if (dataPackRegistries == null) {
            return;
        }
        ReactorModeratorRegistry.loadRegistry(tagsUpdatedEvent.getTagManager());
        TurbineCoilRegistry.loadRegistry((ITagCollection<Block>)tagsUpdatedEvent.getTagManager().func_241835_a());
        FluidTransitionRegistry.loadRegistry((ITagCollection<Fluid>)tagsUpdatedEvent.getTagManager().func_241837_c());
    }

    public void onClientSetup(FMLClientSetupEvent e) {
        ScreenManager.func_216911_a(CyaniteReprocessorContainer.INSTANCE, CyaniteReprocessorScreen::new);
        ScreenManager.func_216911_a(ReactorTerminalContainer.INSTANCE, CommonReactorTerminalScreen::new);
        ScreenManager.func_216911_a(ReactorCoolantPortContainer.INSTANCE, ReactorCoolantPortScreen::new);
        ScreenManager.func_216911_a(ReactorAccessPortContainer.INSTANCE, ReactorAccessPortScreen::new);
        ScreenManager.func_216911_a(ReactorControlRodContainer.INSTANCE, ReactorControlRodScreen::new);
        ScreenManager.func_216911_a(ReactorRedstonePortContainer.INSTANCE, ReactorRedstonePortScreen::new);
        ScreenManager.func_216911_a(TurbineTerminalContainer.INSTANCE, TurbineTerminalScreen::new);
        ScreenManager.func_216911_a(TurbineCoolantPortContainer.INSTANCE, TurbineCoolantPortScreen::new);
        ScreenManager.func_216911_a(HeatExchangerTerminalContainer.INSTANCE, HeatExchangerTerminalScreen::new);
        ScreenManager.func_216911_a(HeatExchangerCoolantPortContainer.INSTANCE, HeatExchangerCoolantPortScreen::new);
        ClientRegistry.bindTileEntityRenderer(TurbineRotorBearingTile.TYPE, BladeRenderer::new);
    }

    public void onRenderWorldLast(RenderWorldLastEvent event) {
        lastRenderTime = System.nanoTime();
    }

    static {
        lastRenderTime = 0L;
    }
}

