/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IOverlayStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.network.PacketGetEntityInfo;
import mcjty.theoneprobe.network.PacketGetInfo;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.network.ThrowableIdentity;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRenderer {
    private static Map<Pair<RegistryKey<World>, BlockPos>, Pair<Long, ProbeInfo>> cachedInfo = new HashMap<Pair<RegistryKey<World>, BlockPos>, Pair<Long, ProbeInfo>>();
    private static Map<UUID, Pair<Long, ProbeInfo>> cachedEntityInfo = new HashMap<UUID, Pair<Long, ProbeInfo>>();
    private static long lastCleanupTime = 0L;
    private static Pair<Long, ProbeInfo> lastPair;
    private static long lastPairTime;
    private static long lastRenderedTime;

    public static void registerProbeInfo(RegistryKey<World> dim, BlockPos pos, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedInfo.put((Pair<RegistryKey<World>, BlockPos>)Pair.of(dim, (Object)pos), (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    public static void registerProbeInfo(UUID uuid, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            return;
        }
        long time = System.currentTimeMillis();
        cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)time, (Object)probeInfo));
    }

    public static void renderHUD(ProbeMode mode, MatrixStack matrixStack, float partialTicks) {
        double dist = (Double)Config.probeDistance.get();
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && mouseOver.func_216346_c() == RayTraceResult.Type.ENTITY) {
            matrixStack.func_227860_a_();
            double scale = (Double)Config.tooltipScale.get();
            double sw = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            double sh = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
            OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
            OverlayRenderer.renderHUDEntity(matrixStack, mode, mouseOver, sw * scale, sh * scale);
            OverlayRenderer.setupOverlayRendering(sw, sh);
            matrixStack.func_227865_b_();
            OverlayRenderer.checkCleanup();
            return;
        }
        ClientPlayerEntity entity = Minecraft.func_71410_x().field_71439_g;
        Vector3d start = entity.func_174824_e(partialTicks);
        Vector3d vec31 = entity.func_70676_i(partialTicks);
        Vector3d end = start.func_72441_c(vec31.field_72450_a * dist, vec31.field_72448_b * dist, vec31.field_72449_c * dist);
        RayTraceContext context = new RayTraceContext(start, end, RayTraceContext.BlockMode.OUTLINE, (Boolean)Config.showLiquids.get() != false ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, (Entity)entity);
        mouseOver = entity.func_130014_f_().func_217299_a(context);
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.func_216346_c() == RayTraceResult.Type.BLOCK) {
            matrixStack.func_227860_a_();
            double scale = (Double)Config.tooltipScale.get();
            double sw = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            double sh = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
            OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
            OverlayRenderer.renderHUDBlock(matrixStack, mode, mouseOver, sw * scale, sh * scale);
            OverlayRenderer.setupOverlayRendering(sw, sh);
            matrixStack.func_227865_b_();
        }
        OverlayRenderer.checkCleanup();
    }

    private static void setupOverlayRendering(double sw, double sh) {
        RenderSystem.clear((int)256, (boolean)true);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)sw, (double)sh, (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private static void checkCleanup() {
        long time = System.currentTimeMillis();
        if (time > lastCleanupTime + 5000L) {
            OverlayRenderer.cleanupCachedBlocks(time);
            OverlayRenderer.cleanupCachedEntities(time);
            lastCleanupTime = time;
        }
    }

    private static void renderHUDEntity(MatrixStack matrixStack, ProbeMode mode, RayTraceResult mouseOver, double sw, double sh) {
        if (!(mouseOver instanceof EntityRayTraceResult)) {
            return;
        }
        Entity entity = ((EntityRayTraceResult)mouseOver).func_216348_a();
        String entityString = entity.func_70022_Q();
        if (entityString == null && !(entity instanceof PlayerEntity)) {
            return;
        }
        UUID uuid = entity.func_110124_au();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        long time = System.currentTimeMillis();
        Pair<Long, ProbeInfo> cacheEntry = cachedEntityInfo.get(uuid);
        if (cacheEntry == null || cacheEntry.getValue() == null) {
            if (cacheEntry == null || time >= (Long)cacheEntry.getLeft()) {
                cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                OverlayRenderer.requestEntityInfo(mode, mouseOver, entity, (PlayerEntity)player);
            }
            if (lastPair != null && time < lastPairTime + (long)((Integer)Config.timeout.get()).intValue()) {
                OverlayRenderer.renderElements(matrixStack, (ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            } else if ((Integer)Config.waitingForServerTimeout.get() > 0 && lastRenderedTime != -1L && time > lastRenderedTime + (long)((Integer)Config.waitingForServerTimeout.get()).intValue()) {
                ProbeInfo info = OverlayRenderer.getWaitingEntityInfo(mode, mouseOver, entity, (PlayerEntity)player);
                OverlayRenderer.registerProbeInfo(uuid, info);
                lastPair = Pair.of((Object)time, (Object)info);
                lastPairTime = time;
                OverlayRenderer.renderElements(matrixStack, (ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, null);
                lastRenderedTime = time;
            }
        } else {
            if (time > (Long)cacheEntry.getLeft() + (long)((Integer)Config.timeout.get()).intValue()) {
                cachedEntityInfo.put(uuid, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)cacheEntry.getRight()));
                OverlayRenderer.requestEntityInfo(mode, mouseOver, entity, (PlayerEntity)player);
            }
            OverlayRenderer.renderElements(matrixStack, (ProbeInfo)cacheEntry.getRight(), Config.getDefaultOverlayStyle(), sw, sh, null);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    private static void requestEntityInfo(ProbeMode mode, RayTraceResult mouseOver, Entity entity, PlayerEntity player) {
        PacketHandler.INSTANCE.sendToServer((Object)new PacketGetEntityInfo((RegistryKey<World>)player.func_130014_f_().func_234923_W_(), mode, mouseOver, entity));
    }

    private static void renderHUDBlock(MatrixStack matrixStack, ProbeMode mode, RayTraceResult mouseOver, double sw, double sh) {
        RegistryKey dimension;
        Pair key;
        Pair<Long, ProbeInfo> cacheEntry;
        float damage;
        if (!(mouseOver instanceof BlockRayTraceResult)) {
            return;
        }
        BlockPos blockPos = ((BlockRayTraceResult)mouseOver).func_216350_a();
        if (blockPos == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_130014_f_().func_175623_d(blockPos)) {
            return;
        }
        long time = System.currentTimeMillis();
        IElement damageElement = null;
        if ((Integer)Config.showBreakProgress.get() > 0 && (damage = Minecraft.func_71410_x().field_71442_b.field_78770_f) > 0.0f) {
            damageElement = (Integer)Config.showBreakProgress.get() == 2 ? new ElementText((ITextComponent)new StringTextComponent("Progress " + (int)(damage * 100.0f) + "%").func_240699_a_(TextFormatting.RED)) : new ElementProgress((long)(damage * 100.0f), 100L, new ProgressStyle().prefix("Progress ").suffix("%").width(85).borderColor(0).filledColor(0).filledColor(-6750208).alternateFilledColor(-11206656));
        }
        if ((cacheEntry = cachedInfo.get(key = Pair.of((Object)(dimension = player.func_130014_f_().func_234923_W_()), (Object)blockPos))) == null || cacheEntry.getValue() == null) {
            if (cacheEntry == null || time >= (Long)cacheEntry.getLeft()) {
                cachedInfo.put((Pair<RegistryKey<World>, BlockPos>)key, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), null));
                OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, (PlayerEntity)player);
            }
            if (lastPair != null && time < lastPairTime + (long)((Integer)Config.timeout.get()).intValue()) {
                OverlayRenderer.renderElements(matrixStack, (ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            } else if ((Integer)Config.waitingForServerTimeout.get() > 0 && lastRenderedTime != -1L && time > lastRenderedTime + (long)((Integer)Config.waitingForServerTimeout.get()).intValue()) {
                ProbeInfo info = OverlayRenderer.getWaitingInfo(mode, mouseOver, blockPos, (PlayerEntity)player);
                OverlayRenderer.registerProbeInfo((RegistryKey<World>)dimension, blockPos, info);
                lastPair = Pair.of((Object)time, (Object)info);
                lastPairTime = time;
                OverlayRenderer.renderElements(matrixStack, (ProbeInfo)lastPair.getRight(), Config.getDefaultOverlayStyle(), sw, sh, damageElement);
                lastRenderedTime = time;
            }
        } else {
            if (time > (Long)cacheEntry.getLeft() + (long)((Integer)Config.timeout.get()).intValue()) {
                cachedInfo.put((Pair<RegistryKey<World>, BlockPos>)key, (Pair<Long, ProbeInfo>)Pair.of((Object)(time + 500L), (Object)cacheEntry.getRight()));
                OverlayRenderer.requestBlockInfo(mode, mouseOver, blockPos, (PlayerEntity)player);
            }
            OverlayRenderer.renderElements(matrixStack, (ProbeInfo)cacheEntry.getRight(), Config.getDefaultOverlayStyle(), sw, sh, damageElement);
            lastRenderedTime = time;
            lastPair = cacheEntry;
            lastPairTime = time;
        }
    }

    private static ProbeInfo getWaitingInfo(ProbeMode mode, RayTraceResult mouseOver, BlockPos blockPos, PlayerEntity player) {
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        World world = player.func_130014_f_();
        BlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        ItemStack pickBlock = block.getPickBlock(blockState, mouseOver, (IBlockReader)world, blockPos, player);
        ProbeHitData data = new ProbeHitData(blockPos, mouseOver.func_216347_e(), ((BlockRayTraceResult)mouseOver).func_216354_b(), pickBlock);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoProvider.showStandardBlockInfo(probeConfig, mode, probeInfo, blockState, block, world, blockPos, player, data);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Error (see log for details)!"));
        }
        probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Waiting for server..."));
        return probeInfo;
    }

    private static ProbeInfo getWaitingEntityInfo(ProbeMode mode, RayTraceResult mouseOver, Entity entity, PlayerEntity player) {
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(mouseOver.func_216347_e());
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        try {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, probeConfig);
        }
        catch (Exception e) {
            ThrowableIdentity.registerThrowable(e);
            probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Error (see log for details)!"));
        }
        probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Waiting for server..."));
        return probeInfo;
    }

    private static void requestBlockInfo(ProbeMode mode, RayTraceResult mouseOver, BlockPos blockPos, PlayerEntity player) {
        World world = player.func_130014_f_();
        BlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        ItemStack pickBlock = block.getPickBlock(blockState, mouseOver, (IBlockReader)world, blockPos, player);
        if (pickBlock == null) {
            pickBlock = ItemStack.field_190927_a;
        }
        if (!pickBlock.func_190926_b() && Config.getDontSendNBTSet().contains(pickBlock.func_77973_b().getRegistryName())) {
            pickBlock = pickBlock.func_77946_l();
            pickBlock.func_77982_d(null);
        }
        PacketHandler.INSTANCE.sendToServer((Object)new PacketGetInfo((RegistryKey<World>)world.func_234923_W_(), blockPos, mode, mouseOver, pickBlock));
    }

    public static void renderOverlay(IOverlayStyle style, IProbeInfo probeInfo, MatrixStack matrixStack) {
        matrixStack.func_227860_a_();
        double scale = (Double)Config.tooltipScale.get();
        double sw = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        double sh = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        OverlayRenderer.setupOverlayRendering(sw * scale, sh * scale);
        OverlayRenderer.renderElements(matrixStack, (ProbeInfo)probeInfo, style, sw * scale, sh * scale, null);
        OverlayRenderer.setupOverlayRendering(sw, sh);
        matrixStack.func_227865_b_();
    }

    private static void cleanupCachedBlocks(long time) {
        HashMap<Pair<RegistryKey<World>, BlockPos>, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<Pair<RegistryKey<World>, BlockPos>, Pair<Long, ProbeInfo>>();
        for (Map.Entry<Pair<RegistryKey<World>, BlockPos>, Pair<Long, ProbeInfo>> entry : cachedInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)((Integer)Config.timeout.get()).intValue() + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedInfo = newCachedInfo;
    }

    private static void cleanupCachedEntities(long time) {
        HashMap<UUID, Pair<Long, ProbeInfo>> newCachedInfo = new HashMap<UUID, Pair<Long, ProbeInfo>>();
        for (Map.Entry<UUID, Pair<Long, ProbeInfo>> entry : cachedEntityInfo.entrySet()) {
            long t = (Long)entry.getValue().getLeft();
            if (time >= t + (long)((Integer)Config.timeout.get()).intValue() + 1000L) continue;
            newCachedInfo.put(entry.getKey(), entry.getValue());
        }
        cachedEntityInfo = newCachedInfo;
    }

    public static void renderElements(MatrixStack matrixStack, ProbeInfo probeInfo, IOverlayStyle style, double sw, double sh, @Nullable IElement extra) {
        if (extra != null) {
            probeInfo.element(extra);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        int scaledWidth = (int)sw;
        int scaledHeight = (int)sh;
        int w = probeInfo.getWidth();
        int h = probeInfo.getHeight();
        int offset = style.getBorderOffset();
        int thick = style.getBorderThickness();
        int margin = 0;
        if (thick > 0) {
            w += (offset + thick + 3) * 2;
            h += (offset + thick + 3) * 2;
            margin = offset + thick + 3;
        }
        int x = style.getLeftX() != -1 ? style.getLeftX() : (style.getRightX() != -1 ? scaledWidth - w - style.getRightX() : (scaledWidth - w) / 2);
        int y = style.getTopY() != -1 ? style.getTopY() : (style.getBottomY() != -1 ? scaledHeight - h - style.getBottomY() : (scaledHeight - h) / 2);
        if (thick > 0) {
            if (offset > 0) {
                RenderHelper.drawThickBeveledBox(matrixStack, x, y, x + w - 1, y + h - 1, thick, style.getBoxColor(), style.getBoxColor(), style.getBoxColor());
            }
            RenderHelper.drawThickBeveledBox(matrixStack, x + offset, y + offset, x + w - 1 - offset, y + h - 1 - offset, thick, style.getBorderColor(), style.getBorderColor(), style.getBoxColor());
        }
        if (!Minecraft.func_71410_x().func_147113_T()) {
            RenderHelper.rot += 0.5f;
        }
        probeInfo.render(matrixStack, x + margin, y + margin);
        if (extra != null) {
            probeInfo.removeElement(extra);
        }
    }

    static {
        lastPairTime = 0L;
        lastRenderedTime = -1L;
    }
}

