/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import java.util.function.Supplier;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.rendering.OverlayRenderer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketReturnInfo {
    private RegistryKey<World> dim;
    private BlockPos pos;
    private ProbeInfo probeInfo;

    public PacketReturnInfo(PacketBuffer buf) {
        this.dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        this.pos = buf.func_179259_c();
        if (buf.readBoolean()) {
            this.probeInfo = new ProbeInfo();
            this.probeInfo.fromBytes(buf);
        } else {
            this.probeInfo = null;
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.dim.func_240901_a_());
        buf.func_179255_a(this.pos);
        if (this.probeInfo != null) {
            buf.writeBoolean(true);
            this.probeInfo.toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketReturnInfo() {
    }

    public PacketReturnInfo(RegistryKey<World> dim, BlockPos pos, ProbeInfo probeInfo) {
        this.dim = dim;
        this.pos = pos;
        this.probeInfo = probeInfo;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> OverlayRenderer.registerProbeInfo(this.dim, this.pos, this.probeInfo));
        ctx.get().setPacketHandled(true);
    }
}

