/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class DebugProbeInfoProvider
implements IProbeInfoProvider {
    @Override
    public String getID() {
        return "theoneprobe:debug";
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        if (mode == ProbeMode.DEBUG && ((Boolean)Config.showDebugInfo.get()).booleanValue()) {
            BlockPos pos = data.getPos();
            this.showDebugInfo(probeInfo, world, blockState, pos, data.getSideHit());
        }
    }

    private void showDebugInfo(IProbeInfo probeInfo, World world, BlockState blockState, BlockPos pos, Direction side) {
        Block block = blockState.func_177230_c();
        String simpleName = block.getClass().getSimpleName();
        IProbeInfo vertical = probeInfo.vertical(new LayoutStyle().borderColor(-48060).spacing(2)).text(CompoundText.createLabelInfo("Reg Name: ", block.getRegistryName().toString())).text(CompoundText.createLabelInfo("Unlocname: ", block.func_149739_a())).text(CompoundText.createLabelInfo("Class: ", simpleName)).text(CompoundText.createLabelInfo("Hardness: ", Float.valueOf(blockState.func_185887_b((IBlockReader)world, pos)))).text(CompoundText.createLabelInfo("Power W: ", blockState.func_185911_a((IBlockReader)world, pos, side.func_176734_d())).style(TextStyleClass.LABEL).text(", S: ").style(TextStyleClass.INFO).text(String.valueOf(blockState.func_185893_b((IBlockReader)world, pos, side.func_176734_d())))).text(CompoundText.createLabelInfo("Light: ", block.getLightValue(blockState, (IBlockReader)world, pos)));
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            vertical.text(CompoundText.createLabelInfo("TE: ", te.getClass().getSimpleName()));
        }
    }
}

