/*
 * Decompiled with CFR 0.152.
 */
package uno.convert;

import glm_.ExtensionsKt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import uno.glm.ExtKt;
import unsigned.IntKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Luno/convert/Ascii85;", "", "()V", "ASCII_SHIFT", "", "BASE85_POW", "", "byteArray", "", "getByteArray", "(I)[B", "int", "getInt", "([B)I", "decode", "chars", "", "decodeChunk", "chunk", "encode", "payload", "encodeChunk", "", "value", "core"})
public final class Ascii85 {
    private static final int ASCII_SHIFT;
    private static final int[] BASE85_POW;
    public static final Ascii85 INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String encode(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        byte[] byArray = payload;
        boolean bl = false;
        if (byArray.length == 0) {
            throw (Throwable)new IllegalArgumentException("You must provide a non-zero length input");
        }
        StringBuilder stringBuff = new StringBuilder(payload.length * 5 / 4);
        byte[] chunk = new byte[4];
        int chunkIndex = 0;
        for (byte currByte : payload) {
            chunk[chunkIndex++] = currByte;
            if (chunkIndex != 4) continue;
            int value = this.getInt(chunk);
            if (value == 0) {
                stringBuff.append('z');
            } else {
                stringBuff.append(this.encodeChunk(value));
            }
            ArraysKt.fill$default((byte[])chunk, (byte)0, (int)0, (int)0, (int)6, null);
            chunkIndex = 0;
        }
        if (chunkIndex > 0) {
            int numPadded = chunk.length - chunkIndex;
            ArraysKt.fill((byte[])chunk, (byte)0, (int)chunkIndex, (int)chunk.length);
            int value = this.getInt(chunk);
            char[] encodedChunk = this.encodeChunk(value);
            int n = 0;
            int n2 = encodedChunk.length - numPadded;
            while (n < n2) {
                void i2;
                stringBuff.append(encodedChunk[i2]);
                ++i2;
            }
        }
        String string = stringBuff.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuff.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final char[] encodeChunk(int value) {
        long longValue = IntKt.toULong(value);
        char[] encodedChunk = new char[5];
        int n = 0;
        int n2 = encodedChunk.length;
        while (n < n2) {
            void i2;
            encodedChunk[i2] = (char)(longValue / (long)BASE85_POW[4 - i2] + (long)ASCII_SHIFT);
            longValue %= (long)BASE85_POW[4 - i2];
            ++i2;
        }
        return encodedChunk;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] decode(@NotNull String chars) {
        void $this$filterTo$iv$iv22;
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        CharSequence charSequence = chars;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("You must provide a non-zero length input");
        }
        BigDecimal bigDecimal = ExtKt.toBidDec(chars.length());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"chars.length.toBidDec()");
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = ExtKt.toBidDec(4);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"4.toBidDec()");
        BigDecimal bigDecimal4 = bigDecimal3;
        boolean bl2 = false;
        BigDecimal bigDecimal5 = bigDecimal2.multiply(bigDecimal4);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"this.multiply(other)");
        bigDecimal2 = bigDecimal5;
        BigDecimal bigDecimal6 = ExtKt.toBidDec(5);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"5.toBidDec()");
        bigDecimal4 = bigDecimal6;
        bl2 = false;
        BigDecimal bigDecimal7 = bigDecimal2.divide(bigDecimal4, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"this.divide(other, RoundingMode.HALF_EVEN)");
        BigDecimal decodedLength = bigDecimal7;
        ByteBuffer buffer2 = ByteBuffer.allocate(ExtensionsKt.getI(decodedLength));
        String $this$filter$iv = chars;
        boolean $i$f$filter22 = false;
        CharSequence charSequence2 = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo2 = false;
        int n = 0;
        int n2 = $this$filterTo$iv$iv22.length();
        while (n < n2) {
            void index$iv$iv;
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv22.charAt((int)index$iv$iv);
            boolean bl3 = false;
            if (it != ' ' && it != '\n') {
                destination$iv$iv.append(element$iv$iv);
            }
            ++index$iv$iv;
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
        $this$filter$iv = string;
        Charset $i$f$filter22 = Charsets.UTF_8;
        boolean $this$filterTo$iv$iv22 = false;
        String string2 = $this$filter$iv;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes($i$f$filter22);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] payload = byArray;
        byte[] chunk = new byte[5];
        int chunkIndex = 0;
        for (byte by : payload) {
            if (by == ExtensionsKt.getB('z')) {
                if (chunkIndex > 0) {
                    throw (Throwable)new IllegalArgumentException("The payload is not base 85 encoded.");
                }
                chunk[chunkIndex++] = ExtensionsKt.getB('!');
                chunk[chunkIndex++] = ExtensionsKt.getB('!');
                chunk[chunkIndex++] = ExtensionsKt.getB('!');
                chunk[chunkIndex++] = ExtensionsKt.getB('!');
                chunk[chunkIndex++] = ExtensionsKt.getB('!');
            } else {
                chunk[chunkIndex++] = by;
            }
            if (chunkIndex != 5) continue;
            buffer2.put(this.decodeChunk(chunk));
            ArraysKt.fill$default((byte[])chunk, (byte)0, (int)0, (int)0, (int)6, null);
            chunkIndex = 0;
        }
        if (chunkIndex > 0) {
            int numPadded = chunk.length - chunkIndex;
            ArraysKt.fill((byte[])chunk, (byte)ExtensionsKt.getB('u'), (int)chunkIndex, (int)chunk.length);
            byte[] paddedDecode = this.decodeChunk(chunk);
            int $i$f$filterTo2 = 0;
            n = paddedDecode.length - numPadded;
            while ($i$f$filterTo2 < n) {
                void i2;
                buffer2.put(paddedDecode[i2]);
                ++i2;
            }
        }
        buffer2.flip();
        byte[] byArray2 = buffer2.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"buffer.array()");
        byte[] byArray3 = byArray2;
        int n3 = buffer2.limit();
        boolean bl4 = false;
        byte[] byArray4 = Arrays.copyOf(byArray3, n3);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"java.util.Arrays.copyOf(this, newSize)");
        return byArray4;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] decodeChunk(byte[] chunk) {
        int n;
        void $this$sumBy$iv;
        if (chunk.length != 5) {
            throw (Throwable)new IllegalArgumentException("You can only decode chunks of size 5.");
        }
        int n2 = 0;
        Iterable iterable = (Iterable)new IntRange(n2, 4);
        Ascii85 ascii85 = this;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        Iterator iterator2 = $this$sumBy$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int element$iv;
            int n3 = element$iv = ((IntIterator)iterator2).nextInt();
            n = sum$iv;
            boolean bl = false;
            int n4 = (chunk[it] - ASCII_SHIFT) * BASE85_POW[4 - it];
            sum$iv = n + n4;
        }
        n = sum$iv;
        return ascii85.getByteArray(n);
    }

    private final int getInt(byte[] $this$int) {
        if ($this$int.length != 4) {
            throw (Throwable)new IllegalArgumentException("You cannot create an int without exactly 4 bytes.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap($this$int);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"ByteBuffer.wrap(this)");
        return byteBuffer.getInt();
    }

    private final byte[] getByteArray(int $this$byteArray) {
        return new byte[]{ExtensionsKt.getB($this$byteArray >>> 24), ExtensionsKt.getB($this$byteArray >>> 16), ExtensionsKt.getB($this$byteArray >>> 8), ExtensionsKt.getB($this$byteArray)};
    }

    private Ascii85() {
    }

    static {
        Ascii85 ascii85;
        INSTANCE = ascii85 = new Ascii85();
        ASCII_SHIFT = 33;
        BASE85_POW = new int[]{1, 85, 7225, 614125, 52200625};
    }
}

