/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.PNMImageReader;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import com.twelvemonkeys.lang.Validate;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class PNMHeader {
    private final short fileType;
    private final TupleType tupleType;
    private final int width;
    private final int height;
    private final int maxSample;
    private final List<String> comments;
    private final ByteOrder byteOrder;

    public PNMHeader(short s, TupleType tupleType, int n, int n2, int n3, int n4, Collection<String> collection) {
        this.fileType = Validate.isTrue(this.isValidFileType(s), s, String.format("Illegal type: %s", PNMImageReader.asASCII(s)));
        this.tupleType = Validate.notNull(tupleType, "tuple type may not be null");
        this.width = Validate.isTrue(n > 0, n, "width must be greater than 0: %d");
        this.height = Validate.isTrue(n2 > 0, n2, "height must be greater than: %d");
        Validate.isTrue(n3 == tupleType.getSamplesPerPixel(), n3, String.format("incorrect depth for %s, expected %d: %d", new Object[]{tupleType, tupleType.getSamplesPerPixel(), n3}));
        this.maxSample = Validate.isTrue(tupleType.isValidMaxSample(n4), n4, "maxSample out of range: %d");
        this.comments = Collections.unmodifiableList(new ArrayList<String>(collection));
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }

    public PNMHeader(short s, TupleType tupleType, int n, int n2, int n3, ByteOrder byteOrder, Collection<String> collection) {
        this.fileType = Validate.isTrue(this.isValidFileType(s), s, String.format("Illegal type: %s", PNMImageReader.asASCII(s)));
        this.tupleType = Validate.notNull(tupleType, "tuple type may not be null");
        this.width = Validate.isTrue(n > 0, n, "width must be greater than 0: %d");
        this.height = Validate.isTrue(n2 > 0, n2, "height must be greater than: %d");
        Validate.isTrue(n3 == tupleType.getSamplesPerPixel(), n3, String.format("incorrect depth for %s, expected %d: %d", new Object[]{tupleType, tupleType.getSamplesPerPixel(), n3}));
        this.maxSample = -1;
        this.byteOrder = byteOrder;
        this.comments = Collections.unmodifiableList(new ArrayList<String>(collection));
    }

    private boolean isValidFileType(short s) {
        return s >= 20529 && s <= 20535 || s == 20582 || s == 20550;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public TupleType getTupleType() {
        return this.tupleType;
    }

    public int getMaxSample() {
        return this.maxSample;
    }

    public int getTransparency() {
        return this.tupleType.getTransparency();
    }

    public int getSamplesPerPixel() {
        return this.tupleType.getSamplesPerPixel();
    }

    public int getBitsPerSample() {
        if (this.fileType == 20582 || this.fileType == 20550) {
            return 32;
        }
        if (this.tupleType == TupleType.BLACKANDWHITE_WHITE_IS_ZERO) {
            return 1;
        }
        if (this.maxSample <= 255) {
            return 8;
        }
        if (this.maxSample <= 65535) {
            return 16;
        }
        if (((long)this.maxSample & 0xFFFFFFFFL) <= 0xFFFFFFFFL) {
            return 32;
        }
        throw new AssertionError((Object)"maxSample exceeds 32 bit");
    }

    public int getTransferType() {
        if (this.fileType == 20582 || this.fileType == 20550) {
            return 4;
        }
        if (this.maxSample <= 255) {
            return 0;
        }
        if (this.maxSample <= 65535) {
            return 1;
        }
        if (((long)this.maxSample & 0xFFFFFFFFL) <= 0xFFFFFFFFL) {
            return 3;
        }
        throw new AssertionError((Object)"maxSample exceeds 32 bit");
    }

    public List<String> getComments() {
        return this.comments;
    }

    public short getFileType() {
        return this.fileType;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public String toString() {
        return "PNMHeader{fileType=" + PNMImageReader.asASCII(this.fileType) + ", tupleType=" + (Object)((Object)this.tupleType) + ", width=" + this.width + ", height=" + this.height + (this.getTransferType() == 4 ? ", byteOrder=" + this.byteOrder : ", maxSample=" + this.maxSample) + ", comments=" + this.comments + '}';
    }
}

