/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class RotaryRecipe
extends MekanismRecipe {
    private static final GasStackIngredient EMPTY_GAS_INPUT = GasStackIngredient.from(GasStack.EMPTY);
    private static final FluidStackIngredient EMPTY_FLUID_INPUT = FluidStackIngredient.from(FluidStack.EMPTY);
    private final GasStackIngredient gasInput;
    private final FluidStackIngredient fluidInput;
    private final FluidStack fluidOutput;
    private final GasStack gasOutput;
    private boolean hasGasToFluid = true;
    private boolean hasFluidToGas = true;

    public RotaryRecipe(ResourceLocation id, FluidStackIngredient fluidInput, GasStack gasOutput) {
        this(id, fluidInput, EMPTY_GAS_INPUT, gasOutput, FluidStack.EMPTY);
        this.hasGasToFluid = false;
    }

    public RotaryRecipe(ResourceLocation id, GasStackIngredient gasInput, FluidStack fluidOutput) {
        this(id, EMPTY_FLUID_INPUT, gasInput, GasStack.EMPTY, fluidOutput);
        this.hasFluidToGas = false;
    }

    public RotaryRecipe(ResourceLocation id, FluidStackIngredient fluidInput, GasStackIngredient gasInput, GasStack gasOutput, FluidStack fluidOutput) {
        super(id);
        this.gasInput = gasInput;
        this.fluidInput = fluidInput;
        this.gasOutput = gasOutput;
        this.fluidOutput = fluidOutput;
    }

    public boolean hasGasToFluid() {
        return this.hasGasToFluid;
    }

    public boolean hasFluidToGas() {
        return this.hasFluidToGas;
    }

    public boolean test(FluidStack fluidStack) {
        return this.hasFluidToGas() && this.fluidInput.test(fluidStack);
    }

    public boolean test(GasStack gasStack) {
        return this.hasGasToFluid() && this.gasInput.test(gasStack);
    }

    public FluidStackIngredient getFluidInput() {
        return this.fluidInput;
    }

    public GasStackIngredient getGasInput() {
        return this.gasInput;
    }

    public GasStack getGasOutputRepresentation() {
        return this.gasOutput;
    }

    public FluidStack getFluidOutputRepresentation() {
        return this.fluidOutput;
    }

    @Contract(value="_ -> new", pure=true)
    public GasStack getGasOutput(FluidStack input) {
        return this.gasOutput.copy();
    }

    @Contract(value="_ -> new", pure=true)
    public FluidStack getFluidOutput(GasStack input) {
        return this.fluidOutput.copy();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.hasFluidToGas);
        if (this.hasFluidToGas) {
            this.fluidInput.write(buffer);
            this.gasOutput.writeToPacket(buffer);
        }
        buffer.writeBoolean(this.hasGasToFluid);
        if (this.hasGasToFluid) {
            this.gasInput.write(buffer);
            this.fluidOutput.writeToPacket(buffer);
        }
    }
}

