/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import de.maxhenkel.pipez.capabilities.ModCapabilities;
import de.maxhenkel.pipez.corelib.tag.NamedTagWrapper;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;

public class GasUtils {
    public static final ITag.INamedTag<Gas> EMPTY_GAS_TAG = new SingleElementTag(GasStack.EMPTY.getType());

    @Nullable
    public static ITag.INamedTag<Gas> getGas(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = new ResourceLocation(name.substring(1));
            ITag tag = ChemicalTags.GAS.getCollection().func_199910_a(id);
            if (tag == null) {
                return nullIfNotExists ? null : EMPTY_GAS_TAG;
            }
            return new NamedTagWrapper<Gas>(tag, id);
        }
        ResourceLocation id = new ResourceLocation(name);
        if (!MekanismAPI.gasRegistry().containsKey(id)) {
            return nullIfNotExists ? null : EMPTY_GAS_TAG;
        }
        Gas gas = (Gas)MekanismAPI.gasRegistry().getValue(new ResourceLocation(name));
        if (gas == null) {
            return nullIfNotExists ? null : EMPTY_GAS_TAG;
        }
        return new SingleElementTag<Gas>(gas);
    }

    @Nullable
    public static GasStack getGasContained(ItemStack stack) {
        LazyOptional c = stack.getCapability(ModCapabilities.GAS_HANDLER_CAPABILITY);
        IGasHandler handler = (IGasHandler)c.orElse(null);
        if (handler == null) {
            return null;
        }
        if (handler.getTanks() <= 0) {
            return null;
        }
        return ((GasStack)handler.getChemicalInTank(0)).copy();
    }
}

