/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.net;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.net.Message;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.IPipeContainer;
import de.maxhenkel.pipez.gui.containerfactory.PipeContainerProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateFilterMessage
implements Message<UpdateFilterMessage> {
    private CompoundNBT filter;
    private int index;

    public UpdateFilterMessage() {
    }

    public UpdateFilterMessage(Filter<?> filter, int index) {
        this.filter = filter.serializeNBT();
        this.index = index;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        Container container = context.getSender().field_71070_bA;
        if (container instanceof IPipeContainer) {
            IPipeContainer pipeContainer = (IPipeContainer)container;
            PipeType<?>[] pipeTypes = pipeContainer.getPipe().getPipeTypes();
            if (this.index >= pipeTypes.length) {
                return;
            }
            PipeType<?> pipeType = pipeTypes[this.index];
            Filter<?> f = pipeType.createFilter();
            f.deserializeNBT(this.filter);
            List<Filter<?>> filters = pipeContainer.getPipe().getFilters(pipeContainer.getSide(), pipeType);
            Optional<Filter> editFilter = filters.stream().filter(f1 -> f.getId().equals(f1.getId())).findFirst();
            if (editFilter.isPresent()) {
                editFilter.get().deserializeNBT(this.filter);
            } else {
                filters.add(f);
            }
            pipeContainer.getPipe().setFilters(pipeContainer.getSide(), pipeType, filters);
            PipeContainerProvider.openGui((PlayerEntity)context.getSender(), pipeContainer.getPipe(), pipeContainer.getSide(), this.index, (id, playerInventory, playerEntity) -> new ExtractContainer(id, (IInventory)playerInventory, pipeContainer.getPipe(), pipeContainer.getSide(), this.index));
        }
    }

    @Override
    public UpdateFilterMessage fromBytes(PacketBuffer packetBuffer) {
        this.filter = packetBuffer.func_150793_b();
        this.index = packetBuffer.readInt();
        return this;
    }

    @Override
    public void toBytes(PacketBuffer packetBuffer) {
        packetBuffer.func_150786_a(this.filter);
        packetBuffer.writeInt(this.index);
    }
}

