/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.items;

import de.maxhenkel.pipez.ModItemGroups;
import de.maxhenkel.pipez.Upgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class UpgradeItem
extends Item {
    private final Upgrade tier;

    public UpgradeItem(Upgrade tier) {
        super(new Item.Properties().func_200916_a(ModItemGroups.TAB_PIPEZ));
        this.tier = tier;
        this.setRegistryName(new ResourceLocation("pipez", tier.getName() + "_upgrade"));
    }

    public Upgrade getTier() {
        return this.tier;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            if (tag.func_150297_b("Item", 10)) {
                list.add(new TranslationTextComponent("tooltip.pipez.upgrade.configured.item"));
            }
            if (tag.func_150297_b("Energy", 10)) {
                list.add(new TranslationTextComponent("tooltip.pipez.upgrade.configured.energy"));
            }
            if (tag.func_150297_b("Fluid", 10)) {
                list.add(new TranslationTextComponent("tooltip.pipez.upgrade.configured.fluid"));
            }
            if (tag.func_150297_b("Gas", 10)) {
                list.add(new TranslationTextComponent("tooltip.pipez.upgrade.configured.gas"));
            }
            if (!list.isEmpty()) {
                IFormattableTextComponent types = (IFormattableTextComponent)list.stream().reduce((text1, text2) -> text1.func_240702_b_(", ").func_230529_a_((ITextComponent)text2)).get();
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pipez.upgrade.configured", new Object[]{types.func_240699_a_(TextFormatting.WHITE)}).func_240699_a_(TextFormatting.YELLOW));
            }
        }
    }

    public static ItemStack upgradeData(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof UpgradeItem)) {
            return stack;
        }
        if (!stack.func_77942_o()) {
            return stack;
        }
        boolean isOld = false;
        CompoundNBT oldTag = stack.func_77978_p();
        CompoundNBT newTag = new CompoundNBT();
        CompoundNBT item = new CompoundNBT();
        newTag.func_218657_a("Item", (INBT)item);
        CompoundNBT energy = new CompoundNBT();
        newTag.func_218657_a("Energy", (INBT)energy);
        CompoundNBT fluid = new CompoundNBT();
        newTag.func_218657_a("Fluid", (INBT)fluid);
        CompoundNBT gas = new CompoundNBT();
        newTag.func_218657_a("Gas", (INBT)gas);
        if (oldTag.func_150297_b("RedstoneMode", 1)) {
            item.func_74774_a("RedstoneMode", oldTag.func_74771_c("RedstoneMode"));
            energy.func_74774_a("RedstoneMode", oldTag.func_74771_c("RedstoneMode"));
            fluid.func_74774_a("RedstoneMode", oldTag.func_74771_c("RedstoneMode"));
            gas.func_74774_a("RedstoneMode", oldTag.func_74771_c("RedstoneMode"));
            isOld = true;
        }
        if (oldTag.func_150297_b("Distribution", 1)) {
            item.func_74774_a("Distribution", oldTag.func_74771_c("Distribution"));
            energy.func_74774_a("Distribution", oldTag.func_74771_c("Distribution"));
            fluid.func_74774_a("Distribution", oldTag.func_74771_c("Distribution"));
            gas.func_74774_a("Distribution", oldTag.func_74771_c("Distribution"));
            isOld = true;
        }
        if (oldTag.func_150297_b("FilterMode", 1)) {
            item.func_74774_a("FilterMode", oldTag.func_74771_c("FilterMode"));
            energy.func_74774_a("FilterMode", oldTag.func_74771_c("FilterMode"));
            fluid.func_74774_a("FilterMode", oldTag.func_74771_c("FilterMode"));
            gas.func_74774_a("FilterMode", oldTag.func_74771_c("FilterMode"));
            isOld = true;
        }
        if (oldTag.func_150297_b("ItemFilters", 9)) {
            item.func_218657_a("Filters", (INBT)oldTag.func_150295_c("ItemFilters", 10));
            isOld = true;
        }
        if (oldTag.func_150297_b("FluidFilters", 9)) {
            fluid.func_218657_a("Filters", (INBT)oldTag.func_150295_c("FluidFilters", 10));
            isOld = true;
        }
        if (oldTag.func_150297_b("GasFilters", 9)) {
            gas.func_218657_a("Filters", (INBT)oldTag.func_150295_c("GasFilters", 10));
            isOld = true;
        }
        if (isOld) {
            stack.func_77982_d(newTag);
        }
        return stack;
    }
}

