/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.events;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.items.FilterDestinationToolItem;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockEvents {
    @SubscribeEvent
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        this.onDestinationToolClick(event);
        this.onPipeClick(event);
    }

    private void onPipeClick(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        if (!(state.func_177230_c() instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipe = (PipeBlock)state.func_177230_c();
        Direction side = pipe.getSelection(state, (IBlockReader)event.getWorld(), event.getPos(), event.getPlayer()).getKey();
        ActionResultType result = pipe.onPipeSideForceActivated(state, event.getWorld(), event.getPos(), event.getPlayer(), event.getHand(), event.getHitVec(), side);
        if (result.func_226246_a_()) {
            event.setUseItem(Event.Result.ALLOW);
            event.setCancellationResult(result);
            event.setCanceled(true);
        }
    }

    private void onDestinationToolClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldItem = event.getPlayer().func_184586_b(event.getHand());
        if (!(heldItem.func_77973_b() instanceof FilterDestinationToolItem)) {
            return;
        }
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te == null) {
            return;
        }
        BlockState blockState = event.getWorld().func_180495_p(event.getPos());
        if (blockState.func_177230_c() instanceof PipeBlock) {
            return;
        }
        FilterDestinationToolItem.setDestination(heldItem, new DirectionalPosition(event.getPos().func_185334_h(), event.getFace()));
        event.getPlayer().func_146105_b((ITextComponent)new TranslationTextComponent("message.pipez.filter_destination_tool.destination.set"), true);
        event.setUseItem(Event.Result.ALLOW);
        event.setCancellationResult(ActionResultType.SUCCESS);
        event.setCanceled(true);
    }
}

