/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.configuration.DistributionCache;
import de.maxhenkel.pipez.blocks.tileentity.configuration.FilterCache;
import de.maxhenkel.pipez.blocks.tileentity.configuration.FilterModeCache;
import de.maxhenkel.pipez.blocks.tileentity.configuration.RedstoneModeCache;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.inventory.ItemListInventory;
import de.maxhenkel.pipez.corelib.item.ItemUtils;
import de.maxhenkel.pipez.items.UpgradeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class UpgradeTileEntity
extends PipeTileEntity {
    protected final NonNullList<ItemStack> upgradeInventory = NonNullList.func_191197_a((int)Direction.values().length, (Object)ItemStack.field_190927_a);
    protected final ItemListInventory inventory = new ItemListInventory(this.upgradeInventory, this::invalidateAllCaches);
    protected RedstoneModeCache redstoneModes;
    protected DistributionCache distributions;
    protected FilterModeCache filterModes;
    protected FilterCache filters;

    public UpgradeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.initCaches();
    }

    public void initCaches() {
        this.redstoneModes = new RedstoneModeCache(() -> this.upgradeInventory, PipeType::getDefaultRedstoneMode, this::invalidateAllCaches);
        this.distributions = new DistributionCache(() -> this.upgradeInventory, PipeType::getDefaultDistribution, this::invalidateAllCaches);
        this.filterModes = new FilterModeCache(() -> this.upgradeInventory, PipeType::getDefaultFilterMode, this::invalidateAllCaches);
        this.filters = new FilterCache(() -> this.upgradeInventory, PipeType::createFilter, this::invalidateAllCaches);
    }

    public void invalidateAllCaches() {
        this.redstoneModes.invalidate();
        this.distributions.invalidate();
        this.filterModes.invalidate();
        this.filters.invalidate();
        this.func_70296_d();
    }

    public ItemStack setUpgradeItem(Direction side, ItemStack upgrade) {
        ItemStack old = (ItemStack)this.upgradeInventory.get(side.func_176745_a());
        UpgradeItem.upgradeData(upgrade);
        this.upgradeInventory.set(side.func_176745_a(), (Object)upgrade);
        this.invalidateAllCaches();
        return old;
    }

    public ItemStack getUpgradeItem(Direction side) {
        return (ItemStack)this.upgradeInventory.get(side.func_176745_a());
    }

    public RedstoneMode getRedstoneMode(Direction side, PipeType pipeType) {
        return (RedstoneMode)this.redstoneModes.getValue(side, pipeType);
    }

    public void setRedstoneMode(Direction side, PipeType pipeType, RedstoneMode redstoneMode) {
        this.redstoneModes.setValue(side, pipeType, redstoneMode);
    }

    public Distribution getDistribution(Direction side, PipeType pipeType) {
        return (Distribution)this.distributions.getValue(side, pipeType);
    }

    public void setDistribution(Direction side, PipeType pipeType, Distribution distribution) {
        this.distributions.setValue(side, pipeType, distribution);
    }

    public FilterMode getFilterMode(Direction side, PipeType pipeType) {
        return (FilterMode)this.filterModes.getValue(side, pipeType);
    }

    public void setFilterMode(Direction side, PipeType pipeType, FilterMode filterMode) {
        this.filterModes.setValue(side, pipeType, filterMode);
    }

    public <T> List<Filter<?>> getFilters(Direction side, PipeType<T> pipeType) {
        return (List)this.filters.getValue(side, pipeType);
    }

    public <T> void setFilters(Direction side, PipeType<T> pipeType, List<Filter<?>> filter) {
        this.filters.setValue(side, pipeType, filter);
    }

    @Override
    public void setExtracting(Direction side, boolean extracting) {
        super.setExtracting(side, extracting);
        if (!extracting) {
            ItemStack stack = (ItemStack)this.upgradeInventory.get(side.func_176745_a());
            this.upgradeInventory.set(side.func_176745_a(), (Object)ItemStack.field_190927_a);
            InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (NonNullList)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{stack}));
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, this.upgradeInventory);
        super.func_145843_s();
    }

    public IInventory getUpgradeInventory() {
        return this.inventory;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.upgradeInventory.clear();
        ItemUtils.readInventory(compound, "Upgrades", this.upgradeInventory);
        for (ItemStack stack : this.upgradeInventory) {
            UpgradeItem.upgradeData(stack);
        }
        this.invalidateAllCaches();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ItemUtils.saveInventory(compound, "Upgrades", this.upgradeInventory);
        return super.func_189515_b(compound);
    }

    @Nullable
    public Upgrade getUpgrade(Direction direction) {
        ItemStack stack = (ItemStack)this.upgradeInventory.get(direction.func_176745_a());
        if (stack.func_77973_b() instanceof UpgradeItem) {
            return ((UpgradeItem)stack.func_77973_b()).getTier();
        }
        return null;
    }

    public List<PipeTileEntity.Connection> getSortedConnections(Direction side, PipeType pipeType) {
        Distribution distribution = this.getDistribution(side, pipeType);
        switch (distribution) {
            case FURTHEST: {
                return this.getConnections().stream().sorted((o1, o2) -> Integer.compare(o2.getDistance(), o1.getDistance())).collect(Collectors.toList());
            }
            case RANDOM: {
                ArrayList<PipeTileEntity.Connection> shuffle = new ArrayList<PipeTileEntity.Connection>(this.getConnections());
                Collections.shuffle(shuffle);
                return shuffle;
            }
        }
        return this.getConnections().stream().sorted(Comparator.comparingInt(PipeTileEntity.Connection::getDistance)).collect(Collectors.toList());
    }

    public static interface ICyclable<T extends Enum<?>> {
        public T cycle();
    }

    public static enum FilterMode implements ICyclable<FilterMode>
    {
        WHITELIST("whitelist"),
        BLACKLIST("blacklist");

        private final String name;

        private FilterMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public FilterMode cycle() {
            return FilterMode.values()[Math.floorMod(this.ordinal() + 1, FilterMode.values().length)];
        }
    }

    public static enum RedstoneMode implements ICyclable<RedstoneMode>
    {
        IGNORED("ignored"),
        OFF_WHEN_POWERED("off_when_powered"),
        ON_WHEN_POWERED("on_when_powered"),
        ALWAYS_OFF("always_off");

        private final String name;

        private RedstoneMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public RedstoneMode cycle() {
            return RedstoneMode.values()[Math.floorMod(this.ordinal() + 1, RedstoneMode.values().length)];
        }
    }

    public static enum Distribution implements ICyclable<Distribution>
    {
        NEAREST("nearest"),
        FURTHEST("furthest"),
        ROUND_ROBIN("round_robin"),
        RANDOM("random");

        private final String name;

        private Distribution(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Distribution cycle() {
            return Distribution.values()[Math.floorMod(this.ordinal() + 1, Distribution.values().length)];
        }
    }
}

