/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks;

import de.maxhenkel.pipez.ModItemGroups;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.corelib.block.IItemBlock;
import de.maxhenkel.pipez.corelib.block.VoxelUtils;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.corelib.helpers.Triple;
import de.maxhenkel.pipez.items.UpgradeItem;
import de.maxhenkel.pipez.items.WrenchItem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public abstract class PipeBlock
extends Block
implements IItemBlock,
IWaterLoggable,
ITileEntityProvider {
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty HAS_DATA = BooleanProperty.func_177716_a((String)"has_data");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)0.0);
    public static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_UP = Block.func_208617_a((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)0.0, (double)11.0);
    public static final VoxelShape SHAPE_CORE = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_EXTRACT_NORTH = VoxelUtils.combine(SHAPE_NORTH, Block.func_208617_a((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)0.0));
    public static final VoxelShape SHAPE_EXTRACT_SOUTH = VoxelUtils.combine(SHAPE_SOUTH, Block.func_208617_a((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0));
    public static final VoxelShape SHAPE_EXTRACT_EAST = VoxelUtils.combine(SHAPE_EAST, Block.func_208617_a((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
    public static final VoxelShape SHAPE_EXTRACT_WEST = VoxelUtils.combine(SHAPE_WEST, Block.func_208617_a((double)1.0, (double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0));
    public static final VoxelShape SHAPE_EXTRACT_UP = VoxelUtils.combine(SHAPE_UP, Block.func_208617_a((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
    public static final VoxelShape SHAPE_EXTRACT_DOWN = VoxelUtils.combine(SHAPE_DOWN, Block.func_208617_a((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)0.0, (double)12.0));
    private static final List<Triple<VoxelShape, BooleanProperty, Direction>> SHAPES = Arrays.asList(new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_NORTH, NORTH, Direction.NORTH), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_SOUTH, SOUTH, Direction.SOUTH), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_WEST, WEST, Direction.WEST), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_EAST, EAST, Direction.EAST), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_UP, UP, Direction.UP), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_DOWN, DOWN, Direction.DOWN));
    private static final List<Pair<VoxelShape, Direction>> EXTRACT_SHAPES = Arrays.asList(new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_NORTH, Direction.NORTH), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_SOUTH, Direction.SOUTH), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_WEST, Direction.WEST), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_EAST, Direction.EAST), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_UP, Direction.UP), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_DOWN, Direction.DOWN));

    protected PipeBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_DATA, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ModItemGroups.TAB_PIPEZ)).setRegistryName(this.getRegistryName());
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Direction side = this.getSelection(state, (IBlockReader)worldIn, pos, player).getKey();
        if (side != null) {
            return this.onPipeSideActivated(state, worldIn, pos, player, handIn, hit, side);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public ActionResultType onWrenchClicked(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit, Direction side) {
        if (!player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        if (side != null) {
            if (worldIn.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this) {
                boolean extracting = this.isExtracting((IWorldReader)worldIn, pos, side);
                if (extracting) {
                    this.setExtracting(worldIn, pos, side, false);
                    this.setDisconnected(worldIn, pos, side, true);
                } else {
                    this.setExtracting(worldIn, pos, side, true);
                    this.setDisconnected(worldIn, pos, side, false);
                }
            } else {
                this.setDisconnected(worldIn, pos, side, true);
            }
        } else {
            side = hit.func_216354_b();
            if (worldIn.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this) {
                this.setExtracting(worldIn, pos, side, false);
                if (this.isAbleToConnect((IWorldReader)worldIn, pos, side)) {
                    this.setDisconnected(worldIn, pos, side, false);
                }
            } else {
                this.setDisconnected(worldIn, pos, side, false);
                this.setDisconnected(worldIn, pos.func_177972_a(side), side.func_176734_d(), false);
            }
        }
        PipeTileEntity.markPipesDirty(worldIn, pos);
        return ActionResultType.SUCCESS;
    }

    public ActionResultType onPipeSideActivated(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit, Direction direction) {
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public ActionResultType onPipeSideForceActivated(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit, @Nullable Direction side) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (WrenchItem.isWrench(heldItem)) {
            return this.onWrenchClicked(state, world, pos, player, hand, hit, side);
        }
        if (heldItem.func_77973_b() instanceof UpgradeItem && player.func_225608_bj_() && side != null) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof UpgradeTileEntity)) {
                return ActionResultType.PASS;
            }
            UpgradeTileEntity upgradeTe = (UpgradeTileEntity)te;
            ItemStack oldUpgrade = player.field_71075_bZ.field_75098_d ? upgradeTe.setUpgradeItem(side, heldItem.func_77946_l().func_77979_a(1)) : upgradeTe.setUpgradeItem(side, heldItem.func_77979_a(1));
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, oldUpgrade);
            } else if (!player.field_71071_by.func_70441_a(oldUpgrade)) {
                player.func_71019_a(oldUpgrade, true);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public BooleanProperty getProperty(Direction side) {
        switch (side) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
        }
        return DOWN;
    }

    public boolean isExtracting(IWorldReader world, BlockPos pos, Direction side) {
        PipeTileEntity pipe = this.getTileEntity(world, pos);
        if (pipe == null) {
            return false;
        }
        return pipe.isExtracting(side);
    }

    public boolean isDisconnected(IWorldReader world, BlockPos pos, Direction side) {
        PipeTileEntity pipe = this.getTileEntity(world, pos);
        if (pipe == null) {
            return false;
        }
        return pipe.isDisconnected(side);
    }

    public void setHasData(World world, BlockPos pos, boolean hasData) {
        BlockState blockState = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)blockState.func_206870_a((Property)HAS_DATA, (Comparable)Boolean.valueOf(hasData)));
    }

    public void setExtracting(World world, BlockPos pos, Direction side, boolean extracting) {
        boolean connected;
        BooleanProperty sideProperty;
        BlockState blockState;
        PipeTileEntity pipe = this.getTileEntity((IWorldReader)world, pos);
        if (pipe == null) {
            if (extracting) {
                this.setHasData(world, pos, true);
                pipe = this.getTileEntity((IWorldReader)world, pos);
                if (pipe != null) {
                    pipe.setExtracting(side, extracting);
                }
            }
        } else {
            pipe.setExtracting(side, extracting);
            if (!pipe.hasReasonToStay()) {
                this.setHasData(world, pos, false);
            }
        }
        world.func_175656_a(pos, (BlockState)blockState.func_206870_a((Property)sideProperty, (Comparable)Boolean.valueOf(!(connected = ((Boolean)(blockState = world.func_180495_p(pos)).func_177229_b((Property)(sideProperty = this.getProperty(side)))).booleanValue()))));
        world.func_175656_a(pos, (BlockState)blockState.func_206870_a((Property)sideProperty, (Comparable)Boolean.valueOf(connected)));
    }

    public void setDisconnected(World world, BlockPos pos, Direction side, boolean disconnected) {
        PipeTileEntity pipe = this.getTileEntity((IWorldReader)world, pos);
        if (pipe == null) {
            if (disconnected) {
                this.setHasData(world, pos, true);
                pipe = this.getTileEntity((IWorldReader)world, pos);
                if (pipe != null) {
                    pipe.setDisconnected(side, disconnected);
                    world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)this.getProperty(side), (Comparable)Boolean.valueOf(false)));
                }
            }
        } else {
            pipe.setDisconnected(side, disconnected);
            if (!pipe.hasReasonToStay()) {
                this.setHasData(world, pos, false);
            }
            world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)this.getProperty(side), (Comparable)Boolean.valueOf(!disconnected)));
        }
    }

    @Nullable
    public PipeTileEntity getTileEntity(IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PipeTileEntity) {
            return (PipeTileEntity)te;
        }
        return null;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getState(context.func_195991_k(), context.func_195995_a(), null);
    }

    private BlockState getState(World world, BlockPos pos, @Nullable BlockState oldState) {
        FluidState fluidState = world.func_204610_c(pos);
        boolean hasData = false;
        if (oldState != null && oldState.func_177230_c() == this) {
            hasData = (Boolean)oldState.func_177229_b((Property)HAS_DATA);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)UP, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, pos, Direction.UP)))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, pos, Direction.DOWN)))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, pos, Direction.NORTH)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, pos, Direction.SOUTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, pos, Direction.EAST)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, pos, Direction.WEST)))).func_206870_a((Property)HAS_DATA, (Comparable)Boolean.valueOf(hasData))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && fluidState.func_206882_g() == 8));
    }

    public boolean isConnected(IWorldReader world, BlockPos pos, Direction facing) {
        boolean canSelfConnect;
        PipeTileEntity pipe = this.getTileEntity(world, pos);
        PipeTileEntity other = this.getTileEntity(world, pos.func_177972_a(facing));
        if (!this.isAbleToConnect(world, pos, facing)) {
            return false;
        }
        boolean bl = canSelfConnect = pipe == null || !pipe.isDisconnected(facing);
        if (!canSelfConnect) {
            return false;
        }
        boolean canSideConnect = other == null || !other.isDisconnected(facing.func_176734_d());
        return canSideConnect;
    }

    public boolean isAbleToConnect(IWorldReader world, BlockPos pos, Direction facing) {
        return this.isPipe(world, pos, facing) || this.canConnectTo(world, pos, facing);
    }

    public abstract boolean canConnectTo(IWorldReader var1, BlockPos var2, Direction var3);

    public abstract boolean isPipe(IWorldReader var1, BlockPos var2, Direction var3);

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        super.func_220069_a(state, world, pos, block, pos1, b);
        BlockState newState = this.getState(world, pos, state);
        if (!state.func_235904_r_().stream().allMatch(property -> state.func_177229_b(property).equals(newState.func_177229_b(property)))) {
            world.func_175656_a(pos, newState);
            PipeTileEntity.markPipesDirty(world, pos);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, HAS_DATA, WATERLOGGED});
    }

    public VoxelShape getShape(IBlockReader blockReader, BlockPos pos, BlockState state, boolean advanced) {
        PipeTileEntity pipe = null;
        if (advanced && blockReader instanceof IWorldReader) {
            pipe = this.getTileEntity((IWorldReader)blockReader, pos);
        }
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.UP) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_UP) : VoxelUtils.combine(shape, SHAPE_UP);
        }
        if (((Boolean)state.func_177229_b((Property)DOWN)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.DOWN) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_DOWN) : VoxelUtils.combine(shape, SHAPE_DOWN);
        }
        if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.SOUTH) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_SOUTH) : VoxelUtils.combine(shape, SHAPE_SOUTH);
        }
        if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.NORTH) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_NORTH) : VoxelUtils.combine(shape, SHAPE_NORTH);
        }
        if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.EAST) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_EAST) : VoxelUtils.combine(shape, SHAPE_EAST);
        }
        if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.WEST) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_WEST) : VoxelUtils.combine(shape, SHAPE_WEST);
        }
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        EntitySelectionContext ctx;
        if (context instanceof EntitySelectionContext && (ctx = (EntitySelectionContext)context).getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)ctx.getEntity();
            if (player.field_70170_p.field_72995_K) {
                return this.getSelectionShape(state, worldIn, pos, player);
            }
        }
        return this.getShape(worldIn, pos, state, true);
    }

    public VoxelShape getSelectionShape(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        Pair<Direction, VoxelShape> selection = this.getSelection(state, world, pos, player);
        if (selection.getKey() == null) {
            return this.getShape(world, pos, state, true);
        }
        if (world.func_180495_p(pos.func_177972_a(selection.getKey())).func_177230_c() == this && !WrenchItem.isHoldingWrench(player)) {
            return this.getShape(world, pos, state, true);
        }
        return selection.getValue();
    }

    public Pair<Direction, VoxelShape> getSelection(BlockState state, IBlockReader blockReader, BlockPos pos, PlayerEntity player) {
        Vector3d start = player.func_174824_e(1.0f);
        Vector3d end = start.func_178787_e(player.func_70040_Z().func_72432_b().func_186678_a((double)this.getBlockReachDistance(player)));
        Direction direction = null;
        VoxelShape selection = null;
        double shortest = Double.MAX_VALUE;
        double d = this.checkShape(state, blockReader, pos, start, end, SHAPE_CORE, null);
        if (d < shortest) {
            shortest = d;
        }
        if (!(blockReader instanceof IWorldReader)) {
            return new Pair<Object, Object>(direction, selection);
        }
        PipeTileEntity pipe = this.getTileEntity((IWorldReader)blockReader, pos);
        for (int i = 0; i < Direction.values().length; ++i) {
            Pair<VoxelShape, Direction> extract = EXTRACT_SHAPES.get(i);
            Triple<VoxelShape, BooleanProperty, Direction> shape = SHAPES.get(i);
            if (pipe != null && pipe.isExtracting(extract.getValue())) {
                d = this.checkShape(state, blockReader, pos, start, end, extract.getKey(), pipe, extract.getValue());
                if (!(d < shortest)) continue;
                shortest = d;
                direction = extract.getValue();
                selection = extract.getKey();
                continue;
            }
            d = this.checkShape(state, blockReader, pos, start, end, shape.getValue1(), shape.getValue2());
            if (!(d < shortest)) continue;
            shortest = d;
            direction = shape.getValue3();
            selection = shape.getValue1();
        }
        return new Pair<Object, Object>(direction, selection);
    }

    public float getBlockReachDistance(PlayerEntity player) {
        float distance = (float)player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        return player.func_184812_l_() ? distance : distance - 0.5f;
    }

    private double checkShape(BlockState state, IBlockReader world, BlockPos pos, Vector3d start, Vector3d end, VoxelShape shape, BooleanProperty direction) {
        if (direction != null && !((Boolean)state.func_177229_b((Property)direction)).booleanValue()) {
            return Double.MAX_VALUE;
        }
        BlockRayTraceResult blockRayTraceResult = world.func_217296_a(start, end, pos, shape, state);
        if (blockRayTraceResult == null) {
            return Double.MAX_VALUE;
        }
        return blockRayTraceResult.func_216347_e().func_72438_d(start);
    }

    private double checkShape(BlockState state, IBlockReader world, BlockPos pos, Vector3d start, Vector3d end, VoxelShape shape, @Nullable PipeTileEntity pipe, Direction side) {
        if (pipe != null && !pipe.isExtracting(side)) {
            return Double.MAX_VALUE;
        }
        BlockRayTraceResult blockRayTraceResult = world.func_217296_a(start, end, pos, shape, state);
        if (blockRayTraceResult == null) {
            return Double.MAX_VALUE;
        }
        return blockRayTraceResult.func_216347_e().func_72438_d(start);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_203425_a(newState.func_177230_c())) {
            if (!((Boolean)newState.func_177229_b((Property)HAS_DATA)).booleanValue()) {
                worldIn.func_175713_t(pos);
            }
        } else {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.getShape(worldIn, pos, state, false);
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.getShape(reader, pos, state, false);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShape(worldIn, pos, state, false);
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getShape(reader, pos, state, false);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.getShape(worldIn, pos, state, false);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return null;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (((Boolean)state.func_177229_b((Property)HAS_DATA)).booleanValue()) {
            return this.createTileEntity();
        }
        return null;
    }

    abstract TileEntity createTileEntity();

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((Property)HAS_DATA);
    }
}

