/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import de.maxhenkel.pipez.corelib.CachedValue;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;

public class ModelRegistry {
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Model model : Model.values()) {
            ModelLoader.instance();
            ModelLoader.addSpecialModel((ResourceLocation)model.getResourceLocation());
        }
    }

    public static void onModelBake(ModelBakeEvent event) {
        for (Model model : Model.values()) {
            model.getCachedModel().invalidate();
        }
    }

    public static enum Model {
        ENERGY_PIPE_EXTRACT("block/energy_pipe_extract"),
        FLUID_PIPE_EXTRACT("block/fluid_pipe_extract"),
        GAS_PIPE_EXTRACT("block/gas_pipe_extract"),
        ITEM_PIPE_EXTRACT("block/item_pipe_extract"),
        UNIVERSAL_PIPE_EXTRACT("block/universal_pipe_extract");

        private final ResourceLocation resource;
        private final CachedValue<IBakedModel> cachedModel;

        private Model(String name) {
            this.resource = new ResourceLocation("pipez", name);
            this.cachedModel = new CachedValue<IBakedModel>(() -> {
                IUnbakedModel modelOrMissing = ModelLoader.instance().getModelOrMissing(this.resource);
                return modelOrMissing.func_225613_a_((ModelBakery)ModelLoader.instance(), arg_0 -> ((SpriteMap)ModelLoader.instance().getSpriteMap()).func_229151_a_(arg_0), (IModelTransform)ModelRotation.X0_Y0, this.resource);
            });
        }

        public ResourceLocation getResourceLocation() {
            return this.resource;
        }

        public CachedValue<IBakedModel> getCachedModel() {
            return this.cachedModel;
        }
    }
}

