/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.ui;

import com.valkyrieofnight.envirocore.m_machines.ECMachinesModule;
import com.valkyrieofnight.enviroenergyapi.util.EnergyUtil;
import com.valkyrieofnight.envirotech.m_voidminer.MVoidMiner;
import com.valkyrieofnight.envirotech.m_voidminer.tile.VoidMinerCCUTile;
import com.valkyrieofnight.envirotech.m_voidminer.ui.VoidMinerContainer;
import com.valkyrieofnight.envirotech.m_voidminer.ui.VoidMinerDropGUI;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizablePanelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.guage.ImageProgressBarElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.ImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.inventory.SlotsArrayElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.SideMenuButton;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.LabelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.ProgressionDirection;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.tooltip.ITooltipBuilder;
import com.valkyrieofnight.vlib.core.util.tooltip.QuickTooltips;
import com.valkyrieofnight.vlib.multiblock.ui.client.ControllerGui;
import com.valkyrieofnight.vlib.multiblock.ui.container.ControllerContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class VoidMinerGUI
extends ControllerGui<VoidMinerCCUTile, VoidMinerContainer> {
    private VoidMinerCCUTile tile;
    private ImageProgressBarElement energyGuage;
    private ImageProgressBarElement progress;
    private QuickTooltips.Map energyGuageTooltips = QuickTooltips.createMap();
    private LabelElement energyTickCost;
    private LabelElement duration;
    private SideMenuButton dropsMenu;

    public VoidMinerGUI(VoidMinerContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((ControllerContainer)container, playerInventory, title);
        this.tile = (VoidMinerCCUTile)container.getTile();
        this.setGuiSize(176, 168);
    }

    protected void addElementsInternalPost() {
        super.addElementsInternalPost();
        AssetID col_e = StandardThemeAssets.COL_BUTTON_ICON_ENABLED;
        AssetID col_h = StandardThemeAssets.COL_BUTTON_ICON_HOVER;
        AssetID dropsIcon = MVoidMiner.DROPS_MENU_ICON;
        this.dropsMenu = new SideMenuButton("drops", 12, 12, dropsIcon, dropsIcon, dropsIcon, dropsIcon);
        this.dropsMenu.addToolTip((ITextComponent)new TranslationTextComponent("label.envirotech.minable_drops"));
        this.dropsMenu.setColors(col_e, col_h, col_h, col_h);
        this.addElement((IElement)this.dropsMenu, this.getSideMenuX(), this.getSizeMenuY());
        this.nextMenuButton();
    }

    protected void addElements() {
        this.addElement((IElement)new SizablePanelElement("gbg", ECMachinesModule.GSB_DARK_PANEL, 160, 56), 8, 16);
        this.addElement((IElement)new ImageElement("overlay", MVoidMiner.VOID_MINER_OVERLAY), 0, 0);
        SlotsArrayElement sae = new SlotsArrayElement("slots", this.field_147002_h, StandardThemeAssets.TEX_VANILLA_SLOT);
        this.addElement((IElement)sae, 0, 0);
        this.addElement((IElement)new SizablePanelElement("energy_inner", ECMachinesModule.GSB_DARK_INNER_PANEL, 10, 50), 11, 19);
        this.energyGuage = new ImageProgressBarElement("energy", ECMachinesModule.ENERGY_BAR_08X48, ProgressionDirection.UPWARD, this::getEnergyScale);
        this.addElement((IElement)this.energyGuage, 12, 20);
        this.energyGuage.setToolTips((ITooltipBuilder)this.energyGuageTooltips);
        this.energyGuageTooltips.set(0, (ITextComponent)new TranslationTextComponent("label.envirocore.energy.storage").func_230530_a_(StyleUtil.create((Color4)Color4.AZURE)));
        this.addElement((IElement)new LabelElement("inventory", this.field_213127_e.func_145748_c_(), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT), 8, this.field_147000_g - 96 + 3);
        this.energyTickCost = new LabelElement("energy_tick", (ITextComponent)new TranslationTextComponent("label.envirotech.energy_tick").func_230529_a_((ITextComponent)new StringTextComponent(": " + this.tile.getFETickCost())), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        this.addElement((IElement)this.energyTickCost, 40, 60);
        this.duration = new LabelElement("dur", (ITextComponent)new TranslationTextComponent("label.envirotech.duration"), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        this.addElement((IElement)this.duration, 40, 22);
    }

    public void update() {
        this.energyTickCost.setText((ITextComponent)new TranslationTextComponent("label.envirotech.energy_tick").func_230529_a_((ITextComponent)new StringTextComponent(": " + this.tile.getFETickCost())));
        this.duration.setText((ITextComponent)new TranslationTextComponent("label.envirotech.duration").func_230529_a_((ITextComponent)new StringTextComponent(": " + this.tile.getDuration())));
        super.update();
        this.energyGuageTooltips.set(1, (ITextComponent)new TranslationTextComponent("label.envirocore.capacity").func_230530_a_(StyleUtil.create((Color4)Color4.DARK_RED)).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%,d", EnergyUtil.FE_CONVERTER.convertFromPotential(this.tile.getPotentialCapacity())))));
        this.energyGuageTooltips.set(2, (ITextComponent)new TranslationTextComponent("label.envirocore.stored").func_230530_a_(StyleUtil.create((Color4)Color4.DARK_RED)).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%,d", EnergyUtil.FE_CONVERTER.convertFromPotential(this.tile.getPotentialStored())))));
    }

    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
        if (element == this.dropsMenu) {
            Minecraft.func_71410_x().func_147108_a((Screen)new VoidMinerDropGUI(this.tile, this.player, this));
        }
    }

    public float getEnergyScale() {
        return this.tile.getEnergyScaled();
    }

    public float getProgressScale() {
        return this.tile.getProgressScale();
    }
}

