/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.valkyrieofnight.envirotech.m_voidminer.tile.VoidMinerCCUTile;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.math.BlockPosUtil;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class TileVoidMinerRenderer
extends TileEntityRenderer<VoidMinerCCUTile> {
    public static final ResourceLocation TEXTURE_LASER = new ResourceLocation("envirotech:textures/entity/void_laser.png");

    public TileVoidMinerRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(VoidMinerCCUTile te, float partial, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockPos cp = te.func_174877_v();
        XYZOrientation o = te.getOrientation();
        Color4 lensColor = te.getLensColor();
        BlockPos lensPos = te.getLensHolderPos();
        BlockPos beamEnd = te.getBeamEnd();
        if (!te.isFormed() || !te.canRender() || o == null || lensColor == null || lensPos == null || beamEnd == null) {
            return;
        }
        Direction down = o.getDirectionFrom(RelativeDirection.FORWARD);
        Direction up = o.getDirectionFrom(RelativeDirection.BACKWARD);
        if (down == null || up == null) {
            return;
        }
        float wm = te.getBeamWidthMultiplier();
        float fm = 40.0f - te.getFrequencyMultiplier();
        float am = te.getAmplificationMultiplier();
        float innerWidth = MathUtil.clamp((float)(wm * 0.0024f + 0.12f), (float)0.12f, (float)0.24f);
        float outerWidth = MathUtil.clamp((float)(wm * 0.0024f + 0.16f), (float)0.16f, (float)0.3f);
        float l1 = (float)Math.abs(BlockPosUtil.getDirectionDistance((BlockPos)cp, (BlockPos)lensPos, (Direction)down)) - 0.5f;
        float l2 = Math.abs(BlockPosUtil.getDirectionDistance((BlockPos)lensPos, (BlockPos)beamEnd, (Direction)down));
        float[] col = new float[]{lensColor.getR(), lensColor.getG(), lensColor.getB()};
        float x2 = -l1 * (float)up.func_176730_m().func_177958_n();
        float y2 = -l1 * (float)up.func_176730_m().func_177956_o();
        float z2 = -l1 * (float)up.func_176730_m().func_177952_p();
        stack.func_227860_a_();
        stack.func_227861_a_(0.5, 0.5, 0.5);
        float rotation = 360.0f / fm;
        long time = (long)(360.0f / rotation);
        float f = (float)Math.floorMod(te.func_145831_w().func_82737_E(), time) + partial;
        float rot = rotation * f - 45.0f;
        stack.func_227860_a_();
        stack.func_227863_a_(down.func_229386_k_().func_229187_a_(rot));
        stack.func_227860_a_();
        stack.func_227863_a_(down.func_229384_a_());
        TileVoidMinerRenderer.renderLaserI(stack, buffer, TEXTURE_LASER, 1.0f, 1.0f, 0.5f, l1, new float[]{1.0f, 1.0f, 1.0f}, innerWidth);
        stack.func_227865_b_();
        stack.func_227865_b_();
        stack.func_227860_a_();
        stack.func_227861_a_((double)x2, (double)y2, (double)z2);
        stack.func_227863_a_(down.func_229386_k_().func_229187_a_(rot));
        stack.func_227860_a_();
        stack.func_227863_a_(down.func_229384_a_());
        TileVoidMinerRenderer.renderLaserI(stack, buffer, TEXTURE_LASER, 1.0f, 1.0f, 0.5f, l2, col, innerWidth);
        stack.func_227865_b_();
        stack.func_227865_b_();
        stack.func_227865_b_();
    }

    public static void renderLaserI(MatrixStack stack, IRenderTypeBuffer render, ResourceLocation tex, float animScale, float something, float startY, float length, float[] col, float scale) {
        float endY = startY + length;
        float x1 = 0.0f;
        float z1 = scale;
        float x2 = scale;
        float z2 = 0.0f;
        float x3 = -scale;
        float z3 = 0.0f;
        float x4 = 0.0f;
        float z4 = -scale;
        float v2 = -1.0f + animScale;
        float u2 = length * something * (0.5f / scale) + v2;
        TileVoidMinerRenderer.renderPart(stack, render.getBuffer(RenderType.func_228637_a_((ResourceLocation)tex, (boolean)false)), col[0], col[1], col[2], 1.0f, startY, endY, x1, z1, x2, z2, x3, z3, x4, z4, 0.0f, 1.0f, u2, v2);
    }

    public static void renderLaserO(MatrixStack stack, IRenderTypeBuffer render, ResourceLocation tex, float animScale, float something, float startY, float length, float[] col, float scale) {
        float endY = startY + length;
        float x1 = 0.0f;
        float z1 = scale;
        float x2 = scale;
        float z2 = 0.0f;
        float x3 = -scale;
        float z3 = 0.0f;
        float x4 = 0.0f;
        float z4 = -scale;
        float v2 = -1.0f + animScale;
        float u2 = length * something * (0.5f / scale) + v2;
        TileVoidMinerRenderer.renderPart(stack, render.getBuffer(RenderType.func_228637_a_((ResourceLocation)tex, (boolean)true)), col[0], col[1], col[2], 0.125f, startY, endY, x1, z1, x2, z2, x3, z3, x4, z4, 0.0f, 1.0f, u2, v2);
    }

    public static void renderBeaconBeam(MatrixStack stack, IRenderTypeBuffer render, ResourceLocation tex, float partial, float something, long time, float startY, float segLength, float[] col, float innerScale, float outerScale) {
        float timeScale;
        float endY = startY + segLength;
        stack.func_227860_a_();
        float direction = timeScale = (float)Math.floorMod(time, 40L) + partial;
        float animScale = MathHelper.func_226164_h_((float)(direction * 0.2f - (float)MathHelper.func_76141_d((float)(direction * 0.1f))));
        float r = col[0];
        float g = col[1];
        float b = col[2];
        stack.func_227860_a_();
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(timeScale * 2.25f - 45.0f));
        float x1 = 0.0f;
        float z1 = innerScale;
        float x2 = innerScale;
        float z2 = 0.0f;
        float x3 = -innerScale;
        float z3 = 0.0f;
        float x4 = 0.0f;
        float z4 = -innerScale;
        float v2 = -1.0f + animScale;
        float u2 = segLength * something * (0.5f / innerScale) + v2;
        TileVoidMinerRenderer.renderPart(stack, render.getBuffer(RenderType.func_228637_a_((ResourceLocation)tex, (boolean)false)), r, g, b, 1.0f, startY, endY, x1, z1, x2, z2, x3, z3, x4, z4, 0.0f, 1.0f, u2, v2);
        stack.func_227865_b_();
        x1 = 0.0f;
        z1 = outerScale;
        x2 = outerScale;
        z2 = 0.0f;
        x3 = -outerScale;
        z3 = 0.0f;
        x4 = 0.0f;
        z4 = -outerScale;
        TileVoidMinerRenderer.renderPart(stack, render.getBuffer(RenderType.func_228637_a_((ResourceLocation)tex, (boolean)true)), r, g, b, 0.125f, startY, endY, x1, z1, x2, z2, x3, z3, x4, z4, 0.0f, 1.0f, u2, v2);
        stack.func_227865_b_();
    }

    private static void renderPart(MatrixStack stack, IVertexBuilder vb, float r, float g, float b, float a, float y1, float y2, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float u1, float v1, float u2, float v2) {
        MatrixStack.Entry lastStack = stack.func_227866_c_();
        Matrix4f pose = lastStack.func_227870_a_();
        Matrix3f norm = lastStack.func_227872_b_();
        TileVoidMinerRenderer.renderQuad(pose, norm, vb, r, g, b, a, y1, y2, x1, z1, x2, z2, u1, v1, u2, v2);
        TileVoidMinerRenderer.renderQuad(pose, norm, vb, r, g, b, a, y1, y2, x4, z4, x3, z3, u1, v1, u2, v2);
        TileVoidMinerRenderer.renderQuad(pose, norm, vb, r, g, b, a, y1, y2, x2, z2, x4, z4, u1, v1, u2, v2);
        TileVoidMinerRenderer.renderQuad(pose, norm, vb, r, g, b, a, y1, y2, x3, z3, x1, z1, u1, v1, u2, v2);
    }

    private static void renderQuad(Matrix4f pose, Matrix3f norm, IVertexBuilder vb, float r, float g, float b, float a, float y1, float y2, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        TileVoidMinerRenderer.addVertex(pose, norm, vb, r, g, b, a, y2, x1, z1, u2, v1);
        TileVoidMinerRenderer.addVertex(pose, norm, vb, r, g, b, a, y1, x1, z1, u2, v2);
        TileVoidMinerRenderer.addVertex(pose, norm, vb, r, g, b, a, y1, x2, z2, u1, v2);
        TileVoidMinerRenderer.addVertex(pose, norm, vb, r, g, b, a, y2, x2, z2, u1, v1);
    }

    private static void addVertex(Matrix4f pose, Matrix3f norm, IVertexBuilder vb, float r, float g, float b, float a, float y, float x, float z, float u, float v) {
        vb.func_227888_a_(pose, x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(norm, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public boolean shouldRenderOffScreen(VoidMinerCCUTile te) {
        return true;
    }
}

