/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.Drop;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.DropTarget;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.FocusList;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.IAddToDropList;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class BiomeList
implements IAddToDropList {
    private final VLID biome;
    private volatile CopyOnWriteArrayList<Drop> unfocused = Lists.newCopyOnWriteArrayList();
    private volatile ConcurrentMap<VLID, FocusList> focusLists = Maps.newConcurrentMap();

    public BiomeList(VLID biome) {
        this.biome = biome;
    }

    @Override
    public void addToDropList(Map<VLID, Drop> drops, int tier, @Nullable VLID focus, float focusWeightMultiplier, DropTarget dropTarget, @Nullable VLID dim, @Nullable VLID biome) {
        if (focus != null && this.focusLists.containsKey(focus)) {
            ((FocusList)this.focusLists.get(focus)).addToDropList(drops, tier, focus, focusWeightMultiplier, dropTarget, dim, biome);
        }
        for (Drop d : this.unfocused) {
            if (!d.isValid() || !d.tiers.contains(tier) || !this.canAddDrop(d, dropTarget, dim, biome)) continue;
            drops.putIfAbsent(d.recipeID, d);
        }
    }

    public void register(Drop d, VLID focus) {
        if (focus == null) {
            this.unfocused.add(d);
        } else {
            this.focusLists.computeIfAbsent(focus, fid -> new FocusList((VLID)fid));
            this.focusLists.computeIfPresent(focus, (fid, focusList) -> {
                focusList.register(d);
                return focusList;
            });
        }
    }

    public String toString() {
        for (FocusList fl : this.focusLists.values()) {
            fl.toString();
        }
        return super.toString();
    }
}

