/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.proxy;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.client.ClientHandlerModEventBus;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.entity.mahoujin.ReplicaTeleportMahoujinEntity;
import stepsword.mahoutsukai.item.guide.ContentsPage;
import stepsword.mahoutsukai.item.guide.DoubleInfoPage;
import stepsword.mahoutsukai.item.guide.GuidebookInstance;
import stepsword.mahoutsukai.item.guide.InfoPage;
import stepsword.mahoutsukai.item.guide.Page;
import stepsword.mahoutsukai.item.guide.SpellPage;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ProjectorRightClickPacket;
import stepsword.mahoutsukai.proxy.CommonProxy;
import stepsword.mahoutsukai.render.gui.FogProjectorScreen;
import stepsword.mahoutsukai.render.gui.MahoujinProjectorScreen;
import stepsword.mahoutsukai.render.gui.PlayerSettingsGUI;
import stepsword.mahoutsukai.render.gui.ReplicaGui;
import stepsword.mahoutsukai.render.gui.WheelGui;
import stepsword.mahoutsukai.render.gui.guide.ContentsPageGui;
import stepsword.mahoutsukai.render.gui.guide.DoubleInfoPageGui;
import stepsword.mahoutsukai.render.gui.guide.InfoPageGui;
import stepsword.mahoutsukai.render.gui.guide.PageGui;
import stepsword.mahoutsukai.render.gui.guide.SpellPageGui;
import stepsword.mahoutsukai.render.particle.FogParticleType;
import stepsword.mahoutsukai.render.particle.LightningParticleType;
import stepsword.mahoutsukai.render.particle.MagicParticleType;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.render.particle.ParticleFog;
import stepsword.mahoutsukai.render.particle.ParticleMagic;
import stepsword.mahoutsukai.render.particle.PetalParticleType;
import stepsword.mahoutsukai.render.shader.ShaderHelper;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class ClientProxy
extends CommonProxy {
    boolean sensechanged = false;
    double oldsense;
    static Field entities;
    static Field particles;

    @Override
    public void openProjectorGUI(World w, BlockPos p) {
        Minecraft.func_71410_x().func_147108_a((Screen)new MahoujinProjectorScreen(w, p));
    }

    @Override
    public void openFogProjectorGUI(World w, BlockPos p) {
        Minecraft.func_71410_x().func_147108_a((Screen)new FogProjectorScreen(w, p));
    }

    @Override
    public void openSettingsGUI(World w, UUID uuid) {
        Minecraft.func_71410_x().func_147108_a((Screen)new PlayerSettingsGUI(w, uuid));
    }

    @Override
    public void openWheelGUI(World w, ItemStack s) {
        Minecraft.func_71410_x().func_147108_a((Screen)new WheelGui(w, s));
    }

    @Override
    public void openReplicaWheelGUI(World w, ItemStack s) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ReplicaGui(w, s));
    }

    @Override
    public void spawnFog(BlockPos blockPos, float particle_fog_size, float r, float g, float b, float a, float particle_fog_thickness, float particle_fog_speed, boolean particle_fog_random_x, boolean particle_fog_random_y, boolean particle_fog_random_z, float particle_fog_direction_x, float particle_fog_direction_y, float particle_fog_direction_z, boolean particle_fog_shaders, int particle_fog_frequency_num) {
        Vector3d direction = new Vector3d((double)particle_fog_direction_x, (double)particle_fog_direction_y, (double)particle_fog_direction_z);
        direction = direction.func_72432_b();
        Random random = Minecraft.func_71410_x().field_71441_e.field_73012_v;
        for (int i = 0; i < particle_fog_frequency_num; ++i) {
            double newX = direction.field_72450_a;
            double newY = direction.field_72448_b;
            double newZ = direction.field_72449_c;
            if (particle_fog_random_x) {
                newX = random.nextDouble() * 2.0 - 1.0;
            }
            if (particle_fog_random_y) {
                newY = random.nextDouble() * 2.0 - 1.0;
            }
            if (particle_fog_random_z) {
                newZ = random.nextDouble() * 2.0 - 1.0;
            }
            direction = new Vector3d(newX, newY, newZ);
            direction = direction.func_72432_b();
            direction = direction.func_186678_a((double)particle_fog_speed);
            ParticleFog p = new ParticleFog(Minecraft.func_71410_x().field_71441_e, new ResourceLocation("mahoutsukai", "textures/particle/fog3.png"), (float)blockPos.func_177958_n() + 0.5f, (float)blockPos.func_177956_o() + 0.5f, (float)blockPos.func_177952_p() + 0.5f, 0.5f, direction.field_72450_a, direction.field_72448_b, direction.field_72449_c, particle_fog_shaders, r, g, b, a, particle_fog_thickness, particle_fog_size);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
        }
    }

    @Override
    public void init() {
        ShaderHelper.initShaders();
        ClientHandler client = new ClientHandler();
        MinecraftForge.EVENT_BUS.register((Object)client);
        ClientHandlerModEventBus clientMod = new ClientHandlerModEventBus();
        MahouTsukaiMod.MOD_EVENT_BUS.register((Object)clientMod);
        super.init();
    }

    @Override
    public boolean handleMaterialAcceleration(Entity entityIn) {
        return false;
    }

    @Override
    public PlayerEntity getPlayerForScry(World world, String viewTarget, CompoundNBT scryNBT, UUID uuid) {
        PlayerEntity playertarget = ScryingMahoujinTileEntity.getPlayerByName(viewTarget, world);
        if (playertarget == null && uuid != null) {
            RemoteClientPlayerEntity player = new RemoteClientPlayerEntity((ClientWorld)world, new GameProfile(uuid, viewTarget));
            try {
                player.func_70020_e(scryNBT);
            }
            catch (Exception e) {
                System.err.println("Mahou Tsukai: Could not read player NBT:" + e.toString());
            }
            return player;
        }
        if (playertarget != null && scryNBT != null) {
            RemoteClientPlayerEntity player = new RemoteClientPlayerEntity((ClientWorld)world, playertarget.func_146103_bH());
            try {
                player.func_70020_e(scryNBT);
            }
            catch (Exception e) {
                System.err.println("Mahou Tsukai: Could not read player NBT:" + e.toString());
            }
            return player;
        }
        return null;
    }

    @Override
    public void revertPlayer() {
        super.revertPlayer();
    }

    public static HashSet<Entity> getAllEntities(ClientWorld world) {
        if (world.field_217429_b != null) {
            return new HashSet<Entity>((Collection<Entity>)world.field_217429_b.values());
        }
        return new HashSet<Entity>();
    }

    @Override
    public void openGuideGUI(GuidebookInstance book, PlayerEntity playerIn) {
        IMahou mahou = Utils.getPlayerMahou(playerIn);
        int savedPage = 0;
        if (mahou != null) {
            savedPage = mahou.getGuidePage();
        }
        book.setCurrentPage(savedPage);
        if (book.getPage() instanceof ContentsPage) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ContentsPageGui(book, (ContentsPage)book.getPage()));
        } else if (book.getPage() instanceof InfoPage) {
            Minecraft.func_71410_x().func_147108_a((Screen)new InfoPageGui(book, (InfoPage)book.getPage()));
        } else if (book.getPage() instanceof SpellPage) {
            Minecraft.func_71410_x().func_147108_a((Screen)new SpellPageGui(book, (SpellPage)book.getPage()));
        } else if (book.getPage() instanceof DoubleInfoPage) {
            Minecraft.func_71410_x().func_147108_a((Screen)new DoubleInfoPageGui(book, (DoubleInfoPage)book.getPage()));
        } else if (book.getPage() instanceof Page) {
            Minecraft.func_71410_x().func_147108_a((Screen)new PageGui(book));
        }
    }

    @Override
    public void slowDown() {
        if (!this.sensechanged) {
            this.oldsense = Minecraft.func_71410_x().field_71474_y.field_74341_c;
            Minecraft.func_71410_x().field_71474_y.field_74341_c *= (double)0.34f;
            this.sensechanged = true;
        }
    }

    @Override
    public void speedUp() {
        if (this.sensechanged) {
            Minecraft.func_71410_x().field_71474_y.field_74341_c = this.oldsense;
            this.sensechanged = false;
        }
    }

    @Override
    public boolean isMahouTsukai() {
        IMahou mahou = Utils.getPlayerMahou((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (mahou != null) {
            return mahou.hasMagic();
        }
        return false;
    }

    @Override
    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity(null, (SoundEvent)soundIn, (SoundCategory)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        this.playSound(x, y, z, soundIn, category, volume, pitch, false);
    }

    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        double d0 = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c().func_186679_c(x, y, z);
        SimpleSound simplesound = new SimpleSound(soundIn, category, volume, pitch, (double)((float)x), (double)((float)y), (double)((float)z));
        if (distanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)simplesound, (int)(d1 * 20.0));
        } else {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)simplesound);
        }
    }

    @Override
    public void registerFactories() {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.PETAL, PetalParticleType.PetalFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.RED_LIGHTNING, (IParticleFactory)new LightningParticleType.LightningFactory(new Color(255, 0, 0, 255), new Color(255, 120, 120)));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.YELLOW_LIGHTNING, (IParticleFactory)new LightningParticleType.LightningFactory(new Color(255, 255, 0, 255), new Color(255, 255, 70)));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.FOG1, (IParticleFactory)new FogParticleType.FogFactory(new ResourceLocation("mahoutsukai", "textures/particle/fog3.png")));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.RED_MAGIC, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.2f, 1.0f, 0.0f, 0.0f, 1.0f, true));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.YELLOW_MAGIC, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.6f, 1.0f, 1.0f, 0.2f, 0.9f, false));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.BLACK_MAGIC, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.2f, 0.0f, 0.0f, 0.0f, 1.0f, true));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.RED_MAGIC_BIG, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 1.2f, 1.0f, 0.0f, 0.0f, 0.0f, true));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.BLACK_MAGIC_BIG, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 1.2f, 0.0f, 0.0f, 0.0f, 1.0f, true));
    }

    public static HashSet<Particle> getNoRenderParticles(ParticleManager manager) {
        Queue q = (Queue)manager.field_78876_b.get(IParticleRenderType.field_217606_f);
        if (q != null) {
            return new HashSet<Particle>(q);
        }
        return new HashSet<Particle>();
    }

    @Override
    public void smiteParticles(double x, double y, double z, Random rand, boolean boom) {
        block4: {
            BasicParticleType p = ModParticles.YELLOW_MAGIC;
            double range = 0.0;
            if (Minecraft.func_71410_x().field_71441_e == null) break block4;
            if (!boom) {
                for (int i = 0; i < 6; ++i) {
                    double xoff = (rand.nextDouble() - 0.5) * range;
                    double yoff = (rand.nextDouble() - 0.5) * 1.2;
                    double zoff = (rand.nextDouble() - 0.5) * range;
                    Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)p, x + xoff, y + (double)i * 0.16, z + zoff, 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 30; ++i) {
                    double xoff = 0.0;
                    double yoff = 0.0;
                    double zoff = 0.0;
                    Vector3d vec = new Vector3d(rand.nextDouble() - 0.5, 0.0, rand.nextDouble() - 0.5).func_72432_b();
                    Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)p, x, y, z, vec.field_72450_a, 0.0, vec.field_72449_c);
                }
            }
        }
    }

    @Override
    public void spawnGandrParticle(GandrEntity entity) {
        float[] rgb = entity.getColor();
        ParticleMagic p = new ParticleMagic(Minecraft.func_71410_x().field_71441_e, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.5f, 0.0, 0.0, 0.0, "textures/particle/white_magic_particle", 0.2f, rgb[0], rgb[1], rgb[2], 1.0f, false);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
    }

    @Override
    public void spawnReplicaTeleportParticles(ReplicaTeleportMahoujinEntity entity) {
        float[] rgb = entity.getColor();
        float radius = entity.getCircleSize();
        ParticleStatus particlestatus = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        int particles = 22;
        if (particlestatus == ParticleStatus.DECREASED) {
            particles = 10;
        } else if (particlestatus == ParticleStatus.MINIMAL) {
            particles = 5;
        }
        int i = 0;
        while ((float)i < radius * (float)particles) {
            if (Math.random() < 0.03) {
                double r = (double)radius * Math.sqrt(Math.random());
                double theta = Math.random() * 2.0 * Math.PI;
                double x = entity.func_226277_ct_() + r * Math.cos(theta);
                double z = entity.func_226281_cx_() + r * Math.sin(theta);
                double y = entity.func_226278_cu_() + Math.random() * 0.4;
                ParticleMagic p = new ParticleMagic(Minecraft.func_71410_x().field_71441_e, x, y, z, (float)(Math.random() * 0.4) + 0.2f, 0.0, Math.random() * 0.03 + 0.01, 0.0, "textures/particle/white_magic_particle", (float)Math.random() * 0.6f + 0.1f, rgb[0], rgb[1], rgb[2], 1.0f, false, 0.99);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
            }
            ++i;
        }
    }

    @Override
    public void projectorArmorClick(PlayerEntity player, BlockPos pos) {
        if (player.func_184614_ca().func_77973_b() instanceof ArmorItem) {
            ProjectorRightClickPacket.ARMOR_ACTION action = ProjectorRightClickPacket.ARMOR_ACTION.REPLACE;
            if (Keybinds.changeMysticCode.func_151470_d()) {
                action = ProjectorRightClickPacket.ARMOR_ACTION.ADD;
            } else if (Keybinds.drawMahoujin.func_151470_d()) {
                action = ProjectorRightClickPacket.ARMOR_ACTION.REMOVE;
            }
            ProjectorRightClickPacket packet = new ProjectorRightClickPacket(action, pos);
            PacketHandler.sendToServer(packet);
        }
    }
}

