/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class SelectiveDisplacementPacket {
    int id1 = 0;
    int id2 = 0;

    public SelectiveDisplacementPacket() {
    }

    public SelectiveDisplacementPacket(int i, int i2) {
        this.id1 = i;
        this.id2 = i2;
    }

    public void fromBytes(ByteBuf buf) {
        this.id1 = buf.readInt();
        this.id2 = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id1);
        buf.writeInt(this.id2);
    }

    public static void encode(SelectiveDisplacementPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static SelectiveDisplacementPacket decode(PacketBuffer buf) {
        SelectiveDisplacementPacket msg = new SelectiveDisplacementPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final SelectiveDisplacementPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                if (((NetworkEvent.Context)context.get()).getSender() instanceof ServerPlayerEntity) {
                    SelectiveDisplacementPacket.handleAbilitySelectiveDisplacement(((NetworkEvent.Context)context.get()).getSender(), message.id1, message.id2);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleAbilitySelectiveDisplacement(ServerPlayerEntity player, int id, int id2) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT) && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT_COOLDOWN) && id != 0) {
            Entity e = player.field_70170_p.func_73045_a(id);
            Object e2 = player;
            e2 = id2 != 0 && id2 != id ? player.field_70170_p.func_73045_a(id2) : player;
            if (e != null && e2 != null && e != e2 && EffectUtil.getDimension(e.field_70170_p) == EffectUtil.getDimension(e2.field_70170_p)) {
                double x = e.func_226277_ct_();
                double y = e.func_226278_cu_();
                double z = e.func_226281_cx_();
                double x2 = e2.func_226277_ct_();
                double y2 = e2.func_226278_cu_();
                double z2 = e2.func_226281_cx_();
                if (e2.func_184188_bt().size() > 0) {
                    e2.func_184226_ay();
                }
                if (e.func_184188_bt().size() > 0) {
                    e.func_184226_ay();
                }
                MahouTsukaiTeleporter.teleport(e, e2.func_226277_ct_(), e2.func_226278_cu_(), e2.func_226281_cx_(), EffectUtil.getDimension(e.field_70170_p));
                Vector3d facing = new Vector3d(x2, y2, z2).func_178788_d(new Vector3d(x, y, z));
                facing = facing.func_72432_b();
                float pitch = (float)Math.asin(-facing.field_72448_b);
                float yaw = (float)Math.atan2(facing.field_72450_a, facing.field_72449_c);
                if (e2 instanceof LivingEntity) {
                    e2.field_70177_z = EffectUtil.toDegrees(-yaw);
                    e2.field_70125_A = EffectUtil.toDegrees(pitch);
                }
                facing = facing.func_216372_d(-1.0, -1.0, -1.0);
                float pitch2 = (float)Math.asin(-facing.field_72448_b);
                float yaw2 = (float)Math.atan2(facing.field_72450_a, facing.field_72449_c);
                if (e instanceof LivingEntity) {
                    e.field_70177_z = EffectUtil.toDegrees(-yaw2);
                    e.field_70125_A = EffectUtil.toDegrees(pitch2);
                }
                MahouTsukaiTeleporter.teleport((Entity)e2, x, y, z, EffectUtil.getDimension(e2.field_70170_p));
                e2.field_70133_I = true;
                e.field_70133_I = true;
                e2.func_230245_c_(false);
                e.func_230245_c_(false);
                ServerPlayerEntity target = null;
                if (e == player) {
                    target = e2;
                }
                if (e2 == player) {
                    target = e;
                }
                if (target != null && ContractMahoujinTileEntity.isImmuneToSpell(player.field_70170_p, player.func_110124_au(), (Entity)target)) {
                    ModTriggers.BOOGIE_WOOGIE.trigger(player);
                }
                EffectUtil.buff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT_COOLDOWN, false, MTConfig.SELECTIVE_DISPLACEMENT_COOLDOWN);
            }
        }
    }
}

