/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class ChunkMahouRequestPacket {
    int x;
    int z;

    public ChunkMahouRequestPacket() {
    }

    public ChunkMahouRequestPacket(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
    }

    public static void encode(ChunkMahouRequestPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ChunkMahouRequestPacket decode(PacketBuffer buf) {
        ChunkMahouRequestPacket msg = new ChunkMahouRequestPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(ChunkMahouRequestPacket message, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity sender = context.get().getSender();
        context.get().enqueueWork(() -> {
            Chunk c;
            IChunkMahou chunkMahou;
            if (sender != null && (chunkMahou = Utils.getChunkMahou(c = sender.field_70170_p.func_212866_a_(message.x, message.z))) != null) {
                if (chunkMahou.getLakeBlocks() != null && chunkMahou.getLakeBlocks().size() > 0) {
                    PacketHandler.sendTo(((NetworkEvent.Context)context.get()).getSender(), new ChunkMahouPacket(chunkMahou.getLakeBlocks(), message.x, message.z));
                }
                if (chunkMahou.getFogProjectors() != null && chunkMahou.getFogProjectors().size() > 0) {
                    PacketHandler.sendTo(((NetworkEvent.Context)context.get()).getSender(), new ChunkMahouPacket(chunkMahou.getFogProjectors(), message.x, message.z, 1));
                }
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }
}

