/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.ConcurrentSet;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class ChunkMahouPacket {
    int mode;
    ConcurrentSet<BlockPos> set;
    int x;
    int z;

    public ChunkMahouPacket() {
    }

    public ChunkMahouPacket(ConcurrentSet<BlockPos> set, int x, int z) {
        this.x = x;
        this.z = z;
        this.set = set;
        this.mode = 0;
    }

    public ChunkMahouPacket(ConcurrentSet<BlockPos> set, int x, int z, int mode) {
        this.x = x;
        this.z = z;
        this.set = set;
        this.mode = mode;
    }

    public void fromBytes(ByteBuf buf) {
        this.mode = buf.readInt();
        this.x = buf.readInt();
        this.z = buf.readInt();
        this.set = new ConcurrentSet();
        int sz = buf.readInt();
        for (int i = 0; i < sz; ++i) {
            this.set.add((Object)new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.mode);
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        if (this.set != null && this.set.size() > 0) {
            buf.writeInt(this.set.size());
            for (BlockPos p : this.set) {
                if (p == null) continue;
                buf.writeInt(p.func_177958_n());
                buf.writeInt(p.func_177956_o());
                buf.writeInt(p.func_177952_p());
            }
        } else {
            buf.writeInt(0);
        }
    }

    public static void encode(ChunkMahouPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ChunkMahouPacket decode(PacketBuffer buf) {
        ChunkMahouPacket msg = new ChunkMahouPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(ChunkMahouPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.chunkMahouPacketHandler(message);
        context.get().setPacketHandled(true);
    }
}

