/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.PowerConsolidation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahou;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouProvider;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.render.item.CaliburnRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.FakeSkeleton;
import stepsword.mahoutsukai.util.Utils;

public class Caliburn
extends SwordItem {
    protected String name = "caliburn";
    public static String MT_ATTACK_DAMAGE = "mahoutsukai_caliburn_attack";
    public static String MT_ATTACK_CAP = "mahoutsukai_caliburn_innate_cap";

    public Caliburn() {
        super((IItemTier)ItemTier.IRON, 3, -2.4f, new Item.Properties().func_200916_a(ModItems.MAHOUTSUKAI_CREATIVE_TAB).func_200918_c(MTConfig.POWER_CONSOLIDATION_DURABILITY).setISTER(() -> CaliburnRenderer::new));
        this.setRegistryName(this.name);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Caliburn.setattacktonbt(stack, worldIn);
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CaliburnMahouProvider();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EffectUtil.inEnchantBlacklist(enchantment, MTConfig.POWER_CONSOLIDATION_ENCHANT_BLACKLIST)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        if (ret == null) {
            ICaliburnMahou mahou = Utils.getCaliburnMahou(stack);
            return (CompoundNBT)CaliburnMahouProvider.MAHOU.getStorage().writeNBT(CaliburnMahouProvider.MAHOU, (Object)mahou, null);
        }
        return ret;
    }

    public static void setattacktonbt(ItemStack stack, World world) {
        if (stack != null && !world.field_72995_K) {
            ICaliburnMahou mahou;
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            if ((mahou = Utils.getCaliburnMahou(stack)) != null) {
                nbt.func_74776_a(MT_ATTACK_DAMAGE, mahou.getAttackDamage());
                nbt.func_74780_a(MT_ATTACK_CAP, mahou.getInnateCap());
            }
            stack.func_77982_d(nbt);
        }
    }

    public static void getattackfromnbt(ItemStack stack) {
        ICaliburnMahou mahou;
        CompoundNBT nbt;
        if (stack != null && stack.func_77942_o() && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b(MT_ATTACK_DAMAGE) && (mahou = Utils.getCaliburnMahou(stack)) != null) {
            if (MTConfig.POWER_CONSOLIDATION_TIERS.size() <= 0) {
                mahou.setAttackDamage(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, Math.max(nbt.func_74760_g(MT_ATTACK_DAMAGE), mahou.getAttackDamage())));
            } else {
                if (nbt.func_74764_b(MT_ATTACK_CAP)) {
                    mahou.setInnateCap(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, nbt.func_74760_g(MT_ATTACK_CAP)));
                } else {
                    mahou.setInnateCap(MTConfig.POWER_CONSOLIDATION_ATTACK_CAP);
                }
                mahou.setAttackDamage((float)Math.min(mahou.getInnateCap(), (double)Math.max(nbt.func_74760_g(MT_ATTACK_DAMAGE), mahou.getAttackDamage())));
            }
        }
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbtt) {
        if (nbtt != null) {
            ICaliburnMahou caliburnMahou = Utils.getCaliburnMahou(stack);
            CaliburnMahou serverCaliburnMahou = new CaliburnMahou();
            CaliburnMahouProvider.MAHOU.getStorage().readNBT(CaliburnMahouProvider.MAHOU, (Object)serverCaliburnMahou, null, (INBT)nbtt);
            if (caliburnMahou != null) {
                if (MTConfig.POWER_CONSOLIDATION_TIERS.size() <= 0) {
                    caliburnMahou.setAttackDamage(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, serverCaliburnMahou.getAttackDamage()));
                } else {
                    caliburnMahou.setInnateCap(Math.min((double)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, serverCaliburnMahou.getInnateCap()));
                    caliburnMahou.setAttackDamage((float)Math.min(serverCaliburnMahou.getInnateCap(), (double)serverCaliburnMahou.getAttackDamage()));
                }
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public static float simulateHit(ItemStack s, World world) {
        float ret = 3.0f;
        int health = 5000000;
        if (s != null) {
            ItemStack s1 = s.func_77946_l();
            FakeSkeleton fake_target = new FakeSkeleton(world);
            fake_target.h = 5000000.0f;
            if (Attributes.field_233823_f_ instanceof RangedAttribute) {
                ((RangedAttribute)Attributes.field_233823_f_).field_111118_b = Math.max(((RangedAttribute)Attributes.field_233823_f_).field_111118_b, (double)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP);
            }
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerWorld)world, "faker");
            fake_player.func_184611_a(Hand.MAIN_HAND, s1);
            fake_player.func_233645_dx_().func_233793_b_(s1.func_111283_C(EquipmentSlotType.MAINHAND));
            ((PlayerEntity)fake_player).field_184617_aD = 1000;
            fake_player.func_71059_n((Entity)fake_target);
            ret = (float)health - fake_target.h;
        }
        return ret;
    }

    public static boolean specialTarget(LivingEntity entity) {
        boolean blacklisted = false;
        for (String string : MTConfig.POWER_CONSOLIDATION_FEAR_BLACKLIST) {
            if (string == null || entity.func_200600_R().getRegistryName() == null || !string.equals(entity.func_200600_R().getRegistryName().toString())) continue;
            blacklisted = true;
        }
        if (blacklisted) {
            return false;
        }
        return entity.func_70662_br() || entity.func_184614_ca().func_77973_b() instanceof Morgan || entity.func_184592_cb().func_77973_b() instanceof Morgan || Caliburn.containsKeyword(entity.func_200200_C_().getString().toLowerCase()) || Caliburn.containsKeyword(entity.func_145748_c_().toString().toLowerCase());
    }

    public static boolean containsKeyword(String name) {
        List<? extends String> arr = MTConfig.UNHOLY_WORDS;
        for (int i = 0; i < arr.size(); ++i) {
            if (!name.contains(arr.get(i))) continue;
            return true;
        }
        int numKeys = arr.size();
        for (int i = 1; i < numKeys + 1; ++i) {
            if (!name.contains(new TranslationTextComponent("mahoutsukai.caliburnkeyword" + i).getString())) continue;
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        player.func_184598_c(handIn);
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(handIn));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity player, int timeLeft) {
        if (player != null && !worldIn.field_72995_K) {
            int radius = MTConfig.POWER_CONSOLIDATION_PULL_RADIUS;
            AxisAlignedBB aabb = new AxisAlignedBB(player.func_233580_cy_().func_177982_a(-radius, -4, -radius), player.func_233580_cy_().func_177982_a(radius, 4, radius));
            List lst = worldIn.func_217357_a(LivingEntity.class, aabb);
            double score = -1.0;
            double chosendist = 0.0;
            LivingEntity chosen = null;
            for (LivingEntity target : lst) {
                if (target.func_110124_au().equals(player.func_110124_au()) || !EffectUtil.isLookingAtMe((Entity)target, player, 45) || !Caliburn.specialTarget(target)) continue;
                double d = Math.abs(EffectUtil.pointToLineDistance(target.func_213303_ch(), player.func_174824_e(1.0f), player.func_70040_Z().func_178787_e(player.func_174824_e(1.0f))));
                double e = target.func_213303_ch().func_72438_d(player.func_213303_ch());
                if (score != -1.0 && !(score > d * d + e)) continue;
                score = d * d + e;
                chosen = target;
                chosendist = e;
            }
            if (chosen != null) {
                Vector3d chosenDirection = chosen.func_213303_ch().func_178788_d(player.func_213303_ch());
                Caliburn.boop((Entity)player, (float)(chosendist / 8.0), -chosenDirection.field_72450_a, -chosenDirection.field_72448_b, -chosenDirection.field_72449_c);
                Caliburn.boop(chosen, (float)(chosendist / 8.0), chosenDirection.field_72450_a, chosenDirection.field_72448_b, chosenDirection.field_72449_c);
            }
        }
        super.func_77615_a(stack, worldIn, player, timeLeft);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        HashMultimap multimapret = HashMultimap.create();
        float damage = 3.0f;
        Caliburn.getattackfromnbt(stack);
        if (slot == EquipmentSlotType.MAINHAND && multimap != null) {
            ICaliburnMahou mahou;
            if (stack != null && (mahou = Utils.getCaliburnMahou(stack)) != null) {
                damage = mahou.getAttackDamage();
            }
            if (Attributes.field_233823_f_ != null && Attributes.field_233825_h_ != null) {
                for (Attribute k : multimap.keySet()) {
                    if (k.equals(Attributes.field_233823_f_) || k.equals(Attributes.field_233825_h_)) continue;
                    multimapret.putAll((Object)k, (Iterable)multimap.get((Object)k));
                }
                multimapret.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
                multimapret.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.600000095367432, AttributeModifier.Operation.ADDITION));
            }
        }
        return multimapret;
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(x * x + z * z + y * y));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.field_70133_I = true;
        if (entity.func_233570_aj_()) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.6) {
                motionY = 0.6;
            }
        }
        entity.func_213317_d(new Vector3d(motionX, motionY, motionZ));
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }
}

