/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic.MysticStaff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class Bakuretsu {
    private int radius;
    private float posX;
    private float posY;
    private float posZ;
    public HashMap<PlayerEntity, Vector3d> knockback = new HashMap();
    private float damage;

    public Bakuretsu() {
    }

    public Bakuretsu(int r, float x, float y, float z, float damage) {
        this();
        this.radius = r;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.damage = damage;
    }

    public Bakuretsu(int r, BlockPos pos) {
        this();
        this.radius = r;
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
    }

    public void explosionA(World world, PlayerEntity entity) {
        ArrayList<BlockPos> affected = new ArrayList<BlockPos>();
        List<Entity> lst = this.playerKnockback(world, entity);
        if (MTConfig.MYSTIC_STAFF_WORLD_DAMAGE) {
            for (float x = this.posX - (float)this.radius; x < this.posX + (float)this.radius + 1.0f; x += 1.0f) {
                for (float y = this.posY - (float)this.radius; y < this.posY + (float)this.radius + 1.0f; y += 1.0f) {
                    for (float z = this.posZ - (float)this.radius; z < this.posZ + (float)this.radius + 1.0f; z += 1.0f) {
                        BlockPos tmp;
                        Block b;
                        float cmp = (float)(this.radius * this.radius) - (this.posX - x) * (this.posX - x) - (this.posY - y) * (this.posY - y) - (this.posZ - z) * (this.posZ - z);
                        if (!(cmp > 0.0f) || (b = world.func_180495_p(tmp = new BlockPos((double)x, (double)y, (double)z)).func_177230_c()) == Blocks.field_150350_a || b == Blocks.field_201941_jj || b == Blocks.field_201940_ji || b == Blocks.field_150343_Z || b == Blocks.field_150357_h || !(b.getExplosionResistance(world.func_180495_p(tmp), (IBlockReader)world, tmp, null) < 4000.0f)) continue;
                        affected.add(tmp);
                    }
                }
            }
            EffectUtil.tryFakeExplosion(affected, (Entity)entity, entity, "bakuretsu", false, lst);
        }
        Vector3d boom = new Vector3d((double)this.posX, (double)this.posY, (double)this.posZ);
        for (Entity e : lst) {
            this.hurt(e, boom, entity);
        }
    }

    public List<Entity> playerKnockback(World world, PlayerEntity player) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(this.posX - (float)this.radius), (double)(this.posY - (float)this.radius), (double)(this.posZ - (float)this.radius), (double)(this.posX + (float)this.radius), (double)(this.posY + (float)this.radius), (double)(this.posZ + (float)this.radius));
        List entities = world.func_175674_a((Entity)null, aabb, null);
        ArrayList<Entity> ret = new ArrayList<Entity>();
        Vector3d boom = new Vector3d((double)this.posX, (double)this.posY, (double)this.posZ);
        for (Entity entity : entities) {
            double z;
            double y;
            double x;
            double cmp;
            if (entity.func_180427_aV() || entity instanceof MysticStaffMahoujinEntity || !((cmp = (double)(this.radius * this.radius) - ((double)this.posX - (x = entity.func_226277_ct_())) * ((double)this.posX - x) - ((double)this.posY - (y = entity.func_226278_cu_())) * ((double)this.posY - y) - ((double)this.posZ - (z = entity.func_226281_cx_())) * ((double)this.posZ - z)) > 0.0)) continue;
            ret.add(entity);
        }
        return ret;
    }

    public void hurt(Entity entity, Vector3d boom, PlayerEntity player) {
        double x = entity.func_226277_ct_();
        double y = entity.func_226278_cu_();
        double z = entity.func_226281_cx_();
        double cmp = (double)(this.radius * this.radius) - ((double)this.posX - x) * ((double)this.posX - x) - ((double)this.posY - y) * ((double)this.posY - y) - ((double)this.posZ - z) * ((double)this.posZ - z);
        float density = Bakuretsu.getBlockDensity(boom, entity);
        entity.func_70097_a(DamageSource.func_188405_b((LivingEntity)player), this.damage * density);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).field_70718_bc = 100;
        }
        Vector3d kb = new Vector3d(x, y, z).func_178787_e(new Vector3d((double)(-this.posX), (double)(-this.posY), (double)(-this.posZ))).func_72432_b().func_186678_a(Math.sqrt(cmp) / 4.0);
        double motionX = entity.func_213322_ci().field_72450_a;
        double motionY = entity.func_213322_ci().field_72448_b;
        double motionZ = entity.func_213322_ci().field_72449_c;
        entity.func_213293_j(motionX += kb.field_72450_a, motionY += kb.field_72448_b, motionZ += kb.field_72449_c);
        if (entity instanceof PlayerEntity) {
            this.knockback.put((PlayerEntity)entity, kb);
        }
    }

    public void explosionB(World world, PlayerEntity player) {
        world.func_184148_a((PlayerEntity)null, (double)this.posX, (double)this.posY, (double)this.posZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        for (float x = this.posX - (float)this.radius; x < this.posX + (float)this.radius + 1.0f; x += 1.0f) {
            for (float y = this.posY - (float)this.radius; y < this.posY + (float)this.radius + 1.0f; y += 1.0f) {
                for (float z = this.posZ - (float)this.radius; z < this.posZ + (float)this.radius + 1.0f; z += 1.0f) {
                    float cmp = (float)(this.radius * this.radius) - (this.posX - x) * (this.posX - x) - (this.posY - y) * (this.posY - y) - (this.posZ - z) * (this.posZ - z);
                    if (!(cmp > 0.0f) || !(cmp < 7.1f)) continue;
                    world.func_195590_a((IParticleData)ParticleTypes.field_197626_s, true, (double)x, (double)y, (double)z, 1.0, 0.0, 0.0);
                }
            }
        }
    }

    public static float getBlockDensity(Vector3d explosionVector, Entity entity) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        double d0 = 1.0 / ((axisalignedbb.field_72336_d - axisalignedbb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.field_72337_e - axisalignedbb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.field_72334_f - axisalignedbb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = MathHelper.func_219803_d((double)f, (double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72336_d);
                        Vector3d Vector3d2 = new Vector3d(d5 + d3, d6 = MathHelper.func_219803_d((double)f1, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72337_e), (d7 = MathHelper.func_219803_d((double)f2, (double)axisalignedbb.field_72339_c, (double)axisalignedbb.field_72334_f)) + d4);
                        if (entity.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, explosionVector, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, entity)).func_216346_c() == RayTraceResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }
}

