/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.butterfly;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.FakePlayNetHandler;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.entity.butterfly.SerializableBlockBreak;
import stepsword.mahoutsukai.entity.butterfly.SerializableBlockPlace;
import stepsword.mahoutsukai.entity.butterfly.SerializableHit;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ButterflyEntity
extends Entity {
    public static final String entityName = "butterfly_entity";
    private static final String TAG_SIZE = "MAHOUTSUKAI_SIZE";
    private static final String TAG_RANDOM_SEED = "MAHOUTSUKAI_RANDOM_SEED";
    private static final String TAG_PLACE_BLOCK = "MAHOUTSUKAI_PLACE_BLOCK";
    private static final String TAG_BREAK_BLOCK = "MAHOUTSUKAI_BREAK_BLOCK";
    private static final String TAG_HIT = "MAHOUTSUKAI_HIT";
    private static final String TAG_DYING = "MAHOUTSUKAI_DYING";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_EFFECT = "MAHOUTSUKAI_EFFECT";
    public EFFECT effect = EFFECT.NONE;
    boolean colorstarted = false;
    int dying = 0;
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(ButterflyEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> RANDOM_SEED = EntityDataManager.func_187226_a(ButterflyEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DYING = EntityDataManager.func_187226_a(ButterflyEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> CASTER = EntityDataManager.func_187226_a(ButterflyEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private AxisAlignedBB zero = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public AxisAlignedBB aabb;
    public BlockPos origPos;
    public BlockPos origPos1;
    public float angle = 0.0f;
    public float prevangle = 0.0f;
    public float wingspeed = 0.0f;
    public float topstop = 89.0f;
    public float bottomstop = -29.0f;
    public float defaultSize = 0.3f;
    public Random rng;
    public float[][] colors = new float[6][4];
    public float[][] targets = new float[6][4];
    SerializableBlockPlace placeBlock;
    SerializableBlockBreak breakBlock;
    SerializableHit hit;

    public ButterflyEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public ButterflyEntity(World world) {
        super(ModEntities.BUTTERFLY, world);
        this.field_70158_ak = true;
    }

    public ButterflyEntity(World world, PlayerEntity caster, int seed, float size) {
        this(world);
        this.setCasterUUID(caster.func_110124_au());
        this.setSize(size);
        this.setSeed(seed);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(this.defaultSize));
        this.field_70180_af.func_187214_a(RANDOM_SEED, (Object)812389532);
        this.field_70180_af.func_187214_a(DYING, (Object)false);
        this.field_70180_af.func_187214_a(CASTER, Optional.empty());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.field_70126_B = this.field_70177_z;
            if (this.rng == null) {
                this.rng = new Random(this.getSeed());
            }
            if (this.getSize() == 0.0f) {
                this.setSize(this.defaultSize);
            }
            if (!this.getDying()) {
                this.initColor();
                this.flap();
                this.colorUpdate(1.0f, true);
            } else {
                if (this.dying == 0) {
                    for (int i = 0; i < this.targets.length; ++i) {
                        this.targets[i][0] = 255.0f;
                        this.targets[i][1] = 255.0f;
                        this.targets[i][2] = 255.0f;
                    }
                }
                this.prevangle = this.angle;
                ++this.dying;
                this.colorUpdate(10.0f, false);
            }
        } else {
            if (this.getDying()) {
                ++this.dying;
                if (this.dying > 25) {
                    this.func_70106_y();
                }
            }
            if (this.origPos == null) {
                this.origPos = this.func_233580_cy_();
                this.origPos1 = this.origPos.func_177982_a(1, 1, 1);
            }
            this.move();
        }
    }

    public void move() {
        this.field_70125_A = -30.0f;
        this.field_70177_z %= 360.0f;
        Vector3d motion = this.func_213322_ci();
        double motionX = motion.field_72450_a;
        double motionY = motion.field_72448_b;
        double motionZ = motion.field_72449_c;
        Vector3d pos = this.func_213303_ch();
        motionX = -0.01 * this.func_70040_Z().field_72450_a;
        motionZ = 0.01 * this.func_70040_Z().field_72449_c;
        if (pos.func_82615_a() - (double)this.origPos.func_177958_n() < 0.1 || pos.func_82616_c() - (double)this.origPos.func_177952_p() < 0.1 || (double)this.origPos1.func_177958_n() - pos.func_82615_a() < 0.1 || (double)this.origPos1.func_177952_p() - pos.func_82616_c() < 0.1) {
            Vector3d v = EffectUtil.fromBlockPos(this.origPos).func_72441_c(0.5, 0.5, 0.5);
            Vector3d moveTo = v.func_178788_d(this.func_213303_ch());
            float yawto = EffectUtil.toDegrees((float)Math.atan2(moveTo.field_72450_a, moveTo.field_72449_c));
            float diff = this.rotateTowards(yawto);
            this.field_70177_z += diff;
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
        }
        if (pos.func_82617_b() - (double)this.origPos.func_177956_o() < 0.1) {
            motionY = 0.02;
        } else {
            if ((double)this.origPos1.func_177956_o() - pos.func_82617_b() < 0.1) {
                motionY = -0.02;
            } else if (ServerHandler.tickCounter % 30L == 0L) {
                motionY = (double)this.field_70146_Z.nextFloat() * 0.04 - 0.02;
            }
            if (!this.getDying()) {
                List lst;
                if (this.aabb == null && this.origPos != null && this.origPos1 != null) {
                    double n = 0.25;
                    this.aabb = new AxisAlignedBB((double)this.origPos.func_177958_n() + n, (double)this.origPos.func_177956_o() + n, (double)this.origPos.func_177952_p() + n, (double)this.origPos1.func_177958_n() - n, (double)this.origPos1.func_177956_o() - n, (double)this.origPos1.func_177952_p() - n);
                }
                if ((lst = this.field_70170_p.func_217357_a(Entity.class, this.aabb)).size() > 0) {
                    Entity e;
                    Iterator iterator = lst.iterator();
                    while (iterator.hasNext() && ((e = (Entity)iterator.next()) == this || !this.collide(e))) {
                    }
                }
            }
        }
        this.func_213293_j(motionX, motionY, motionZ);
        Vector3d newpos = this.func_213303_ch().func_178787_e(this.func_213322_ci());
        this.func_70107_b(newpos.field_72450_a, newpos.field_72448_b, newpos.field_72449_c);
    }

    public float rotateTowards(float yaw) {
        return Math.abs((yaw - this.field_70177_z) % 360.0f) < 10.0f ? this.field_70146_Z.nextFloat() * 2.0f - 1.0f : 5.0f;
    }

    public void startDying() {
        this.setDying(true);
    }

    public void initColor() {
        if (!this.colorstarted) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.colors[i][j] = this.rng.nextInt(255);
                    this.targets[i][j] = this.colors[i][j];
                }
            }
            this.colorstarted = true;
        }
    }

    public void colorUpdate(float step, boolean reroll) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                float f = this.colors[i][j];
                float f1 = this.targets[i][j];
                if (f == f1) {
                    if (!reroll) continue;
                    this.targets[i][j] = this.rng.nextInt(255);
                    continue;
                }
                if (f > f1) {
                    float[] fArray = this.colors[i];
                    int n = j;
                    fArray[n] = fArray[n] - Math.min(step, f - f1);
                    continue;
                }
                if (!(f < f1)) continue;
                float[] fArray = this.colors[i];
                int n = j;
                fArray[n] = fArray[n] + Math.min(step, f1 - f);
            }
        }
    }

    public void flap() {
        this.prevangle = this.angle;
        float wingrange = 120.0f;
        float fastestFlap = 5.0f;
        float slowestFlap = 15.0f;
        float slowestSpeed = wingrange / slowestFlap;
        float fastestSpeed = wingrange / fastestFlap;
        this.angle += this.wingspeed;
        if (this.angle <= this.bottomstop || this.wingspeed == 0.0f) {
            this.wingspeed = this.rng.nextFloat() * (fastestSpeed - slowestSpeed) + slowestSpeed;
            this.topstop = 90.0f - this.rng.nextFloat() * 12.0f;
        }
        if (this.angle >= this.topstop) {
            this.wingspeed = -(this.rng.nextFloat() * (fastestSpeed - slowestSpeed) + slowestSpeed);
            this.bottomstop = -30.0f + this.rng.nextFloat() * 6.0f;
        }
        this.angle = this.correctAngle(this.angle, -30.0f, 90.0f);
    }

    public float correctAngle(float f, float bottom, float top) {
        float ret = f % (top - bottom);
        if (ret > top) {
            ret = top;
        }
        if (ret < bottom) {
            ret = bottom;
        }
        return ret;
    }

    public void setPlaceEffect(BlockPos pos, Direction direction, BlockState state, ItemStack stack) {
        this.effect = EFFECT.PLACE;
        this.placeBlock = new SerializableBlockPlace();
        this.placeBlock.loc = pos;
        this.placeBlock.state = state;
        this.placeBlock.stack = stack;
        this.origPos = pos.func_177972_a(direction);
        this.origPos1 = this.origPos.func_177982_a(1, 1, 1);
        this.func_70107_b((double)this.origPos.func_177958_n() + 0.5, (double)this.origPos.func_177956_o() + 0.5, (double)this.origPos.func_177952_p() + 0.5);
    }

    public void setBreakEffect(BlockPos pos, Direction direction, BlockState state) {
        this.effect = EFFECT.BREAK;
        this.breakBlock = new SerializableBlockBreak();
        this.breakBlock.loc = pos;
        this.breakBlock.state = state;
        this.origPos = pos.func_177972_a(direction);
        this.origPos1 = this.origPos.func_177982_a(1, 1, 1);
        this.func_70107_b((double)this.origPos.func_177958_n() + 0.5, (double)this.origPos.func_177956_o() + 0.5, (double)this.origPos.func_177952_p() + 0.5);
    }

    public void setHitEffect(PlayerEntity player, ItemStack stack, ItemStack offstack) {
        this.effect = EFFECT.HIT;
        this.hit = new SerializableHit();
        this.hit.stack = stack;
        this.hit.offstack = offstack;
        this.hit.initialPosition = player.func_213303_ch();
        this.hit.effects = new ArrayList<EffectInstance>(player.func_70651_bq());
        this.hit.knockback = new Vector3d((double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), 0.0, (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
        this.hit.knockbackStrength = this.getKnockBackStrength(player);
        this.hit.cooled = this.getCooledAttackStrength(player);
        this.hit.fire = this.getFireModifier(player);
        this.hit.rotyaw = player.field_70177_z;
        this.hit.rotpit = player.field_70125_A;
        this.origPos = new BlockPos(player.func_174824_e(1.0f).func_178787_e(player.func_70040_Z().func_178786_a(0.0, player.func_70040_Z().field_72448_b, 0.0)));
        this.origPos1 = this.origPos.func_177982_a(1, 1, 1);
        this.func_70107_b((double)this.origPos.func_177958_n() + 0.5, (double)this.origPos.func_177956_o() + 0.5, (double)this.origPos.func_177952_p() + 0.5);
    }

    public float getKnockBackStrength(PlayerEntity player) {
        boolean flag;
        int i = EnchantmentHelper.func_77501_a((LivingEntity)player);
        float f2 = player.func_184825_o(0.5f);
        boolean bl = flag = f2 > 0.9f;
        if (player.func_70051_ag() && flag) {
            ++i;
        }
        return (float)i * 0.5f;
    }

    public int getFireModifier(PlayerEntity player) {
        return EnchantmentHelper.func_90036_a((LivingEntity)player);
    }

    public float getCooledAttackStrength(PlayerEntity player) {
        return player.func_184825_o(0.5f);
    }

    public void attackTargetEntityWithCurrentItem(FakePlayer player, Entity targetEntity) {
        player.func_184611_a(Hand.MAIN_HAND, this.hit.stack);
        player.func_184611_a(Hand.OFF_HAND, this.hit.offstack);
        player.func_233645_dx_().func_233793_b_(this.hit.stack.func_111283_C(EquipmentSlotType.MAINHAND));
        player.field_184617_aD = 1000;
        if (!ForgeHooks.onPlayerAttackTarget((PlayerEntity)player, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)player)) {
            float f = (float)player.func_233637_b_(Attributes.field_233823_f_);
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)this.hit.stack, (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)this.hit.stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
            float f2 = this.hit.cooled;
            f1 *= f2;
            player.func_184821_cY();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                f += f1;
                int j = this.hit.fire;
                if (targetEntity instanceof LivingEntity && j > 0 && !targetEntity.func_70027_ad()) {
                    targetEntity.func_70015_d(1);
                }
                Vector3d Vector3d2 = targetEntity.func_213322_ci();
                boolean flag5 = targetEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), f);
                targetEntity.field_70172_ad = 0;
                if (this.hit.knockbackStrength > 0.0f && targetEntity instanceof LivingEntity) {
                    ((LivingEntity)targetEntity).func_233627_a_(this.hit.knockbackStrength, this.hit.knockback.field_72450_a, this.hit.knockback.field_72449_c);
                }
                if (targetEntity instanceof ServerPlayerEntity && targetEntity.field_70133_I) {
                    ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
                    targetEntity.field_70133_I = false;
                    targetEntity.func_213317_d(Vector3d2);
                }
                player.func_130011_c(targetEntity);
                EnchantmentHelper.func_151385_b((LivingEntity)player, (Entity)targetEntity);
                if (targetEntity instanceof LivingEntity && j > 0) {
                    targetEntity.func_70015_d(j * 4);
                }
            }
        }
    }

    public boolean triggerEffect(Entity e) {
        if (this.effect == EFFECT.PLACE) {
            if (this.placeBlock != null && this.placeBlock.loc != null && this.field_70170_p != null && this.getCasterUUID() != null) {
                if (!Utils.isBlockAir(this.field_70170_p, this.placeBlock.loc) || !EffectUtil.tryChangeBlockState(false, this.placeBlock.loc, this.placeBlock.state, this.field_70170_p, this.field_70170_p.func_217371_b(this.getCasterUUID()), this.getCasterUUID())) {
                    this.func_199701_a_(this.placeBlock.stack);
                }
                this.startDying();
                return true;
            }
        } else if (this.effect == EFFECT.BREAK) {
            if (this.breakBlock != null && this.breakBlock.loc != null && this.field_70170_p != null && this.getCasterUUID() != null) {
                boolean z;
                if (this.field_70170_p.func_180495_p(this.breakBlock.loc).equals(this.breakBlock.state) && (z = EffectUtil.tryChangeBlockState(false, this.breakBlock.loc, Blocks.field_150350_a.func_176223_P(), this.field_70170_p, this.field_70170_p.func_217371_b(this.getCasterUUID()), this.getCasterUUID()))) {
                    Block.func_220075_c((BlockState)this.breakBlock.state, (World)this.field_70170_p, (BlockPos)this.breakBlock.loc);
                }
                this.startDying();
                return true;
            }
        } else if (this.effect == EFFECT.HIT && e instanceof LivingEntity && this.hit.stack != null) {
            SafeFakePlayer fake = new SafeFakePlayer((ServerWorld)this.field_70170_p, "butterfly");
            fake.func_70107_b(this.hit.initialPosition.field_72450_a, this.hit.initialPosition.field_72448_b, this.hit.initialPosition.field_72449_c);
            fake.func_226288_n_(this.hit.initialPosition.field_72450_a, this.hit.initialPosition.field_72448_b, this.hit.initialPosition.field_72449_c);
            fake.field_70177_z = this.hit.rotyaw;
            fake.field_70125_A = this.hit.rotpit;
            try {
                fake.field_71135_a = new FakePlayNetHandler(this.field_70170_p.func_73046_m(), (ServerPlayerEntity)fake);
                if (this.hit.effects != null && this.hit.effects.size() > 0) {
                    for (EffectInstance ei : this.hit.effects) {
                        if (ei.func_188419_a() == ModEffects.FORESIGHT) continue;
                        fake.func_195064_c(ei);
                    }
                }
                this.attackTargetEntityWithCurrentItem(fake, e);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
            this.startDying();
        }
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    protected void func_145775_I() {
    }

    public boolean func_82150_aj() {
        return !Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(this.getCasterUUID());
    }

    public void setCasterUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(CASTER, Optional.of(uuid));
    }

    public UUID getCasterUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(CASTER)).orElse(UUID.randomUUID());
    }

    public boolean collide(Entity e) {
        if (!(this.field_70170_p.field_72995_K || this.getCasterUUID() != null && e.func_110124_au().equals(this.getCasterUUID()) || e instanceof ButterflyEntity || ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, this.getCasterUUID(), e))) {
            return this.triggerEffect(e);
        }
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setSize(compound.func_74760_g(TAG_SIZE));
        this.setSeed(compound.func_74762_e(TAG_RANDOM_SEED));
        this.setDying(compound.func_74767_n(TAG_DYING));
        if (compound.func_186855_b(TAG_CASTER)) {
            this.setCasterUUID(compound.func_186857_a(TAG_CASTER));
        }
        if (this.placeBlock == null) {
            this.placeBlock = new SerializableBlockPlace();
        }
        if (compound.func_74764_b(TAG_PLACE_BLOCK)) {
            this.placeBlock.read(compound.func_74775_l(TAG_PLACE_BLOCK));
        }
        if (this.breakBlock == null) {
            this.breakBlock = new SerializableBlockBreak();
        }
        if (compound.func_74764_b(TAG_BREAK_BLOCK)) {
            this.breakBlock.read(compound.func_74775_l(TAG_BREAK_BLOCK));
        }
        if (this.hit == null) {
            this.hit = new SerializableHit();
        }
        if (compound.func_74764_b(TAG_HIT)) {
            this.hit.read(compound.func_74775_l(TAG_HIT));
        }
        if (compound.func_74764_b(TAG_EFFECT) && compound.func_74762_e(TAG_EFFECT) < EFFECT.values().length) {
            this.effect = EFFECT.values()[compound.func_74762_e(TAG_EFFECT)];
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_SIZE, this.getSize());
        compound.func_74768_a(TAG_RANDOM_SEED, this.getSeed());
        compound.func_74757_a(TAG_DYING, this.getDying());
        if (this.getCasterUUID() != null) {
            compound.func_186854_a(TAG_CASTER, this.getCasterUUID());
        }
        if (this.placeBlock != null) {
            compound.func_218657_a(TAG_PLACE_BLOCK, (INBT)this.placeBlock.write());
        }
        if (this.breakBlock != null) {
            compound.func_218657_a(TAG_BREAK_BLOCK, (INBT)this.breakBlock.write());
        }
        if (this.hit != null) {
            compound.func_218657_a(TAG_HIT, (INBT)this.hit.write());
        }
        compound.func_74768_a(TAG_EFFECT, this.effect.ordinal());
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void setSize(float f) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(f));
    }

    public int getSeed() {
        return (Integer)this.field_70180_af.func_187225_a(RANDOM_SEED);
    }

    public void setSeed(int f) {
        this.field_70180_af.func_187227_b(RANDOM_SEED, (Object)f);
    }

    public boolean getDying() {
        return (Boolean)this.field_70180_af.func_187225_a(DYING);
    }

    public void setDying(boolean f) {
        this.field_70180_af.func_187227_b(DYING, (Object)f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum EFFECT {
        HIT,
        SHOOT,
        PLACE,
        BREAK,
        NONE;

    }
}

