/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.clarent.Clarent;

public class WeaponProjectileEntity
extends ArrowEntity {
    public static final String entityName = "weapon_projectile_entity";
    public static Field a1 = null;
    protected static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    int wpe_life = 0;
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(WeaponProjectileEntity.class, (IDataSerializer)DataSerializers.field_187196_f);

    public WeaponProjectileEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.WEAPON_PROJECTILE, worldIn);
        this.field_70158_ak = true;
    }

    public WeaponProjectileEntity(World worldIn) {
        super(ModEntities.WEAPON_PROJECTILE, worldIn);
        this.field_70158_ak = true;
        this.setStack(new ItemStack((IItemProvider)Items.field_151040_l));
    }

    public WeaponProjectileEntity(World worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.setStack(stack);
        this.field_70158_ak = true;
    }

    public WeaponProjectileEntity(World worldIn, LivingEntity shooter, ItemStack stack) {
        this(worldIn, shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() - (double)0.1f, shooter.func_226281_cx_(), stack);
        this.func_212361_a((Entity)shooter);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
        this.field_70158_ak = true;
        this.wpe_life = 0;
    }

    public WeaponProjectileEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)new ItemStack((IItemProvider)Items.field_151040_l));
        super.func_70088_a();
    }

    public void func_213281_b(CompoundNBT nbt) {
        if (this.getStack() != null) {
            nbt.func_218657_a("stackNBT", (INBT)this.getStack().serializeNBT());
        }
        nbt.func_74768_a("wpe_life", this.wpe_life);
        super.func_213281_b(nbt);
    }

    public void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("stackNBT")) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a("stackNBT")));
            stack.func_190920_e(1);
            this.setStack(stack);
        }
        this.wpe_life = nbt.func_74762_e("wpe_life");
        super.func_70037_a(nbt);
    }

    protected ItemStack func_184550_j() {
        return this.getStack();
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        double d = this.func_213322_ci().func_72433_c();
        double damage = MathHelper.func_76143_f((double)d);
        Entity entity = result.func_216348_a();
        if (this.field_70170_p instanceof ServerWorld) {
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerWorld)this.field_70170_p, "faker");
            ItemStack stack = this.func_184550_j();
            fake_player.func_184611_a(Hand.MAIN_HAND, stack);
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon Modifier", MTConfig.WEAPON_SHOOTER_DAMAGE_MULTIPLIER, AttributeModifier.Operation.MULTIPLY_TOTAL));
            fake_player.func_233645_dx_().func_233793_b_(stack.func_111283_C(EquipmentSlotType.MAINHAND));
            fake_player.func_233645_dx_().func_233793_b_((Multimap)multimap);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.getStack().func_77973_b() instanceof Clarent && this.func_234616_v_() instanceof PlayerEntity) {
                    int mana = ClarentEffect.getManaCostClarent(this.getStack(), (PlayerEntity)this.func_234616_v_());
                    PlayerManaManager.donateManaToFakePlayer(fake_player, (PlayerEntity)this.func_234616_v_(), mana);
                }
                fake_player.field_184617_aD = 1000;
                fake_player.func_71059_n(entity);
                this.func_184548_a(livingEntity);
                Entity shooter = null;
                if (this.func_234616_v_() != null && this.field_70170_p != null && (shooter = this.func_234616_v_()) != null && entity != shooter && livingEntity instanceof PlayerEntity && shooter instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)shooter).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
            }
        }
    }

    public void func_70071_h_() {
        if (this.field_70252_j > 5) {
            this.field_70252_j = 4;
        }
        ++this.wpe_life;
        if (this.wpe_life > 3600) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    public void func_70100_b_(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i) {
            boolean flag = true;
            ItemStack stack = this.func_184550_j().func_77946_l();
            stack.func_190920_e(1);
            stack.func_222118_a(2, (LivingEntity)player, z -> {});
            if (!player.field_71071_by.func_70441_a(stack)) {
                flag = false;
            }
            if (flag) {
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.func_213317_d(this.func_213322_ci().func_72441_c(shooter.func_213322_ci().field_72450_a, shooter.func_233570_aj_() ? 0.0 : shooter.func_213322_ci().field_72448_b, shooter.func_213322_ci().field_72449_c));
    }

    public ItemStack getStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(this.func_226277_ct_() - 1.0, this.func_226278_cu_() - 1.0, this.func_226281_cx_() - 1.0, this.func_226277_ct_() + 1.0, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + 1.0);
    }

    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }
}

