/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TridentItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ProjectionSpellEffect {
    public static boolean projection(PlayerEntity caster, CompoundNBT weaponNBT) {
        int setDamage = MTConfig.PROJECTION_DURABILITY_FACTOR;
        if (weaponNBT != null) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)weaponNBT).func_77946_l();
            stack.func_190920_e(1);
            if (MTConfig.PROJECTION_DURABILITY_FLAT) {
                setDamage = stack.func_77958_k() - setDamage;
            }
            stack.func_196085_b(setDamage);
            stack = ProjectionSpellEffect.removeDisallowedEnchants(stack);
            StrengtheningSpellEffect.reduceStrengthened(stack, StrengtheningSpellEffect.getStrengthened(stack));
            ProjectionSpellEffect.setProjected(stack);
            return caster.func_191521_c(stack);
        }
        return false;
    }

    public static void setProjected(ItemStack s) {
        CompoundNBT nbt = s.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74757_a("MAHOUTSUKAI_PROJECTION", true);
        s.func_77982_d(nbt);
    }

    public static boolean getProjected(ItemStack s) {
        CompoundNBT nbt = s.func_77978_p();
        return nbt != null && nbt.func_74764_b("MAHOUTSUKAI_PROJECTION") && nbt.func_74767_n("MAHOUTSUKAI_PROJECTION");
    }

    public static void projectionUpdateAnvil(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if ((ProjectionSpellEffect.getProjected(left) || ProjectionSpellEffect.getProjected(right)) && MTConfig.PROJECTION_ANVIL_CANCEL) {
            event.setCanceled(true);
        }
    }

    public static void projectionRepairAnvil(AnvilRepairEvent event) {
        ItemStack left = event.getItemInput();
        ItemStack right = event.getIngredientInput();
        if (ProjectionSpellEffect.getProjected(left) || ProjectionSpellEffect.getProjected(right)) {
            if (!MTConfig.PROJECTION_ANVIL_CANCEL) {
                Map enchs = EnchantmentHelper.func_82781_a((ItemStack)event.getItemResult());
                Map enchsleft = EnchantmentHelper.func_82781_a((ItemStack)left);
                Map enchsright = EnchantmentHelper.func_82781_a((ItemStack)right);
                for (Enchantment e : enchs.keySet()) {
                    if (!enchsleft.containsKey(e) || !enchsright.containsKey(e)) continue;
                    Integer m = (Integer)enchsleft.get(e);
                    Integer k = (Integer)enchsright.get(e);
                    enchs.put(e, Math.min(m, k));
                }
                EnchantmentHelper.func_82782_a((Map)enchs, (ItemStack)event.getItemResult());
            } else {
                event.setCanceled(true);
            }
        }
    }

    public static CompoundNBT memorize(PlayerEntity caster) {
        if (caster != null) {
            Entity e = Utils.selectEntityNearCursor(caster, MTConfig.GLOBAL_LOOK_RANGE, caster.field_70170_p, a -> Utils.getPredicate(Utils.MAHOU_SELECTION.SCROLL_PROJECTION, a, caster), Utils.nearAllowed(Utils.MAHOU_SELECTION.SCROLL_PROJECTION));
            CompoundNBT ret = new CompoundNBT();
            if (e instanceof LivingEntity) {
                Iterable lst = e.func_184214_aD();
                for (ItemStack tmp : lst) {
                    Item tmpi = tmp.func_77973_b();
                    if (!ProjectionSpellEffect.canProject(tmpi)) continue;
                    tmp.func_77955_b(ret);
                    return ret;
                }
            } else if (e instanceof ItemEntity) {
                if (ProjectionSpellEffect.canProject(((ItemEntity)e).func_92059_d().func_77973_b())) {
                    ((ItemEntity)e).func_92059_d().func_77955_b(ret);
                    return ret;
                }
            } else if (e instanceof ItemFrameEntity) {
                if (ProjectionSpellEffect.canProject(((ItemFrameEntity)e).func_82335_i().func_77973_b())) {
                    ((ItemFrameEntity)e).func_82335_i().func_77955_b(ret);
                    return ret;
                }
            } else if (e instanceof WeaponProjectileEntity) {
                if (ProjectionSpellEffect.canProject(((WeaponProjectileEntity)e).getStack().func_77973_b())) {
                    ((WeaponProjectileEntity)e).getStack().func_77955_b(ret);
                    return ret;
                }
            } else if (e instanceof TridentEntity && ProjectionSpellEffect.canProject(((TridentEntity)e).field_203054_h.func_77973_b())) {
                ((TridentEntity)e).field_203054_h.func_77955_b(ret);
                return ret;
            }
        }
        return null;
    }

    public static boolean canProject(Item tmpi) {
        boolean ret = tmpi instanceof BowItem || tmpi instanceof SwordItem || tmpi instanceof AxeItem || tmpi instanceof HoeItem || tmpi instanceof ShovelItem || tmpi instanceof PickaxeItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof TridentItem || tmpi instanceof CrossbowItem;
        return ret && !ProjectionSpellEffect.disallowed(tmpi) || EffectUtil.inItemBlacklist(tmpi, MTConfig.PROJECTION_EXPLICIT_WHITELIST);
    }

    public static boolean disallowed(Item tmpi) {
        if (tmpi.getRegistryName() != null) {
            HashSet<? extends String> disallowed = new HashSet<String>(MTConfig.PROJECTION_BLACKLIST);
            if (MTConfig.PROJECTION_IS_BLACKLIST) {
                return disallowed.contains(tmpi.getRegistryName().toString()) || disallowed.contains(tmpi.getRegistryName().func_110624_b());
            }
            return !disallowed.contains(tmpi.getRegistryName().toString()) && !disallowed.contains(tmpi.getRegistryName().func_110624_b());
        }
        return false;
    }

    public static ItemStack removeDisallowedEnchants(ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        HashSet<? extends String> disallowed = new HashSet<String>(MTConfig.PROJECTION_ENCHANTMENT_BLACKLIST);
        Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)copy);
        map = map.entrySet().stream().filter(a -> !disallowed.contains(((Enchantment)a.getKey()).getRegistryName().toString())).collect(Collectors.toMap(m -> (Enchantment)m.getKey(), m -> (Integer)m.getValue()));
        EnchantmentHelper.func_82782_a(map, (ItemStack)copy);
        return copy;
    }
}

