/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.settingsmahou;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import stepsword.mahoutsukai.capability.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.SettingsMahouPacket;
import stepsword.mahoutsukai.util.Utils;

public class MahouSettings {
    public static ConcurrentHashMap<Integer, List<Integer>> intsettings;
    public static HashSet<Spell> primaryColor;
    public static HashSet<Spell> secondaryColor;

    public static ConcurrentHashMap<Integer, List<Integer>> getIntDefaults() {
        intsettings = new ConcurrentHashMap();
        intsettings.put(Spell.RHO_AIAS.ordinal(), Arrays.asList(255, 94, 204, 255, 94, 204));
        intsettings.put(Spell.GANDR.ordinal(), Arrays.asList(216, 0, 0, 0, 0, 0));
        intsettings.put(Spell.TREASURY_WEAPONS.ordinal(), Arrays.asList(255, 255, 150, 0, 0, 0));
        intsettings.put(Spell.TREASURY_CHAINS.ordinal(), Arrays.asList(244, 237, 64, 0, 0, 0));
        intsettings.put(Spell.MORGAN.ordinal(), Arrays.asList(255, 50, 50, 0, 0, 0));
        intsettings.put(Spell.MORGAN_BALL.ordinal(), Arrays.asList(150, 0, 0, 0, 0, 0));
        intsettings.put(Spell.MYSTIC_STAFF_BIG.ordinal(), Arrays.asList(224, 64, 0, 0, 0, 0));
        intsettings.put(Spell.MYSTIC_STAFF_AOE.ordinal(), Arrays.asList(166, 125, 224, 0, 0, 0));
        intsettings.put(Spell.MYSTIC_STAFF_BEAM.ordinal(), Arrays.asList(140, 82, 191, 0, 0, 0));
        return intsettings;
    }

    public static boolean hasPrimary(Spell spell) {
        return primaryColor.contains((Object)spell);
    }

    public static boolean hasSecondary(Spell spell) {
        return secondaryColor.contains((Object)spell);
    }

    public static List<Integer> getIntSettings(PlayerEntity player, Spell spell) {
        ISettingsMahou settings = Utils.getSettingsMahou((LivingEntity)player);
        if (settings != null) {
            try {
                List<Integer> ret = settings.getIntSettings(spell.ordinal());
                List<Integer> defaults = MahouSettings.getIntDefaults().get(spell.ordinal());
                if (ret.size() < defaults.size()) {
                    for (int i = ret.size(); i < defaults.size(); ++i) {
                        ret.add(defaults.get(i));
                    }
                }
                return ret;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return MahouSettings.getIntDefaults().get(spell.ordinal());
    }

    public static float colorConvert(int c) {
        return (float)c / 255.0f;
    }

    public static void updateClientMahou(ServerPlayerEntity player) {
        ISettingsMahou mahou;
        if (player != null && (mahou = Utils.getSettingsMahou((LivingEntity)player)) != null) {
            PacketHandler.sendTo(player, new SettingsMahouPacket(mahou));
        }
    }

    static {
        primaryColor = new HashSet<Spell>(Arrays.asList(Spell.RHO_AIAS, Spell.GANDR, Spell.TREASURY_WEAPONS, Spell.TREASURY_CHAINS, Spell.MORGAN, Spell.MORGAN_BALL, Spell.MYSTIC_STAFF_BIG, Spell.MYSTIC_STAFF_BEAM, Spell.MYSTIC_STAFF_AOE));
        secondaryColor = new HashSet<Spell>(Arrays.asList(Spell.RHO_AIAS, Spell.GANDR, Spell.MORGAN_BALL));
    }

    public static enum Spell {
        RHO_AIAS,
        GANDR,
        TREASURY_WEAPONS,
        TREASURY_CHAINS,
        MORGAN,
        MORGAN_BALL,
        MYSTIC_STAFF_BIG,
        MYSTIC_STAFF_BEAM,
        MYSTIC_STAFF_AOE;

    }
}

