/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.chunks;

import io.netty.util.internal.ConcurrentSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.util.Utils;

public class ChunkMahouStorage
implements Capability.IStorage<IChunkMahou> {
    public static String LAKE_LIST = "MAHOU_LAKE_LIST";
    public static String LAKE_BLOCK = "m";
    public static String FOG_LIST = "MAHOU_FOG_LIST";
    public static String FOG_BLOCK = "f";
    public static String LAKE_RETRO = "MAHOU_LAKE_RETRO";

    @Nullable
    public INBT writeNBT(Capability<IChunkMahou> capability, IChunkMahou instance, Direction side) {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT lakeList = new ListNBT();
        if (instance.getLakeBlocks() != null) {
            for (BlockPos p : instance.getLakeBlocks()) {
                if (p == null) continue;
                lakeList.add(0, (INBT)Utils.blockposToNBT(p, LAKE_BLOCK));
            }
        }
        nbt.func_218657_a(LAKE_LIST, (INBT)lakeList);
        ListNBT fogList = new ListNBT();
        if (instance.getFogProjectors() != null) {
            for (BlockPos p : instance.getFogProjectors()) {
                if (p == null) continue;
                fogList.add(0, (INBT)Utils.blockposToNBT(p, FOG_BLOCK));
            }
        }
        nbt.func_218657_a(FOG_LIST, (INBT)fogList);
        nbt.func_74757_a(LAKE_RETRO, instance.needsRetroFixLake());
        return nbt;
    }

    public void readNBT(Capability<IChunkMahou> capability, IChunkMahou instance, Direction side, INBT nbtb) {
        BlockPos p;
        CompoundNBT blockNBT;
        int i;
        CompoundNBT nbt = (CompoundNBT)nbtb;
        if (nbt.func_74764_b(LAKE_LIST)) {
            ConcurrentSet lakeBlocks = new ConcurrentSet();
            ListNBT lakeList = (ListNBT)nbt.func_74781_a(LAKE_LIST);
            if (lakeList != null) {
                for (i = 0; i < lakeList.size(); ++i) {
                    blockNBT = (CompoundNBT)lakeList.get(i);
                    p = Utils.NBTtoBlockPos(blockNBT, LAKE_BLOCK);
                    if (p == null) continue;
                    lakeBlocks.add((Object)p);
                }
            }
            instance.setLakeBlocks((ConcurrentSet<BlockPos>)lakeBlocks);
        }
        if (nbt.func_74764_b(FOG_LIST)) {
            ConcurrentSet fogBlocks = new ConcurrentSet();
            ListNBT fogList = (ListNBT)nbt.func_74781_a(FOG_LIST);
            if (fogList != null) {
                for (i = 0; i < fogList.size(); ++i) {
                    blockNBT = (CompoundNBT)fogList.get(i);
                    p = Utils.NBTtoBlockPos(blockNBT, FOG_BLOCK);
                    if (p == null) continue;
                    fogBlocks.add((Object)p);
                }
            }
            instance.setFogProjectors((ConcurrentSet<BlockPos>)fogBlocks);
        }
        instance.setNeedsRetroFixLake(nbt.func_74767_n(LAKE_RETRO));
    }
}

