/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import fionathemortal.betterbiomeblend.Color;
import java.util.concurrent.atomic.AtomicInteger;

public final class ColorChunk {
    public byte[] data;
    public long key;
    public int invalidationCounter;
    public AtomicInteger refCount = new AtomicInteger();

    public ColorChunk() {
        this.data = new byte[768];
        this.markAsInvalid();
    }

    public int getReferenceCount() {
        int result = this.refCount.get();
        return result;
    }

    public int release() {
        int result = this.refCount.decrementAndGet();
        return result;
    }

    public void acquire() {
        this.refCount.incrementAndGet();
    }

    public void markAsInvalid() {
        this.key = -1L;
    }

    public int getColor(int x, int z) {
        int blockX = x & 0xF;
        int blockZ = z & 0xF;
        int offset = 3 * (blockZ << 4 | blockX);
        byte colorR = this.data[offset + 0];
        byte colorG = this.data[offset + 1];
        byte colorB = this.data[offset + 2];
        int result = Color.makeRGBAWithFullAlpha(colorR, colorG, colorB);
        return result;
    }
}

