/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import fionathemortal.betterbiomeblend.BetterBiomeBlendClient;
import fionathemortal.betterbiomeblend.BiomeCache;
import fionathemortal.betterbiomeblend.BiomeChunk;
import fionathemortal.betterbiomeblend.Color;
import fionathemortal.betterbiomeblend.ColorBlendBuffer;
import fionathemortal.betterbiomeblend.ColorCache;
import fionathemortal.betterbiomeblend.ColorChunk;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.level.ColorResolver;

public final class ColorBlending {
    public static final ReentrantLock freeBlendBuffersLock = new ReentrantLock();
    public static final Stack<ColorBlendBuffer> freeBlendBuffers = new Stack();
    public static final byte[] neighborOffsets = new byte[]{0, 0, -1, -1, 0, -1, 1, -1, -1, 0, 1, 0, -1, 1, 0, 1, 1, 1};
    public static final byte[] neighborRectParams = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, -16, -16, 0, 0, 0, -1, 0, 0, 0, -16, 0, 0, 0, -1, -1, 0, 16, -16, 0, 0, -1, 0, 0, 0, -16, 0, 0, 0, 0, 0, -1, 0, 16, 0, 0, 0, -1, 0, 0, -1, -16, 16, 0, 0, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, -1, -1, 16, 16, 0, 0};

    public static int getNeighborOffsetX(int chunkIndex) {
        byte result = neighborOffsets[2 * chunkIndex + 0];
        return result;
    }

    public static int getNeighborOffsetZ(int chunkIndex) {
        byte result = neighborOffsets[2 * chunkIndex + 1];
        return result;
    }

    public static int getNeighborPosX(int index, int chunkX) {
        int offset = ColorBlending.getNeighborOffsetX(index);
        int result = chunkX + offset;
        return result;
    }

    public static int getNeighborPosZ(int index, int chunkZ) {
        int offset = ColorBlending.getNeighborOffsetZ(index);
        int result = chunkZ + offset;
        return result;
    }

    public static int getNeighborRectMinX(int chunkIndex, int radius) {
        int offset = 8 * chunkIndex;
        int result = neighborRectParams[offset + 0] & 16 - radius;
        return result;
    }

    public static int getNeighborRectMinZ(int chunkIndex, int radius) {
        int offset = 8 * chunkIndex;
        int result = neighborRectParams[offset + 1] & 16 - radius;
        return result;
    }

    public static int getNeighborRectMaxX(int chunkIndex, int radius) {
        int offset = 8 * chunkIndex;
        int result = (neighborRectParams[offset + 2] & radius - 16) + 16;
        return result;
    }

    public static int getNeighborRectMaxZ(int chunkIndex, int radius) {
        int offset = 8 * chunkIndex;
        int result = (neighborRectParams[offset + 3] & radius - 16) + 16;
        return result;
    }

    public static int getNeighborRectBlendBufferMinX(int chunkIndex, int radius) {
        int offset = 8 * chunkIndex;
        int result = Math.max(neighborRectParams[offset + 4] + radius, 0);
        return result;
    }

    public static int getNeighborRectBlendBufferMinZ(int chunkIndex, int radius) {
        int offset = 8 * chunkIndex;
        int result = Math.max(neighborRectParams[offset + 5] + radius, 0);
        return result;
    }

    public static ColorBlendBuffer acquireBlendBuffer(int blendRadius) {
        ColorBlendBuffer result = null;
        freeBlendBuffersLock.lock();
        while (!freeBlendBuffers.empty()) {
            ColorBlendBuffer buffer = freeBlendBuffers.pop();
            if (buffer.blendRadius != blendRadius) continue;
            result = buffer;
            break;
        }
        freeBlendBuffersLock.unlock();
        if (result == null) {
            result = new ColorBlendBuffer(blendRadius);
        }
        return result;
    }

    public static void releaseBlendBuffer(ColorBlendBuffer cache) {
        freeBlendBuffersLock.lock();
        int blendRadius = BetterBiomeBlendClient.getBlendRadiusSetting();
        if (cache.blendRadius == blendRadius) {
            freeBlendBuffers.push(cache);
        }
        freeBlendBuffersLock.unlock();
    }

    public static void gatherRawColorsForChunk(World world, byte[] result, int chunkX, int chunkZ, ColorResolver colorResolver) {
        double baseZF64;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        int blockX = 16 * chunkX;
        int blockZ = 16 * chunkZ;
        int dstIndex = 0;
        double baseXF64 = blockX;
        double zF64 = baseZF64 = (double)blockZ;
        for (int z = 0; z < 16; ++z) {
            double xF64 = baseXF64;
            for (int x = 0; x < 16; ++x) {
                blockPos.func_181079_c(blockX + x, 0, blockZ + z);
                int color = colorResolver.getColor(world.func_226691_t_((BlockPos)blockPos), xF64, zF64);
                int colorR = Color.RGBAGetR(color);
                int colorG = Color.RGBAGetG(color);
                int colorB = Color.RGBAGetB(color);
                result[3 * dstIndex + 0] = (byte)colorR;
                result[3 * dstIndex + 1] = (byte)colorG;
                result[3 * dstIndex + 2] = (byte)colorB;
                ++dstIndex;
                xF64 += 1.0;
            }
            zF64 += 1.0;
        }
    }

    public static void fillBlendBufferWithDefaultColor(World world, ColorResolver colorResolver, int blendRadius, int neighborIndex, int defaultColor, byte[] blendBuffer) {
        int colorR = Color.RGBAGetR(defaultColor);
        int colorG = Color.RGBAGetG(defaultColor);
        int colorB = Color.RGBAGetB(defaultColor);
        int cacheMinX = ColorBlending.getNeighborRectMinX(neighborIndex, blendRadius);
        int cacheMinZ = ColorBlending.getNeighborRectMinZ(neighborIndex, blendRadius);
        int cacheMaxX = ColorBlending.getNeighborRectMaxX(neighborIndex, blendRadius);
        int cacheMaxZ = ColorBlending.getNeighborRectMaxZ(neighborIndex, blendRadius);
        int blendMinX = ColorBlending.getNeighborRectBlendBufferMinX(neighborIndex, blendRadius);
        int blendMinZ = ColorBlending.getNeighborRectBlendBufferMinZ(neighborIndex, blendRadius);
        int blendDim = 16 + 2 * blendRadius;
        int blendLine = 3 * (blendMinX + blendMinZ * blendDim);
        for (int z = cacheMinZ; z < cacheMaxZ; ++z) {
            int blendIndex = blendLine;
            for (int x = cacheMinX; x < cacheMaxX; ++x) {
                blendBuffer[blendIndex + 0] = (byte)colorR;
                blendBuffer[blendIndex + 1] = (byte)colorG;
                blendBuffer[blendIndex + 2] = (byte)colorB;
                blendIndex += 3;
            }
            blendLine += 3 * blendDim;
        }
    }

    public static void gatherColors(World world, ColorResolver colorResolver, int chunkX, int chunkZ, int blendRadius, int neighborIndex, byte[] cachedColors, Biome[] cachedBiomes, byte[] blendBuffer, boolean genNewColors, int defaultColor) {
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        int cacheMinX = ColorBlending.getNeighborRectMinX(neighborIndex, blendRadius);
        int cacheMinZ = ColorBlending.getNeighborRectMinZ(neighborIndex, blendRadius);
        int cacheMaxX = ColorBlending.getNeighborRectMaxX(neighborIndex, blendRadius);
        int cacheMaxZ = ColorBlending.getNeighborRectMaxZ(neighborIndex, blendRadius);
        int blendMinX = ColorBlending.getNeighborRectBlendBufferMinX(neighborIndex, blendRadius);
        int blendMinZ = ColorBlending.getNeighborRectBlendBufferMinZ(neighborIndex, blendRadius);
        int cacheDim = 16;
        int blendDim = 16 + 2 * blendRadius;
        int blockX = 16 * chunkX;
        int blockZ = 16 * chunkZ;
        double baseXF64 = blockX + cacheMinX;
        double baseZF64 = blockZ + cacheMinZ;
        int cacheLine = cacheMinX + cacheMinZ * 16;
        int blendLine = 3 * (blendMinX + blendMinZ * blendDim);
        double zF64 = baseZF64;
        for (int z = cacheMinZ; z < cacheMaxZ; ++z) {
            int cacheIndex = cacheLine;
            int blendIndex = blendLine;
            double xF64 = baseXF64;
            for (int x = cacheMinX; x < cacheMaxX; ++x) {
                int cachedR = 0xFF & cachedColors[3 * cacheIndex + 0];
                int cachedG = 0xFF & cachedColors[3 * cacheIndex + 1];
                int cachedB = 0xFF & cachedColors[3 * cacheIndex + 2];
                int commonBits = cachedR & cachedG & cachedB;
                if (commonBits == 255) {
                    if (genNewColors) {
                        Biome biome = cachedBiomes[cacheIndex];
                        if (biome == null) {
                            blockPos.func_181079_c(blockX + x, 0, blockZ + z);
                            cachedBiomes[cacheIndex] = biome = world.func_226691_t_((BlockPos)blockPos);
                        }
                        int color = colorResolver.getColor(biome, xF64, zF64);
                        cachedR = Color.RGBAGetR(color);
                        cachedG = Color.RGBAGetG(color);
                        cachedB = Color.RGBAGetB(color);
                        cachedColors[3 * cacheIndex + 0] = (byte)cachedR;
                        cachedColors[3 * cacheIndex + 1] = (byte)cachedG;
                        cachedColors[3 * cacheIndex + 2] = (byte)cachedB;
                    } else {
                        cachedR = Color.RGBAGetR(defaultColor);
                        cachedG = Color.RGBAGetG(defaultColor);
                        cachedB = Color.RGBAGetB(defaultColor);
                    }
                }
                blendBuffer[blendIndex + 0] = (byte)cachedR;
                blendBuffer[blendIndex + 1] = (byte)cachedG;
                blendBuffer[blendIndex + 2] = (byte)cachedB;
                ++cacheIndex;
                blendIndex += 3;
                xF64 += 1.0;
            }
            blendLine += 3 * blendDim;
            cacheLine += 16;
            zF64 += 1.0;
        }
    }

    public static int gatherColorsForCenterChunkSafeRegion(World world, ColorResolver colorResolver, int chunkX, int chunkZ, int blendRadius, byte[] cachedColors, Biome[] cachedBiomes, byte[] blendBuffer) {
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        int cacheMinX = ColorBlending.getNeighborRectMinX(0, blendRadius) + 2;
        int cacheMinZ = ColorBlending.getNeighborRectMinZ(0, blendRadius) + 2;
        int cacheMaxX = ColorBlending.getNeighborRectMaxX(0, blendRadius) - 2;
        int cacheMaxZ = ColorBlending.getNeighborRectMaxZ(0, blendRadius) - 2;
        int blendMinX = ColorBlending.getNeighborRectBlendBufferMinX(0, blendRadius) + 2;
        int blendMinZ = ColorBlending.getNeighborRectBlendBufferMinZ(0, blendRadius) + 2;
        int cacheDim = 16;
        int blendDim = 16 + 2 * blendRadius;
        int blockX = 16 * chunkX;
        int blockZ = 16 * chunkZ;
        double baseXF64 = blockX + cacheMinX;
        double baseZF64 = blockZ + cacheMinZ;
        int cacheLine = cacheMinX + cacheMinZ * 16;
        int blendLine = 3 * (blendMinX + blendMinZ * blendDim);
        int accumulatedR = 0;
        int accumulatedG = 0;
        int accumulatedB = 0;
        double zF64 = baseZF64;
        for (int z = cacheMinZ; z < cacheMaxZ; ++z) {
            int cacheIndex = cacheLine;
            int blendIndex = blendLine;
            double xF64 = baseXF64;
            for (int x = cacheMinX; x < cacheMaxX; ++x) {
                int cachedR = 0xFF & cachedColors[3 * cacheIndex + 0];
                int cachedG = 0xFF & cachedColors[3 * cacheIndex + 1];
                int cachedB = 0xFF & cachedColors[3 * cacheIndex + 2];
                int commonBits = cachedR & cachedG & cachedB;
                if (commonBits == 255) {
                    Biome biome = cachedBiomes[cacheIndex];
                    if (biome == null) {
                        blockPos.func_181079_c(blockX + x, 0, blockZ + z);
                        cachedBiomes[cacheIndex] = biome = world.func_226691_t_((BlockPos)blockPos);
                    }
                    int color = colorResolver.getColor(biome, xF64, zF64);
                    cachedR = Color.RGBAGetR(color);
                    cachedG = Color.RGBAGetG(color);
                    cachedB = Color.RGBAGetB(color);
                    cachedColors[3 * cacheIndex + 0] = (byte)cachedR;
                    cachedColors[3 * cacheIndex + 1] = (byte)cachedG;
                    cachedColors[3 * cacheIndex + 2] = (byte)cachedB;
                }
                accumulatedR += cachedR;
                accumulatedG += cachedG;
                accumulatedB += cachedB;
                blendBuffer[blendIndex + 0] = (byte)cachedR;
                blendBuffer[blendIndex + 1] = (byte)cachedG;
                blendBuffer[blendIndex + 2] = (byte)cachedB;
                ++cacheIndex;
                blendIndex += 3;
                xF64 += 1.0;
            }
            blendLine += 3 * blendDim;
            cacheLine += 16;
            zF64 += 1.0;
        }
        int averageR = accumulatedR / 144;
        int averageG = accumulatedG / 144;
        int averageB = accumulatedB / 144;
        int result = Color.makeRGBAWithFullAlpha(averageR, averageG, averageB);
        return result;
    }

    public static void fillCenterChunkBoundaryWithDefaultColor(int blendRadius, byte[] blendBuffer, int defaultColor) {
        int blendMinX = ColorBlending.getNeighborRectBlendBufferMinX(0, blendRadius);
        int blendMinZ = ColorBlending.getNeighborRectBlendBufferMinZ(0, blendRadius);
        int blendDim = 16 + 2 * blendRadius;
        int defaultR = Color.RGBAGetR(defaultColor);
        int defaultG = Color.RGBAGetG(defaultColor);
        int defaultB = Color.RGBAGetB(defaultColor);
        int blendLine = 3 * (blendMinX + blendMinZ * blendDim);
        for (int z = 0; z < 16; ++z) {
            if (z < 2 || z > 13) {
                int blendIndex = blendLine;
                for (int x = 0; x < 16; ++x) {
                    if (x < 2 || x > 13) {
                        blendBuffer[blendIndex + 0] = (byte)defaultR;
                        blendBuffer[blendIndex + 1] = (byte)defaultG;
                        blendBuffer[blendIndex + 2] = (byte)defaultB;
                    }
                    blendIndex += 3;
                }
            }
            blendLine += 3 * blendDim;
        }
    }

    public static void gatherRawColorsToCaches(World world, ColorResolver colorResolver, int colorType, int chunkX, int chunkZ, int blendRadius, ColorCache colorCache, BiomeCache biomeCache, byte[] blendBuffer) {
        boolean neighborsAreLoaded = true;
        Chunk[] neighbors = new Chunk[9];
        for (int index = 0; index < 9; ++index) {
            int neighborZ;
            int neighborX = ColorBlending.getNeighborPosX(index, chunkX);
            IChunk chunk = world.func_217353_a(neighborX, neighborZ = ColorBlending.getNeighborPosZ(index, chunkZ), ChunkStatus.field_222608_d, false);
            if (chunk != null) {
                neighbors[index] = chunk;
                continue;
            }
            neighborsAreLoaded = false;
        }
        int defaultColor = 0;
        BiomeChunk biomeChunk = biomeCache.getOrDefaultInitializeChunk(chunkX, chunkZ);
        ColorChunk colorChunk = colorCache.getOrDefaultInitializeChunk(chunkX, chunkZ, colorType);
        if (neighborsAreLoaded) {
            ColorBlending.gatherColors(world, colorResolver, chunkX, chunkZ, blendRadius, 0, colorChunk.data, biomeChunk.data, blendBuffer, true, defaultColor);
        } else {
            defaultColor = ColorBlending.gatherColorsForCenterChunkSafeRegion(world, colorResolver, chunkX, chunkZ, blendRadius, colorChunk.data, biomeChunk.data, blendBuffer);
            ColorBlending.fillCenterChunkBoundaryWithDefaultColor(blendRadius, blendBuffer, defaultColor);
        }
        colorCache.releaseChunk(colorChunk);
        biomeCache.releaseChunk(biomeChunk);
        for (int index = 1; index < 9; ++index) {
            int neighborX = ColorBlending.getNeighborPosX(index, chunkX);
            int neighborZ = ColorBlending.getNeighborPosZ(index, chunkZ);
            BiomeChunk neighborBiomeChunk = biomeCache.getOrDefaultInitializeChunk(neighborX, neighborZ);
            ColorChunk neighborColorChunk = colorCache.getOrDefaultInitializeChunk(neighborX, neighborZ, colorType);
            if (neighbors[index] != null) {
                ColorBlending.gatherColors(world, colorResolver, neighborX, neighborZ, blendRadius, index, neighborColorChunk.data, neighborBiomeChunk.data, blendBuffer, neighborsAreLoaded, defaultColor);
            } else {
                ColorBlending.fillBlendBufferWithDefaultColor(world, colorResolver, blendRadius, index, defaultColor, blendBuffer);
            }
            colorCache.releaseChunk(neighborColorChunk);
            biomeCache.releaseChunk(neighborBiomeChunk);
        }
    }

    public static void blendColorsForChunk(World world, byte[] result, ColorBlendBuffer blendCache) {
        int z;
        float[] R = blendCache.R;
        float[] G = blendCache.G;
        float[] B = blendCache.B;
        int blendRadius = blendCache.blendRadius;
        int blendDim = 2 * blendRadius + 1;
        int blendCacheDim = 16 + 2 * blendRadius;
        int blendCount = blendDim * blendDim;
        for (int x = 0; x < blendCacheDim; ++x) {
            R[x] = Color.sRGBByteToLinearFloat(0xFF & blendCache.color[3 * x + 0]);
            G[x] = Color.sRGBByteToLinearFloat(0xFF & blendCache.color[3 * x + 1]);
            B[x] = Color.sRGBByteToLinearFloat(0xFF & blendCache.color[3 * x + 2]);
        }
        for (z = 1; z < blendDim; ++z) {
            for (int x = 0; x < blendCacheDim; ++x) {
                int n = x;
                R[n] = R[n] + Color.sRGBByteToLinearFloat(0xFF & blendCache.color[3 * (blendCacheDim * z + x) + 0]);
                int n2 = x;
                G[n2] = G[n2] + Color.sRGBByteToLinearFloat(0xFF & blendCache.color[3 * (blendCacheDim * z + x) + 1]);
                int n3 = x;
                B[n3] = B[n3] + Color.sRGBByteToLinearFloat(0xFF & blendCache.color[3 * (blendCacheDim * z + x) + 2]);
            }
        }
        for (z = 0; z < 16; ++z) {
            int x;
            float accumulatedR = 0.0f;
            float accumulatedG = 0.0f;
            float accumulatedB = 0.0f;
            for (x = 0; x < blendDim; ++x) {
                accumulatedR += R[x];
                accumulatedG += G[x];
                accumulatedB += B[x];
            }
            for (x = 0; x < 16; ++x) {
                float colorR = accumulatedR / (float)blendCount;
                float colorG = accumulatedG / (float)blendCount;
                float colorB = accumulatedB / (float)blendCount;
                result[3 * (16 * z + x) + 0] = Color.linearFloatTosRGBByte(colorR);
                result[3 * (16 * z + x) + 1] = Color.linearFloatTosRGBByte(colorG);
                result[3 * (16 * z + x) + 2] = Color.linearFloatTosRGBByte(colorB);
                if (x >= 15) continue;
                accumulatedR += R[x + blendDim] - R[x];
                accumulatedG += G[x + blendDim] - G[x];
                accumulatedB += B[x + blendDim] - B[x];
            }
            if (z >= 15) continue;
            x = 0;
            while (x < blendCacheDim) {
                int index1 = 3 * (blendCacheDim * z + x);
                int index2 = 3 * (blendCacheDim * (z + blendDim) + x);
                int n = x;
                R[n] = R[n] + (Color.sRGBByteToLinearFloat(0xFF & blendCache.color[index2 + 0]) - Color.sRGBByteToLinearFloat(0xFF & blendCache.color[index1 + 0]));
                int n4 = x;
                G[n4] = G[n4] + (Color.sRGBByteToLinearFloat(0xFF & blendCache.color[index2 + 1]) - Color.sRGBByteToLinearFloat(0xFF & blendCache.color[index1 + 1]));
                int n5 = x++;
                B[n5] = B[n5] + (Color.sRGBByteToLinearFloat(0xFF & blendCache.color[index2 + 2]) - Color.sRGBByteToLinearFloat(0xFF & blendCache.color[index1 + 2]));
            }
        }
    }

    public static void generateBlendedColorChunk(World world, ColorResolver colorResolverIn, int colorType, int chunkX, int chunkZ, ColorCache blendCache, BiomeCache biomeCache, byte[] result) {
        int blendRadius = BetterBiomeBlendClient.getBlendRadiusSetting();
        if (blendRadius > 0 && blendRadius <= 14) {
            ColorBlendBuffer blendBuffer = ColorBlending.acquireBlendBuffer(blendRadius);
            ColorBlending.gatherRawColorsToCaches(world, colorResolverIn, colorType, chunkX, chunkZ, blendBuffer.blendRadius, blendCache, biomeCache, blendBuffer.color);
            ColorBlending.blendColorsForChunk(world, result, blendBuffer);
            ColorBlending.releaseBlendBuffer(blendBuffer);
        } else {
            ColorBlending.gatherRawColorsForChunk(world, result, chunkX, chunkZ, colorResolverIn);
        }
    }
}

