/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class UseItemTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("silentlib", "use_item");
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listenerIn) {
        Listeners triggerListeners = this.listeners.get(playerAdvancementsIn);
        if (triggerListeners == null) {
            triggerListeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, triggerListeners);
        }
        triggerListeners.add(listenerIn);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listenerIn) {
        Listeners triggerListeners = this.listeners.get(playerAdvancementsIn);
        if (triggerListeners != null) {
            triggerListeners.remove(listenerIn);
            if (triggerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserialize(JsonObject json, ConditionArrayParser p_230307_2_) {
        ItemPredicate itempredicate = ItemPredicate.func_192492_a((JsonElement)json.get("item"));
        Target target = Target.fromString(JSONUtils.func_151219_a((JsonObject)json, (String)"target", (String)"any"));
        return new Instance(itempredicate, target);
    }

    public void trigger(ServerPlayerEntity player, ItemStack stack, Target target) {
        Listeners triggerListeners = this.listeners.get(player.func_192039_O());
        if (triggerListeners != null) {
            triggerListeners.trigger(stack, target);
        }
    }

    public static enum Target {
        BLOCK,
        ENTITY,
        ITEM,
        ANY;


        static Target fromString(String str) {
            for (Target t : Target.values()) {
                if (!t.name().equalsIgnoreCase(str)) continue;
                return t;
            }
            return ANY;
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ItemStack stack, Target target) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(stack, target)) continue;
                if (list == null) {
                    list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        ItemPredicate itempredicate;
        Target target;

        Instance(ItemPredicate itempredicate, Target target) {
            super(ID, EntityPredicate.AndPredicate.field_234582_a_);
            this.itempredicate = itempredicate;
            this.target = target;
        }

        public static Instance instance(ItemPredicate predicate, Target target) {
            return new Instance(predicate, target);
        }

        public boolean test(ItemStack stack, Target target) {
            return this.itempredicate.func_192493_a(stack) && (this.target == target || this.target == Target.ANY);
        }

        public JsonObject func_230240_a_(ConditionArraySerializer p_230240_1_) {
            JsonObject json = new JsonObject();
            json.add("item", this.itempredicate.func_200319_a());
            json.addProperty("target", this.target.name());
            return json;
        }
    }
}

