/*
 * Decompiled with CFR 0.152.
 */
package com.denismasterherobrine.angelring.compat;

import com.denismasterherobrine.angelring.register.ItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat {
    public static void sendImc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("angelring").build());
    }

    public static ICapabilityProvider initCapabilities() {
        final ICurio curio = new ICurio(){

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.getWearer();
                if (livingEntity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)livingEntity;
                    this.startFlying(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.getWearer();
                if (livingEntity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)livingEntity;
                    this.stopFlying(player);
                }
            }

            private void startFlying(PlayerEntity player) {
                if (!player.func_184812_l_() && !player.func_175149_v()) {
                    player.field_71075_bZ.field_75101_c = true;
                    player.func_71016_p();
                }
            }

            private void stopFlying(PlayerEntity player) {
                if (!player.func_184812_l_() && !player.func_175149_v()) {
                    player.field_71075_bZ.field_75100_b = false;
                    player.field_71075_bZ.field_75101_c = false;
                    player.func_71016_p();
                }
            }

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)livingEntity;
                    if (!player.field_71075_bZ.field_75101_c) {
                        this.startFlying(player);
                    }
                }
            }

            public boolean canEquip(String identifier, LivingEntity entityLivingBase) {
                return !CuriosApi.getCuriosHelper().findEquippedCurio(ItemRegistry.ItemRing, entityLivingBase).isPresent();
            }

            public void playRightClickEquipSound(LivingEntity entityLivingBase) {
                entityLivingBase.func_184185_a(SoundEvents.field_191258_p, 1.0f, 1.0f);
            }

            public boolean showAttributesTooltip(String identifier) {
                return true;
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public static boolean isRingInCuriosSlot(ItemStack angelRing, LivingEntity player) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(angelRing.func_77973_b(), player).isPresent();
    }
}

