/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.powercell.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.client.HudRenderHelper;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.modules.informationscreen.blocks.DefaultPowerInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.client.DefaultPowerInformationRenderer;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellInformationScreenInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TextFormatting;

public class PowerCellInformationRenderer {
    public static void renderGraphical(MatrixStack matrixStack, IRenderTypeBuffer buffer, int mode, TypedMap data, Direction orientation, double scale) {
        if (data == null || data.size() == 0) {
            return;
        }
        long energy = data.getOptional(DefaultPowerInformationScreenInfo.ENERGY).orElse(0L);
        long maxEnergy = data.getOptional(DefaultPowerInformationScreenInfo.MAXENERGY).orElse(0L);
        long rfExtractPerTick = data.getOptional(PowerCellInformationScreenInfo.RFEXTRACT_PERTICK).orElse(0L);
        long rfInsertPerTick = data.getOptional(PowerCellInformationScreenInfo.RFINSERT_PERTICK).orElse(0L);
        long roughMaxRfPerTick = data.getOptional(PowerCellInformationScreenInfo.ROUGH_MAXRF_PERTICK).orElse(0L);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)0.5f, (float)0.75f, (float)0.5f);
        GlStateManager.func_227689_c_((float)(-DefaultPowerInformationRenderer.getHudAngle((Direction)orientation)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_227688_c_((float)0.0f, (float)-0.25f, (float)0.46249998f);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
        GlStateManager.func_227737_l_();
        GlStateManager.func_227722_g_();
        if (maxEnergy > 0L) {
            GlStateManager.func_227688_c_((float)-0.5f, (float)0.5f, (float)0.07f);
            float f3 = 0.0075f;
            GlStateManager.func_227632_a_((double)((double)f3 * scale), (double)((double)(-f3) * scale), (double)f3);
            GlStateManager.func_227636_a_((float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            long pct = energy * 100L / maxEnergy;
            for (int i = 0; i < 100; i += 5) {
                int col = (long)i < pct ? DefaultPowerInformationRenderer.getPercentageColor((int)i) : -15658735;
                RenderHelper.drawFlatBox((MatrixStack)matrixStack, (int)16, (int)((int)(100.0 - (double)i * 0.8 - 13.0)), (int)(mode == 1 ? 88 : 44), (int)((int)(100.0 - (double)i * 0.8 + 3.0 - 13.0)), (int)col, (int)col);
            }
            if (mode == 2 && roughMaxRfPerTick > 0L) {
                long pctInserted = Math.max(0L, Math.min(100L, rfInsertPerTick * 100L / roughMaxRfPerTick));
                RenderHelper.drawFlatBox((MatrixStack)matrixStack, (int)60, (int)20, (int)90, (int)50, (int)-1, (int)(-16777216 + (int)((float)pctInserted * 2.5f)));
                long pctExtracted = Math.max(0L, Math.min(100L, rfExtractPerTick * 100L / roughMaxRfPerTick));
                int mask = (int)((float)pctExtracted * 2.5f);
                RenderHelper.drawFlatBox((MatrixStack)matrixStack, (int)60, (int)54, (int)90, (int)84, (int)-1, (int)(-16777216 + (mask << 16) + (mask << 8)));
            }
        }
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
        GlStateManager.func_227716_f_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
        GlStateManager.func_227627_O_();
    }

    public static void renderDefault(MatrixStack matrixStack, IRenderTypeBuffer buffer, TypedMap data, Direction orientation, double scale) {
        List<String> log = PowerCellInformationRenderer.getLog(data);
        HudRenderHelper.HudPlacement hudPlacement = HudRenderHelper.HudPlacement.HUD_FRONT;
        HudRenderHelper.HudOrientation hudOrientation = HudRenderHelper.HudOrientation.HUD_SOUTH;
        HudRenderHelper.renderHud((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, log, (HudRenderHelper.HudPlacement)hudPlacement, (HudRenderHelper.HudOrientation)hudOrientation, (Direction)orientation, (double)((double)(-orientation.func_82601_c()) * 0.95), (double)0.0, (double)((double)(-orientation.func_82599_e()) * 0.95), (float)((float)(1.0 + scale)));
    }

    private static List<String> getLog(TypedMap data) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        if (data != null && data.size() > 0) {
            long energy = (Long)data.get(DefaultPowerInformationScreenInfo.ENERGY);
            long maxEnergy = (Long)data.get(DefaultPowerInformationScreenInfo.MAXENERGY);
            long rfExtractPerTick = (Long)data.get(PowerCellInformationScreenInfo.RFEXTRACT_PERTICK);
            long rfInsertPerTick = (Long)data.get(PowerCellInformationScreenInfo.RFINSERT_PERTICK);
            list.add(TextFormatting.BLUE + " RF: " + TextFormatting.WHITE + DefaultPowerInformationRenderer.formatPower((long)energy));
            list.add(TextFormatting.BLUE + " Max: " + TextFormatting.WHITE + DefaultPowerInformationRenderer.formatPower((long)maxEnergy));
            if (rfExtractPerTick != -1L) {
                list.add(TextFormatting.BLUE + " Ext/t: " + TextFormatting.WHITE + DefaultPowerInformationRenderer.formatPower((long)rfExtractPerTick));
                list.add(TextFormatting.BLUE + " Ins/t: " + TextFormatting.WHITE + DefaultPowerInformationRenderer.formatPower((long)rfInsertPerTick));
            }
        } else {
            list.add(TextFormatting.RED + " Not a powercell");
            list.add(TextFormatting.RED + " or anything that");
            list.add(TextFormatting.RED + " supports power");
        }
        return list;
    }
}

