/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.logic;

import java.util.function.Consumer;
import mcjty.rftoolspower.modules.blazing.items.IBlazingRod;
import mcjty.rftoolspower.modules.blazing.logic.BlazingAgitatorAlgorithm;

public class TestAgitator {
    private BlazingAgitatorAlgorithm algorithm;
    private IBlazingRod[] stacks = new DummyBlazingRod[9];
    private boolean[] locked = new boolean[]{true, true, true, true, false, true, true, true, true};

    public TestAgitator() {
        this.algorithm = new BlazingAgitatorAlgorithm(slot -> this.stacks[slot]);
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i] = DummyBlazingRod.EMPTY;
        }
    }

    public IBlazingRod tick() {
        for (int i = 0; i < 9; ++i) {
            IBlazingRod stack = this.stacks[i];
            if (!stack.isValid()) continue;
            float timeLeft = stack.getAgitationTimeLeft();
            if (timeLeft > 0.0f) {
                this.algorithm.tickBlazingRod(i, stack, timeLeft, 1.0f);
                continue;
            }
            if (this.locked[i]) continue;
            return stack;
        }
        return null;
    }

    private void setStack(int slot, IBlazingRod stack) {
        this.stacks[slot] = stack;
    }

    private static IBlazingRod doTest(String header, boolean silent, Consumer<TestAgitator> setup) {
        TestAgitator agitator = new TestAgitator();
        setup.accept(agitator);
        IBlazingRod rod = agitator.tick();
        int ticks = 1;
        while (rod == null) {
            rod = agitator.tick();
            ++ticks;
        }
        if (!silent) {
            System.out.println("=== " + header + " ===");
            System.out.println("    ticks = " + ticks + ", seconds = " + ticks / 20 + ", minutes = " + ticks / 20 / 60 + ", timeLeft = " + rod.getAgitationTimeLeft());
            TestAgitator.dumpRod(rod, null);
        }
        return rod;
    }

    private static void dumpRod(IBlazingRod rod, String message) {
        if (message != null) {
            System.out.print("=== " + message + " ===");
        }
        System.out.println("    qual/dur = " + rod.getPowerQuality() + " (" + 60000.0f + "), " + rod.getPowerDuration() + " (" + 20.0f + ")    -> total " + rod.getPowerQuality() / 1000.0f * rod.getPowerDuration() + " RF (" + 36000 + " RF coalgen)");
    }

    private static void improveDuration(IBlazingRod stack, float factor) {
        float duration = stack.getPowerDuration();
        duration += duration * factor / 6400.0f;
        stack.setPowerDuration(duration);
    }

    private static void improveQuality(IBlazingRod stack, float factor) {
        float quality = stack.getPowerQuality();
        quality += quality * factor / 6400.0f;
        stack.setPowerQuality(quality);
    }

    private static void infuse(IBlazingRod input, int steps, float powerFactor, float durationFactor) {
        for (int i = 0; i < steps; ++i) {
            TestAgitator.improveQuality(input, powerFactor);
            TestAgitator.improveDuration(input, durationFactor);
        }
    }

    public static void main(String[] args) {
        IBlazingRod fullTestRod = TestAgitator.doTest("Full Test", true, a -> {
            for (int i = 0; i < 9; ++i) {
                a.setStack(i, new DummyBlazingRod());
            }
        });
        IBlazingRod rod = TestAgitator.doTest("Rod Phase 1", true, a -> a.setStack(4, new DummyBlazingRod()));
        TestAgitator.dumpRod(rod, "First phase");
        IBlazingRod previousRod = rod;
        for (int steps = 5; steps < 40; steps += 5) {
            rod = TestAgitator.iterationTest(steps);
            System.out.println("=== DIFF      ===    " + (rod.getPowerQuality() - previousRod.getPowerQuality()) + ", " + (rod.getPowerDuration() - previousRod.getPowerDuration()));
            previousRod = rod;
        }
    }

    private static IBlazingRod iterationTest(int steps) {
        System.out.println("#################### ITERATION TEST " + steps + " ###################");
        IBlazingRod rod = TestAgitator.doTest("Rod Phase 1", true, a -> a.setStack(4, new DummyBlazingRod()));
        for (int i = 2; i < steps; ++i) {
            IBlazingRod finalRod = rod;
            rod = TestAgitator.doTest("Rod Phase " + i, true, a -> {
                a.setStack(4, new DummyBlazingRod());
                a.setStack(1, new DummyBlazingRod(finalRod));
                a.setStack(3, new DummyBlazingRod(finalRod));
                a.setStack(5, new DummyBlazingRod(finalRod));
                a.setStack(7, new DummyBlazingRod(finalRod));
            });
        }
        TestAgitator.dumpRod(rod, "Iteration");
        TestAgitator.infuse(rod, 64, 120.0f, 120.0f);
        TestAgitator.dumpRod(rod, "Infused  ");
        return rod;
    }

    private static class DummyBlazingRod
    implements IBlazingRod {
        private float time = 600.0f;
        private float quality = 60000.0f;
        private float duration = 20.0f;
        private int infusionSteps = 64;
        public static final IBlazingRod EMPTY = new DummyBlazingRod(){

            @Override
            public boolean isValid() {
                return false;
            }
        };

        public DummyBlazingRod() {
        }

        public DummyBlazingRod(float time, float quality, float duration) {
            this.time = time;
            this.quality = quality;
            this.duration = duration;
        }

        public DummyBlazingRod(IBlazingRod other) {
            this.time = other.getAgitationTimeLeft();
            this.quality = other.getPowerQuality();
            this.duration = other.getPowerDuration();
            this.infusionSteps = other.getInfusionStepsLeft();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public int getInfusionStepsLeft() {
            return this.infusionSteps;
        }

        @Override
        public void setInfusionStepsLeft(int steps) {
            this.infusionSteps = steps;
        }

        @Override
        public float getAgitationTimeLeft() {
            return this.time;
        }

        @Override
        public void setAgitationTimeLeft(float time) {
            this.time = time;
        }

        @Override
        public float getPowerQuality() {
            return this.quality;
        }

        @Override
        public void setPowerQuality(float quality) {
            this.quality = quality;
        }

        @Override
        public float getPowerDuration() {
            return this.duration;
        }

        @Override
        public void setPowerDuration(float duration) {
            this.duration = duration;
        }
    }
}

