/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.compat;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Tools;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.data.EnderMonitorMode;
import mcjty.rftoolspower.modules.generator.CoalGeneratorModule;
import mcjty.rftoolspower.modules.powercell.PowerCellConfig;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellBlock;
import mcjty.rftoolspower.modules.powercell.data.SideType;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RFToolsPowerTOPDriver
implements TOPDriver {
    public static final RFToolsPowerTOPDriver DRIVER = new RFToolsPowerTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        ResourceLocation id = blockState.func_177230_c().getRegistryName();
        if (!this.drivers.containsKey(id)) {
            if (blockState.func_177230_c() == CoalGeneratorModule.COALGENERATOR.get()) {
                this.drivers.put(id, new CoalDriver());
            } else if (blockState.func_177230_c() instanceof PowerCellBlock) {
                this.drivers.put(id, new PowerCellDriver());
            } else if (blockState.func_177230_c() instanceof DimensionalCellBlock) {
                this.drivers.put(id, new DimensionalCellDriver());
            } else if (blockState.func_177230_c() == EndergenicModule.ENDERGENIC.get()) {
                this.drivers.put(id, new EndergenicDriver());
            } else if (blockState.func_177230_c() == EndergenicModule.ENDER_MONITOR.get()) {
                this.drivers.put(id, new EndermonitorDriver());
            } else if (blockState.func_177230_c() == BlazingModule.BLAZING_GENERATOR.get()) {
                this.drivers.put(id, new BlazingGeneratorDriver());
            } else if (blockState.func_177230_c() == BlazingModule.BLAZING_AGITATOR.get()) {
                this.drivers.put(id, new BlazingAgitatorDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class CoalDriver
    implements TOPDriver {
        private CoalDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                Boolean working = te.isWorking();
                if (working.booleanValue()) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Producing ", (Object)(te.getRfPerTick() + " RF/t")));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class PowerCellDriver
    implements TOPDriver {
        private PowerCellDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                long rfPerTick = te.getRfPerTickReal();
                if (te.getNetwork().isValid()) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Input/Output: ", (Object)(rfPerTick + " RF/t")));
                    SideType powermode = te.getMode(data.getSideHit());
                    if (powermode == SideType.INPUT) {
                        probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text("Side: input"));
                    } else if (powermode == SideType.OUTPUT) {
                        probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text("Side: output"));
                    }
                } else {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Too many blocks in network (max " + PowerCellConfig.NETWORK_MAX.get() + ")!"));
                }
                int networkId = te.getNetwork().getNetworkId();
                if (mode == ProbeMode.DEBUG) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Network ID: ", (Object)networkId));
                }
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Local Energy: ", (Object)te.getLocalEnergy()));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DimensionalCellDriver
    implements TOPDriver {
        private DimensionalCellDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                int id = te.getNetworkId();
                if (mode == ProbeMode.EXTENDED) {
                    if (id != -1) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"ID: ", (Object)new DecimalFormat("#.##").format(id)));
                    } else {
                        probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text("Local storage!"));
                    }
                }
                float costFactor = te.getCostFactor();
                int rfPerTick = te.getRfPerTickPerSide();
                probeInfo.text(CompoundText.createLabelInfo((String)"Input/Output: ", (Object)(rfPerTick + " RF/t")));
                DimensionalCellTileEntity.Mode powermode = te.getMode(data.getSideHit());
                if (powermode == DimensionalCellTileEntity.Mode.MODE_INPUT) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text("Side: input"));
                } else if (powermode == DimensionalCellTileEntity.Mode.MODE_OUTPUT) {
                    int cost = (int)((costFactor - 1.0f) * 1000.0f);
                    probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text("Side: output (cost " + cost / 10 + "." + cost % 10 + "%)"));
                }
                if (mode == ProbeMode.EXTENDED) {
                    int rfPerTickIn = te.getLastRfPerTickIn();
                    int rfPerTickOut = te.getLastRfPerTickOut();
                    probeInfo.text(CompoundText.createLabelInfo((String)"In:  ", (Object)(rfPerTickIn + "RF/t")));
                    probeInfo.text(CompoundText.createLabelInfo((String)"Out: ", (Object)(rfPerTickOut + "RF/t")));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class EndergenicDriver
    implements TOPDriver {
        private EndergenicDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                if (mode == ProbeMode.EXTENDED) {
                    IItemStyle style = probeInfo.defaultItemStyle().width(16).height(13);
                    ILayoutStyle layoutStyle = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
                    probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text("Stats over the last 5 seconds:"));
                    probeInfo.horizontal(layoutStyle).item(new ItemStack((IItemProvider)Items.field_151137_ax), style).text(CompoundText.createLabelInfo((String)"Charged ", (Object)(te.getLastChargeCounter() + " time(s)")));
                    probeInfo.horizontal(layoutStyle).item(new ItemStack((IItemProvider)Items.field_151079_bi), style).text(CompoundText.createLabelInfo((String)"Fired ", (Object)te.getLastPearlsLaunched())).text(CompoundText.createLabelInfo((String)" / Lost ", (Object)te.getLastPearlsLost()));
                    if (te.getLastPearlsLost() > 0) {
                        probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text(te.getLastPearlsLostReason()));
                    }
                    if (te.getLastPearlArrivedAt() > -2) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Last pearl arrived at ", (Object)te.getLastPearlArrivedAt()));
                    }
                    probeInfo.horizontal().text(CompoundText.create().style(TextStyleClass.OK).text("RF Gain " + te.getLastRfGained())).text(CompoundText.create().text(" / ")).text(CompoundText.create().style(TextStyleClass.ERROR).text("Lost " + te.getLastRfLost())).text(CompoundText.create().text(" (RF/t " + te.getLastRfPerTick() + ")"));
                } else {
                    probeInfo.text(CompoundText.create().text("(sneak to get statistics)"));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class EndermonitorDriver
    implements TOPDriver {
        private EndermonitorDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                EnderMonitorMode m = te.getMode();
                probeInfo.text(CompoundText.createLabelInfo((String)"Mode: ", (Object)m.getName()));
            }, (String)"Bad tile entity!");
        }
    }

    private static class BlazingGeneratorDriver
    implements TOPDriver {
        private BlazingGeneratorDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {}, (String)"Bad tile entity!");
        }
    }

    private static class BlazingAgitatorDriver
    implements TOPDriver {
        private BlazingAgitatorDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {}, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

