/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.layer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.IAreaTransformer0;
import twilightforest.world.TFBiomeProvider;
import twilightforest.worldgen.biomes.BiomeKeys;

public enum GenLayerTFBiomes implements IAreaTransformer0
{
    INSTANCE;

    private static final int RARE_BIOME_CHANCE = 15;
    protected static final List<RegistryKey<Biome>> commonBiomes;
    protected static final List<RegistryKey<Biome>> rareBiomes;
    private Registry<Biome> registry;

    public GenLayerTFBiomes setup(Registry<Biome> registry) {
        this.registry = registry;
        return this;
    }

    public int func_215735_a(INoiseRandom iNoiseRandom, int x, int y) {
        if (iNoiseRandom.func_202696_a(15) == 0) {
            return this.getRandomBiome(iNoiseRandom, rareBiomes);
        }
        return this.getRandomBiome(iNoiseRandom, commonBiomes);
    }

    private int getRandomBiome(INoiseRandom random, List<RegistryKey<Biome>> biomes) {
        return TFBiomeProvider.getBiomeId(biomes.get(random.func_202696_a(biomes.size())), this.registry);
    }

    static {
        commonBiomes = ImmutableList.of(BiomeKeys.FOREST, BiomeKeys.DENSE_FOREST, BiomeKeys.MUSHROOM_FOREST, BiomeKeys.OAK_SAVANNAH, BiomeKeys.FIREFLY_FOREST);
        rareBiomes = ImmutableList.of(BiomeKeys.LAKE, BiomeKeys.DENSE_MUSHROOM_FOREST, BiomeKeys.ENCHANTED_FOREST, BiomeKeys.CLEARING, BiomeKeys.SPOOKY_FOREST);
    }
}

