/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistryEntry;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.data.BlockTagGenerator;
import twilightforest.util.FeatureUtil;

@Mod.EventBusSubscriber(modid="twilightforest")
public class OreMagnetItem
extends Item {
    private static final float WIGGLE = 10.0f;
    private static boolean cacheNeedsBuild = true;
    private static final HashMap<Block, Block> ORE_TO_BLOCK_REPLACEMENTS = new HashMap();

    protected OreMagnetItem(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int useRemaining) {
        int useTime = this.func_77626_a(stack) - useRemaining;
        if (!world.field_72995_K && useTime > 10) {
            int moved = this.doMagnet(world, living, 0.0f, 0.0f);
            if (moved == 0) {
                moved = this.doMagnet(world, living, 10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 0.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, -10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, -10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, -10.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 0.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 10.0f, -10.0f);
            }
            if (moved > 0) {
                stack.func_222118_a(moved, living, user -> user.func_213334_d(living.func_184600_cs()));
                world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), TFSounds.MAGNET_GRAB, living.func_184176_by(), 1.0f, 1.0f);
            }
        }
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 0.1f;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    private int doMagnet(World world, LivingEntity living, float yawOffset, float pitchOffset) {
        double range = 32.0;
        Vector3d srcVec = new Vector3d(living.func_226277_ct_(), living.func_226278_cu_() + (double)living.func_70047_e(), living.func_226281_cx_());
        Vector3d lookVec = this.getOffsetLook(living, yawOffset, pitchOffset);
        Vector3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        return OreMagnetItem.doMagnet(world, new BlockPos(srcVec), new BlockPos(destVec));
    }

    public static int doMagnet(World world, BlockPos usePos, BlockPos destPos) {
        OreMagnetItem.initOre2BlockMap();
        int blocksMoved = 0;
        BlockPos[] lineArray = FeatureUtil.getBresenhamArrays(usePos, destPos);
        BlockState attactedOreBlock = Blocks.field_150350_a.func_176223_P();
        BlockState replacementBlock = Blocks.field_150350_a.func_176223_P();
        BlockPos foundPos = null;
        BlockPos basePos = null;
        for (BlockPos coord : lineArray) {
            BlockState searchState = world.func_180495_p(coord);
            if (basePos == null) {
                if (!OreMagnetItem.isReplaceable(searchState)) continue;
                basePos = coord;
                continue;
            }
            if (foundPos != null || searchState.func_177230_c() == Blocks.field_150350_a || !OreMagnetItem.isOre(searchState.func_177230_c()) || world.func_175625_s(coord) != null) continue;
            attactedOreBlock = searchState;
            replacementBlock = ORE_TO_BLOCK_REPLACEMENTS.getOrDefault(attactedOreBlock.func_177230_c(), Blocks.field_150348_b).func_176223_P();
            foundPos = coord;
        }
        if (basePos != null && foundPos != null && attactedOreBlock.func_177230_c() != Blocks.field_150350_a) {
            HashSet<BlockPos> veinBlocks = new HashSet<BlockPos>();
            OreMagnetItem.findVein(world, foundPos, attactedOreBlock, veinBlocks);
            int offX = basePos.func_177958_n() - foundPos.func_177958_n();
            int offY = basePos.func_177956_o() - foundPos.func_177956_o();
            int offZ = basePos.func_177952_p() - foundPos.func_177952_p();
            for (BlockPos coord : veinBlocks) {
                BlockPos replacePos = coord.func_177982_a(offX, offY, offZ);
                BlockState replaceState = world.func_180495_p(replacePos);
                if (!OreMagnetItem.isReplaceable(replaceState) && !(replaceState.func_177230_c() instanceof AirBlock)) continue;
                world.func_180501_a(coord, replacementBlock, 2);
                world.func_180501_a(replacePos, attactedOreBlock, 2);
                ++blocksMoved;
            }
        }
        return blocksMoved;
    }

    private Vector3d getOffsetLook(LivingEntity living, float yawOffset, float pitchOffset) {
        float var2 = MathHelper.func_76134_b((float)(-(living.field_70177_z + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var3 = MathHelper.func_76126_a((float)(-(living.field_70177_z + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var4 = -MathHelper.func_76134_b((float)(-(living.field_70125_A + pitchOffset) * ((float)Math.PI / 180)));
        float var5 = MathHelper.func_76126_a((float)(-(living.field_70125_A + pitchOffset) * ((float)Math.PI / 180)));
        return new Vector3d((double)(var3 * var4), (double)var5, (double)(var2 * var4));
    }

    @Deprecated
    private static boolean isReplaceable(BlockState state) {
        Block block = state.func_177230_c();
        return BlockTagGenerator.ORE_MAGNET_SAFE_REPLACE_BLOCK.func_230235_a_((Object)block);
    }

    private static boolean findVein(World world, BlockPos here, BlockState oreState, Set<BlockPos> veinBlocks) {
        if (veinBlocks.contains(here)) {
            return false;
        }
        if (veinBlocks.size() >= 24) {
            return false;
        }
        if (world.func_180495_p(here) == oreState) {
            veinBlocks.add(here);
            for (Direction e : Direction.values()) {
                OreMagnetItem.findVein(world, here.func_177972_a(e), oreState, veinBlocks);
            }
            return true;
        }
        return false;
    }

    private static boolean isOre(Block ore) {
        return ORE_TO_BLOCK_REPLACEMENTS.containsKey(ore);
    }

    private static void initOre2BlockMap() {
        if (!cacheNeedsBuild) {
            return;
        }
        TwilightForestMod.LOGGER.info("GENERATING ORE TO BLOCK MAPPING");
        for (Block blockReplaceOre : BlockTagGenerator.ORE_MAGNET_BLOCK_REPLACE_ORE.func_230236_b_()) {
            ResourceLocation rl = blockReplaceOre.getRegistryName();
            ITag tag = BlockTags.func_199896_a().func_241834_b(TwilightForestMod.prefix("ore_magnet/" + rl.func_110624_b() + "/" + rl.func_110623_a()));
            for (Block oreBlock : tag.func_230236_b_()) {
                ORE_TO_BLOCK_REPLACEMENTS.put(oreBlock, blockReplaceOre);
            }
        }
        HashSet<Block> remainingOres = new HashSet<Block>(Tags.Blocks.ORES.func_230236_b_());
        remainingOres.removeAll(ORE_TO_BLOCK_REPLACEMENTS.keySet());
        remainingOres.removeIf(b -> "minecraft".equals(b.getRegistryName().func_110624_b()));
        if (!remainingOres.isEmpty()) {
            TwilightForestMod.LOGGER.warn(remainingOres.stream().peek(ore -> ORE_TO_BLOCK_REPLACEMENTS.put((Block)ore, Blocks.field_150348_b)).map(ForgeRegistryEntry::getRegistryName).map(ResourceLocation::toString).collect(Collectors.joining(", ", "Partially supported ores with Ore Magnet, [", "], will relate these to `minecraft:stone`. Mod packers/Mod devs are encouraged to add support for their ores to our ore magnet through block tag jsons")));
        } else {
            TwilightForestMod.LOGGER.info("No remaining ores to map!");
        }
        cacheNeedsBuild = false;
    }

    @SubscribeEvent
    public static void buildOreMagnetCache(AddReloadListenerEvent event) {
        event.addListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> {
            if (!cacheNeedsBuild) {
                ORE_TO_BLOCK_REPLACEMENTS.clear();
                cacheNeedsBuild = true;
            }
            return stage.func_216872_a(null).thenRun(() -> {});
        });
    }
}

