/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import twilightforest.block.TFHorizontalBlock;
import twilightforest.enums.HugeLilypadPiece;

public class HugeLilyPadBlock
extends BushBlock {
    public static final DirectionProperty FACING = TFHorizontalBlock.field_185512_D;
    public static final EnumProperty<HugeLilypadPiece> PIECE = EnumProperty.func_177709_a((String)"piece", HugeLilypadPiece.class);
    private static final VoxelShape AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.015625, 1.0));
    private boolean isSelfDestructing = false;

    protected HugeLilyPadBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(PIECE, (Comparable)((Object)HugeLilypadPiece.NW)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, PIECE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        FluidState ifluidstate = worldIn.func_204610_c(pos);
        return ifluidstate.func_206886_c() == Fluids.field_204546_a;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.isSelfDestructing) {
            this.setGiantBlockToAir(world, pos, state);
        }
    }

    private void setGiantBlockToAir(World world, BlockPos pos, BlockState state) {
        this.isSelfDestructing = true;
        for (BlockPos check : this.getAllMyBlocks(pos, state)) {
            BlockState stateThere = world.func_180495_p(check);
            if (stateThere.func_177230_c() != this) continue;
            world.func_175655_b(check, false);
        }
        this.isSelfDestructing = false;
    }

    public List<BlockPos> getAllMyBlocks(BlockPos pos, BlockState state) {
        ArrayList pieces = Lists.newArrayListWithCapacity((int)4);
        if (state.func_177230_c() == this) {
            BlockPos nwPos = pos;
            switch ((HugeLilypadPiece)((Object)state.func_177229_b(PIECE))) {
                case NE: {
                    nwPos = nwPos.func_177976_e();
                    break;
                }
                case SE: {
                    nwPos = nwPos.func_177978_c().func_177976_e();
                    break;
                }
                case SW: {
                    nwPos = nwPos.func_177978_c();
                    break;
                }
            }
            pieces.add(nwPos);
            pieces.add(nwPos.func_177968_d());
            pieces.add(nwPos.func_177974_f());
            pieces.add(nwPos.func_177968_d().func_177974_f());
        }
        return pieces;
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (entityIn instanceof BoatEntity) {
            worldIn.func_175655_b(new BlockPos((Vector3i)pos), true);
        }
    }
}

