/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.UniversalGrid.items;

import com.YTrollman.UniversalGrid.UniversalGrid;
import com.YTrollman.UniversalGrid.config.UniversalGridConfig;
import com.YTrollman.UniversalGrid.handler.WirelessUniversalGridSettingsUpdateMessage;
import com.YTrollman.UniversalGrid.items.WirelessUniversalGridItem;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.FluidGridStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.ItemGridStorageCacheListener;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.FilterItemHandler;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.item.NetworkItem;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorageaddons.RSAddons;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WirelessUniversalGrid
implements INetworkAwareGrid {
    private ItemStack stack;
    @Nullable
    private final MinecraftServer server;
    private final World world;
    private final RegistryKey<World> nodeDimension;
    private final BlockPos nodePos;
    private final PlayerSlot slot;
    private int viewType;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private final List<IFilter> filters = new ArrayList<IFilter>();
    private final List<IGridTab> tabs = new ArrayList<IGridTab>();
    private final FilterItemHandler filter = (FilterItemHandler)new FilterItemHandler(this.filters, this.tabs).addListener((handler, slot, reading) -> {
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new CompoundNBT());
        }
        StackUtils.writeItems((IItemHandler)handler, (int)0, (CompoundNBT)this.stack.func_77978_p());
    });
    private Set<ICraftingGridListener> listeners = new HashSet<ICraftingGridListener>();
    private boolean queuedSave;
    public static int type;
    private Container craftingContainer = new Container(null, 0){

        public boolean func_75145_c(PlayerEntity player) {
            return false;
        }

        public void func_75130_a(IInventory inventory) {
            if (WirelessUniversalGrid.this.server != null) {
                WirelessUniversalGrid.this.onCraftingMatrixChanged();
            }
        }
    };
    private ICraftingRecipe currentRecipe;
    private CraftingInventory matrix = new CraftingInventory(this.craftingContainer, 3, 3){

        public void func_70296_d() {
            super.func_70296_d();
            if (!WirelessUniversalGrid.this.queuedSave && WirelessUniversalGrid.this.server != null) {
                WirelessUniversalGrid.this.queuedSave = true;
                WirelessUniversalGrid.this.server.func_212871_a_((Runnable)new TickDelayedTask(0, () -> {
                    if (!WirelessUniversalGrid.this.getStack().func_77942_o()) {
                        WirelessUniversalGrid.this.getStack().func_77982_d(new CompoundNBT());
                    }
                    StackUtils.writeItems((IInventory)WirelessUniversalGrid.this.matrix, (int)1, (CompoundNBT)WirelessUniversalGrid.this.getStack().func_77978_p());
                    WirelessUniversalGrid.this.queuedSave = false;
                }));
            }
        }
    };
    private CraftResultInventory result = new CraftResultInventory();

    public WirelessUniversalGrid(ItemStack stack, World world, @Nullable MinecraftServer server, PlayerSlot slot2) {
        this.stack = stack;
        this.server = server;
        this.world = world;
        this.nodeDimension = NetworkItem.getDimension((ItemStack)stack);
        this.nodePos = new BlockPos(NetworkItem.getX((ItemStack)stack), NetworkItem.getY((ItemStack)stack), NetworkItem.getZ((ItemStack)stack));
        this.slot = slot2;
        this.viewType = WirelessUniversalGridItem.getViewType(stack);
        this.sortingType = WirelessUniversalGridItem.getSortingType(stack);
        this.sortingDirection = WirelessUniversalGridItem.getSortingDirection(stack);
        this.searchBoxMode = WirelessUniversalGridItem.getSearchBoxMode(stack);
        this.tabSelected = WirelessUniversalGridItem.getTabSelected(stack);
        this.tabPage = WirelessUniversalGridItem.getTabPage(stack);
        this.size = WirelessUniversalGridItem.getSize(stack);
        if (stack.func_77942_o()) {
            StackUtils.readItems((BaseItemHandler)this.filter, (int)0, (CompoundNBT)stack.func_77978_p());
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public GridType getGridType() {
        if (this.getGridMode() == 0) {
            return GridType.NORMAL;
        }
        if (this.getGridMode() == 1) {
            return GridType.CRAFTING;
        }
        if (this.getGridMode() == 2) {
            return GridType.FLUID;
        }
        return null;
    }

    @Nullable
    public INetwork getNetwork() {
        ServerWorld world = this.server.func_71218_a(this.nodeDimension);
        return world != null ? NetworkUtils.getNetworkFromNode((INetworkNode)NetworkUtils.getNodeFromTile((TileEntity)world.func_175625_s(this.nodePos))) : null;
    }

    public IStorageCacheListener createListener(ServerPlayerEntity player) {
        if (this.getGridType() == GridType.FLUID) {
            return new FluidGridStorageCacheListener(player, this.getNetwork());
        }
        return new ItemGridStorageCacheListener(player, this.getNetwork());
    }

    @Nullable
    public IStorageCache getStorageCache() {
        if (this.getGridType() == GridType.FLUID) {
            INetwork network = this.getNetwork();
            return network != null ? network.getFluidStorageCache() : null;
        }
        INetwork network = this.getNetwork();
        return network != null ? network.getItemStorageCache() : null;
    }

    @Nullable
    public IItemGridHandler getItemHandler() {
        if (this.getGridType() != GridType.FLUID) {
            INetwork network = this.getNetwork();
            return network != null ? network.getItemGridHandler() : null;
        }
        return null;
    }

    @Nullable
    public IFluidGridHandler getFluidHandler() {
        if (this.getGridType() == GridType.FLUID) {
            INetwork network = this.getNetwork();
            return network != null ? network.getFluidGridHandler() : null;
        }
        return null;
    }

    public void addCraftingListener(ICraftingGridListener listener) {
        this.listeners.add(listener);
    }

    public void removeCraftingListener(ICraftingGridListener listener) {
        this.listeners.remove(listener);
    }

    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.universalgrid.universal_grid");
    }

    public int getViewType() {
        return this.viewType;
    }

    public int getSortingType() {
        return this.sortingType;
    }

    public int getSortingDirection() {
        return this.sortingDirection;
    }

    public int getSearchBoxMode() {
        return this.searchBoxMode;
    }

    public int getTabSelected() {
        return this.tabSelected;
    }

    public int getTabPage() {
        return Math.min(this.tabPage, this.getTotalTabPages());
    }

    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    public int getSize() {
        return this.size;
    }

    public void onViewTypeChanged(int type) {
        UniversalGrid.MOD_NETWORK_HANDLER.sendToServer(new WirelessUniversalGridSettingsUpdateMessage(type, this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.viewType = type;
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    public void onSortingTypeChanged(int type) {
        UniversalGrid.MOD_NETWORK_HANDLER.sendToServer(new WirelessUniversalGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), type, this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingType = type;
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    public void onSortingDirectionChanged(int direction) {
        UniversalGrid.MOD_NETWORK_HANDLER.sendToServer(new WirelessUniversalGridSettingsUpdateMessage(this.getViewType(), direction, this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingDirection = direction;
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    public void onSearchBoxModeChanged(int searchBoxMode) {
        UniversalGrid.MOD_NETWORK_HANDLER.sendToServer(new WirelessUniversalGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), this.getSortingType(), searchBoxMode, this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.searchBoxMode = searchBoxMode;
    }

    public void onSizeChanged(int size) {
        UniversalGrid.MOD_NETWORK_HANDLER.sendToServer(new WirelessUniversalGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), size, this.getTabSelected(), this.getTabPage()));
        this.size = size;
        BaseScreen.executeLater(GridScreen.class, BaseScreen::func_231160_c_);
    }

    public void onTabSelectionChanged(int tab) {
        this.tabSelected = tab == this.tabSelected ? -1 : tab;
        UniversalGrid.MOD_NETWORK_HANDLER.sendToServer(new WirelessUniversalGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.tabSelected, this.getTabPage()));
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            UniversalGrid.MOD_NETWORK_HANDLER.sendToServer(new WirelessUniversalGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), page));
            this.tabPage = page;
        }
    }

    public List<IFilter> getFilters() {
        return this.filters;
    }

    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    public CraftingInventory getCraftingMatrix() {
        return this.matrix;
    }

    public CraftResultInventory getCraftingResult() {
        return this.result;
    }

    public void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((IInventory)this.matrix, this.world)) {
            this.currentRecipe = this.world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.matrix, this.world).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.result.func_70299_a(0, ItemStack.field_190927_a);
        } else {
            this.result.func_70299_a(0, this.currentRecipe.func_77572_b((IInventory)this.matrix));
        }
        this.listeners.forEach(ICraftingGridListener::onCraftingMatrixChanged);
        if (!this.getStack().func_77942_o()) {
            this.getStack().func_77982_d(new CompoundNBT());
        }
        StackUtils.writeItems((IInventory)this.matrix, (int)1, (CompoundNBT)this.getStack().func_77978_p());
    }

    public void onCrafted(PlayerEntity player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        RSAddons.RSAPI.getCraftingGridBehavior().onCrafted((INetworkAwareGrid)this, this.currentRecipe, player, availableItems, usedItems);
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemManager().drainEnergy(player, ((Integer)UniversalGridConfig.UNIVERSAL_GRID_CRAFT_USAGE.get()).intValue());
        }
    }

    public void onClear(PlayerEntity player) {
        INetwork network = this.getNetwork();
        if (network != null && network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
                ItemStack slot = this.matrix.func_70301_a(i);
                if (slot.func_190926_b()) continue;
                this.matrix.func_70299_a(i, network.insertItem(slot, slot.func_190916_E(), Action.PERFORM));
                network.getItemStorageTracker().changed(player, (Object)slot.func_77946_l());
            }
            network.getNetworkItemManager().drainEnergy(player, ((Integer)UniversalGridConfig.UNIVERSAL_GRID_CLEAR_USAGE.get()).intValue());
        }
    }

    public void onCraftedShift(PlayerEntity player) {
        RSAddons.RSAPI.getCraftingGridBehavior().onCraftedShift((INetworkAwareGrid)this, player);
    }

    public void onRecipeTransfer(PlayerEntity player, ItemStack[][] recipe) {
        RSAddons.RSAPI.getCraftingGridBehavior().onRecipeTransfer((INetworkAwareGrid)this, player, recipe);
    }

    public boolean isGridActive() {
        return true;
    }

    public int getSlotId() {
        return this.slot.getSlotIdInPlayerInventory();
    }

    public void onClosed(PlayerEntity player) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemManager().close(player);
        }
    }

    public int getGridMode() {
        return type;
    }
}

