/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.util;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

@Immutable
public class Cuboid6i
implements Iterable<BlockPos> {
    public static final Codec<Cuboid6i> CODEC = Codec.INT_STREAM.comapFlatMap(stream -> Util.func_240987_a_((IntStream)stream, (int)6).map(bounds -> new Cuboid6i(bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5])), cuboid -> IntStream.of(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ())).stable();
    public static final Cuboid6i ZERO = new Cuboid6i(Vector3i.field_177959_e);
    protected int x1;
    protected int y1;
    protected int z1;
    protected int x2;
    protected int y2;
    protected int z2;

    public Cuboid6i(Vector3i bounds) {
        this(bounds, bounds);
    }

    public Cuboid6i(Vector3i min, Vector3i max) {
        this(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public Cuboid6i(Cuboid6i cuboid) {
        this(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ());
    }

    public Cuboid6i(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.z2 = Math.max(z1, z2);
    }

    public Cuboid6i shrink(Direction side) {
        return this.shrink(side, 1);
    }

    public Cuboid6i shrink(Direction side, int amount) {
        return this.expand(side, -amount);
    }

    public Cuboid6i shrink(int amount) {
        return this.expand(-amount);
    }

    public Cuboid6i expand(Direction side) {
        return this.expand(side, 1);
    }

    public Cuboid6i expand(Direction side, int amount) {
        if (amount == 0) {
            return this;
        }
        switch (side.func_176743_c()) {
            case NEGATIVE: {
                return new Cuboid6i(this.x1 + side.func_82601_c() * amount, this.y1 + side.func_96559_d() * amount, this.z1 + side.func_82599_e() * amount, this.x2, this.y2, this.z2);
            }
            case POSITIVE: {
                return new Cuboid6i(this.x1, this.y1, this.z1, this.x2 + side.func_82601_c() * amount, this.y2 + side.func_96559_d() * amount, this.z2 + side.func_82599_e() * amount);
            }
        }
        return this;
    }

    public Cuboid6i expand(int amount) {
        return amount == 0 ? this : new Cuboid6i(this.x1 - amount, this.y1 - amount, this.z1 - amount, this.x2 + amount, this.y2 + amount, this.z2 + amount);
    }

    public Cuboid6i side(Direction face) {
        Direction.Axis axis = face.func_176740_k();
        int side = face.func_176743_c() == Direction.AxisDirection.NEGATIVE ? this.min(axis) : this.max(axis);
        switch (axis) {
            case X: {
                return new Cuboid6i(side, this.y1, this.z1, side, this.y2, this.z2);
            }
            case Y: {
                return new Cuboid6i(this.x1, side, this.z1, this.x2, side, this.z2);
            }
            case Z: {
                return new Cuboid6i(this.x1, this.y1, side, this.x2, this.y2, side);
            }
        }
        return this;
    }

    public boolean contains(Vector3i pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2 && z >= this.z1 && z <= this.z2;
    }

    public static Cuboid6i load(CompoundNBT tag) {
        return new Cuboid6i(tag.func_74762_e("MinX"), tag.func_74762_e("MinY"), tag.func_74762_e("MinZ"), tag.func_74762_e("MaxX"), tag.func_74762_e("MaxY"), tag.func_74762_e("MaxZ"));
    }

    public CompoundNBT save(CompoundNBT tag) {
        tag.func_74768_a("MinX", this.x1);
        tag.func_74768_a("MinY", this.y1);
        tag.func_74768_a("MinZ", this.z1);
        tag.func_74768_a("MaxX", this.x2);
        tag.func_74768_a("MaxY", this.y2);
        tag.func_74768_a("MaxZ", this.z2);
        return tag;
    }

    public static Cuboid6i decode(PacketBuffer buffer) {
        return new Cuboid6i(buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a());
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.x1);
        buffer.func_150787_b(this.y1);
        buffer.func_150787_b(this.z1);
        buffer.func_150787_b(this.x2);
        buffer.func_150787_b(this.y2);
        buffer.func_150787_b(this.z2);
    }

    public int width() {
        return this.x2 - this.x1 + 1;
    }

    public int height() {
        return this.y2 - this.y1 + 1;
    }

    public int depth() {
        return this.z2 - this.z1 + 1;
    }

    public int size(Direction.Axis axis) {
        return axis.func_196052_a(this.width(), this.height(), this.depth());
    }

    public int minX() {
        return this.x1;
    }

    public int minY() {
        return this.y1;
    }

    public int minZ() {
        return this.z1;
    }

    public int maxX() {
        return this.x2;
    }

    public int maxY() {
        return this.y2;
    }

    public int maxZ() {
        return this.z2;
    }

    protected void setMinX(int x) {
        this.x1 = x;
    }

    protected void setMinY(int y) {
        this.y1 = y;
    }

    protected void setMinZ(int z) {
        this.z1 = z;
    }

    protected void setMaxX(int x) {
        this.x2 = x;
    }

    protected void setMaxY(int y) {
        this.y2 = y;
    }

    protected void setMaxZ(int z) {
        this.z2 = z;
    }

    public int min(Direction.Axis axis) {
        return axis.func_196052_a(this.x1, this.y1, this.z1);
    }

    public int max(Direction.Axis axis) {
        return axis.func_196052_a(this.x2, this.y2, this.z2);
    }

    public BlockPos min() {
        return new BlockPos(this.x1, this.y1, this.z1);
    }

    public BlockPos max() {
        return new BlockPos(this.x2, this.y2, this.z2);
    }

    public BlockPos center() {
        return new BlockPos(this.x1 + (this.x2 - this.x1) / 2, this.y1 + (this.y2 - this.y1) / 2, this.z1 + (this.z2 - this.z1) / 2);
    }

    public int volume() {
        return this.width() * this.height() * this.depth();
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return BlockPos.func_191531_b((int)this.x1, (int)this.y1, (int)this.z1, (int)this.x2, (int)this.y2, (int)this.z2).iterator();
    }

    public Stream<BlockPos> stream() {
        return BlockPos.func_218287_a((int)this.x1, (int)this.y1, (int)this.z1, (int)this.x2, (int)this.y2, (int)this.z2);
    }

    public Cuboid6i immutable() {
        return this;
    }

    public Mutable mutable() {
        return new Mutable(this);
    }

    public Cuboid6i copy() {
        return new Cuboid6i(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Cuboid6i)) {
            return false;
        }
        Cuboid6i cuboid = (Cuboid6i)obj;
        return this.x1 == cuboid.x1 && this.y1 == cuboid.y1 && this.z1 == cuboid.z1 && this.x2 == cuboid.x2 && this.y2 == cuboid.y2 && this.z2 == cuboid.z2;
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x1", this.x1).add("y1", this.y1).add("z1", this.z1).add("x2", this.x2).add("y2", this.y2).add("z2", this.z2).toString();
    }

    public static class Mutable
    extends Cuboid6i {
        public Mutable() {
            super(ZERO);
        }

        public Mutable(Vector3i bounds) {
            super(bounds);
        }

        public Mutable(Vector3i min, Vector3i max) {
            super(min, max);
        }

        public Mutable(Cuboid6i cuboid) {
            super(cuboid);
        }

        public Mutable(int x1, int y1, int z1, int x2, int y2, int z2) {
            super(x1, y1, z1, x2, y2, z2);
        }

        public Mutable set(Vector3i bounds) {
            return this.set(bounds, bounds);
        }

        public Mutable set(Vector3i min, Vector3i max) {
            return this.set(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
        }

        public Mutable set(Cuboid6i cuboid) {
            return this.set(cuboid.minX(), cuboid.minY(), cuboid.minZ(), cuboid.maxX(), cuboid.maxY(), cuboid.maxZ());
        }

        public Mutable set(int x1, int y1, int z1, int x2, int y2, int z2) {
            this.setMinX(x1);
            this.setMinY(y1);
            this.setMinZ(z1);
            this.setMaxX(x2);
            this.setMaxY(y2);
            this.setMaxZ(z2);
            return this;
        }

        @Override
        public Mutable shrink(Direction side) {
            return super.shrink(side).mutable();
        }

        @Override
        public Mutable shrink(Direction side, int amount) {
            return super.shrink(side, amount).mutable();
        }

        @Override
        public Mutable shrink(int amount) {
            return super.shrink(amount).mutable();
        }

        @Override
        public Mutable expand(Direction side) {
            return super.expand(side).mutable();
        }

        @Override
        public Mutable expand(Direction side, int amount) {
            if (amount == 0) {
                return this;
            }
            switch (side.func_176743_c()) {
                case NEGATIVE: {
                    return this.set(this.x1 + side.func_82601_c() * amount, this.y1 + side.func_96559_d() * amount, this.z1 + side.func_82599_e() * amount, this.x2, this.y2, this.z2);
                }
                case POSITIVE: {
                    return this.set(this.x1, this.y1, this.z1, this.x2 + side.func_82601_c() * amount, this.y2 + side.func_96559_d() * amount, this.z2 + side.func_82599_e() * amount);
                }
            }
            return this;
        }

        @Override
        public Mutable expand(int amount) {
            return amount == 0 ? this : this.set(this.x1 - amount, this.y1 - amount, this.z1 - amount, this.x2 + amount, this.y2 + amount, this.z2 + amount);
        }

        @Override
        public Mutable side(Direction face) {
            Direction.Axis axis = face.func_176740_k();
            int side = face.func_176743_c() == Direction.AxisDirection.NEGATIVE ? this.min(axis) : this.max(axis);
            switch (axis) {
                case X: {
                    return this.set(side, this.y1, this.z1, side, this.y2, this.z2);
                }
                case Y: {
                    return this.set(this.x1, side, this.z1, this.x2, side, this.z2);
                }
                case Z: {
                    return this.set(this.x1, this.y1, side, this.x2, this.y2, side);
                }
            }
            return this;
        }

        @Override
        public void setMinX(int x) {
            super.setMinX(x);
        }

        @Override
        public void setMinY(int y) {
            super.setMinY(y);
        }

        @Override
        public void setMinZ(int z) {
            super.setMinZ(z);
        }

        @Override
        public void setMaxX(int x) {
            super.setMaxX(x);
        }

        @Override
        public void setMaxY(int y) {
            super.setMaxY(y);
        }

        @Override
        public void setMaxZ(int z) {
            super.setMaxZ(z);
        }

        @Override
        public Cuboid6i immutable() {
            return new Cuboid6i(this);
        }

        @Override
        public Mutable mutable() {
            return this;
        }

        @Override
        public Mutable copy() {
            return new Mutable(this);
        }
    }
}

