/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.util;

import com.google.common.base.MoreObjects;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;

@Immutable
public class Color {
    private final int color;

    private Color(int rgba) {
        this.color = rgba;
    }

    public static Color fromRGB(int rgb) {
        return Color.fromRGBA(rgb, 255);
    }

    public static Color fromRGB(int r, int g, int b) {
        return Color.fromRGBA(r, g, b, 255);
    }

    public static Color fromRGBA(int rgb, int a) {
        return Color.fromRGBA(Color.rgba(rgb, a));
    }

    public static Color fromRGBA(int r, int g, int b, int a) {
        return Color.fromRGBA(Color.rgba(r, g, b, a));
    }

    public static Color fromARGB(int argb) {
        return Color.fromRGBA(Color.rgba(argb));
    }

    public static Color fromRGBA(int rgba) {
        return new Color(rgba);
    }

    public Color add(int r, int g, int b, int a) {
        r = Color.clamp(this.red() + r);
        g = Color.clamp(this.green() + g);
        b = Color.clamp(this.blue() + b);
        a = Color.clamp(this.alpha() + a);
        return Color.fromRGBA(r, g, b, a);
    }

    public Color subtract(int r, int g, int b, int a) {
        return this.add(-r, -g, -b, -a);
    }

    public Color multiplyRGB(float amount) {
        return this.multiply(amount, amount, amount, 1.0f);
    }

    public Color multiply(float amount) {
        return this.multiply(amount, amount, amount, amount);
    }

    public Color multiply(float r, float g, float b, float a) {
        r = Color.clamp((float)this.red() * r);
        g = Color.clamp((float)this.green() * g);
        b = Color.clamp((float)this.blue() * b);
        a = Color.clamp((float)this.alpha() * a);
        return Color.fromRGBA((int)r, (int)g, (int)b, (int)a);
    }

    public static Color load(CompoundNBT tag) {
        return Color.fromRGBA(tag.func_74762_e("Color"));
    }

    public Color save(CompoundNBT tag) {
        tag.func_74768_a("Color", this.color);
        return this;
    }

    public static Color decode(PacketBuffer buffer) {
        return Color.fromRGBA(buffer.func_150792_a());
    }

    public Color encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.color);
        return this;
    }

    public int rgb() {
        return Color.rgb(this.color);
    }

    public int rgba() {
        return this.color;
    }

    public int argb() {
        return Color.argb(this.color);
    }

    public int red() {
        return Color.wrap(this.color >> 24);
    }

    public int green() {
        return Color.wrap(this.color >> 16);
    }

    public int blue() {
        return Color.wrap(this.color >> 8);
    }

    public int alpha() {
        return Color.wrap(this.color);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Color && this.color == ((Color)obj).color;
    }

    public int hashCode() {
        return this.color;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("color", (Object)Integer.toHexString(this.color)).toString();
    }

    public static int add(int rgba1, int rgba2) {
        int r = Color.clamp(Color.wrap(rgba1 >> 24) + Color.wrap(rgba2 >> 24));
        int g = Color.clamp(Color.wrap(rgba1 >> 16) + Color.wrap(rgba2 >> 16));
        int b = Color.clamp(Color.wrap(rgba1 >> 8) + Color.wrap(rgba2 >> 8));
        int a = Color.clamp(Color.wrap(rgba1) + Color.wrap(rgba2));
        return Color.rgba(r, g, b, a);
    }

    public static int subtract(int rgba1, int rgba2) {
        int r = Color.clamp(Color.wrap(rgba1 >> 24) - Color.wrap(rgba2 >> 24));
        int g = Color.clamp(Color.wrap(rgba1 >> 16) - Color.wrap(rgba2 >> 16));
        int b = Color.clamp(Color.wrap(rgba1 >> 8) - Color.wrap(rgba2 >> 8));
        int a = Color.clamp(Color.wrap(rgba1) - Color.wrap(rgba2));
        return Color.rgba(r, g, b, a);
    }

    public static int multiplyRGBBy(int rgba, float amount) {
        float r = Color.clamp((float)Color.wrap(rgba >> 24) * amount);
        float g = Color.clamp((float)Color.wrap(rgba >> 16) * amount);
        float b = Color.clamp((float)Color.wrap(rgba >> 8) * amount);
        int a = Color.wrap(rgba);
        return Color.rgba((int)r, (int)g, (int)b, a);
    }

    public static int multiplyBy(int rgba, float amount) {
        float r = Color.clamp((float)Color.wrap(rgba >> 24) * amount);
        float g = Color.clamp((float)Color.wrap(rgba >> 16) * amount);
        float b = Color.clamp((float)Color.wrap(rgba >> 8) * amount);
        float a = Color.clamp((float)Color.wrap(rgba) * amount);
        return Color.rgba((int)r, (int)g, (int)b, (int)a);
    }

    public static int rgb(int rgba) {
        return (rgba & 0xFFFFFF00) >> 8;
    }

    public static int rgb(int r, int g, int b) {
        return Color.wrap(r) << 16 | Color.wrap(g) << 8 | Color.wrap(b);
    }

    public static int rgba(int rgb, int a) {
        return (rgb & 0xFFFFFF) << 8 | Color.wrap(a);
    }

    public static int rgba(int argb) {
        return Color.rgba(argb & 0xFFFFFF, argb >> 24);
    }

    public static int rgba(int r, int g, int b, int a) {
        return Color.rgb(r, g, b) << 8 | Color.wrap(a);
    }

    public static int argb(int rgba) {
        return Color.wrap(rgba) << 24 | Color.rgb(rgba);
    }

    public static int argb(int rgb, int a) {
        return Color.wrap(a) << 24 | rgb & 0xFFFFFF;
    }

    public static int argb(int r, int g, int b, int a) {
        return Color.wrap(a) << 24 | Color.rgb(r, g, b);
    }

    public static float[] rgbToHSV(int r, int g, int b) {
        int min = Math.min(b, Math.min(r, g));
        int max = Math.max(b, Math.max(r, g));
        float diff = max - min;
        float h = 0.0f;
        float s = max != 0 ? diff / (float)max : 0.0f;
        float v = (float)max / 255.0f;
        if (s > 0.0f) {
            float red = (float)(max - r) / diff;
            float green = (float)(max - g) / diff;
            float blue = (float)(max - b) / diff;
            h = r == max ? blue - green : (g == max ? 2.0f + red - blue : 4.0f + green - red);
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
        }
        return new float[]{h, s, v};
    }

    public static int hsvToRGB(float h, float s, float v) {
        return MathHelper.func_181758_c((float)h, (float)s, (float)v);
    }

    private static int wrap(int value) {
        return value & 0xFF;
    }

    private static int clamp(int value) {
        return MathHelper.func_76125_a((int)value, (int)0, (int)255);
    }

    private static float clamp(float value) {
        return MathHelper.func_76131_a((float)value, (float)0.0f, (float)255.0f);
    }
}

