/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.tile;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nikita488.zycraft.block.FabricatorBlock;
import nikita488.zycraft.block.state.properties.FabricatorMode;
import nikita488.zycraft.init.ZYLang;
import nikita488.zycraft.menu.FabricatorContainer;
import nikita488.zycraft.menu.ZYContainer;
import nikita488.zycraft.tile.FabricatorLogic;
import nikita488.zycraft.tile.ZYTile;
import nikita488.zycraft.util.DataPackReloadCounter;
import nikita488.zycraft.util.InventoryUtils;
import nikita488.zycraft.util.SerializableCraftingInventory;

public class FabricatorTile
extends ZYTile
implements ITickableTileEntity,
INamedContainerProvider {
    private static final GameProfile PROFILE = new GameProfile(UUID.randomUUID(), "[Fabricator]");
    private final FabricatorLogic logic = new FabricatorLogic(this);
    private final SerializableCraftingInventory recipePattern = new SerializableCraftingInventory(ZYContainer.EMPTY_CONTAINER, 3, 3){

        public void func_70296_d() {
            FabricatorTile.this.func_70296_d();
        }
    };
    @Nullable
    private ICraftingRecipe craftingRecipe;
    private final ItemStackHandler craftingResult = new ItemStackHandler();
    private final ItemStackHandler inventory = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            FabricatorTile.this.func_70296_d();
            FabricatorTile.this.logic.setSideChanged(Direction.UP);
        }
    };
    private final LazyOptional<IItemHandler> capability = LazyOptional.of(() -> this.inventory);
    private final NonNullLazy<FakePlayer> player = NonNullLazy.of(() -> FakePlayerFactory.get((ServerWorld)((ServerWorld)this.field_145850_b), (GameProfile)PROFILE));
    private final Supplier<FabricatorMode> mode = () -> (FabricatorMode)((Object)((Object)this.func_195044_w().func_177229_b(FabricatorBlock.MODE)));
    private int reloadCount = DataPackReloadCounter.INSTANCE.count();
    @Nullable
    private ResourceLocation pendingRecipe;
    private boolean lastPowered;

    public FabricatorTile(TileEntityType<?> type) {
        super(type);
    }

    public static boolean isRecipeCompatible(IRecipe<?> recipe) {
        return recipe.func_222127_g() == IRecipeType.field_222149_a && !recipe.func_192399_d() && recipe.func_194133_a(3, 3) && !recipe.func_192400_c().isEmpty() && !recipe.func_77571_b().func_190926_b();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.reloadCount != DataPackReloadCounter.INSTANCE.count()) {
            if (this.craftingRecipe != null) {
                this.pendingRecipe = this.craftingRecipe.func_199560_c();
                this.setCraftingRecipeAndResult(null, ItemStack.field_190927_a);
            }
            this.reloadCount = DataPackReloadCounter.INSTANCE.count();
        }
        if (this.pendingRecipe != null) {
            Optional<Object> craftingRecipe = this.field_145850_b.func_199532_z().func_215367_a(this.pendingRecipe).filter(FabricatorTile::isRecipeCompatible).flatMap(recipe -> IRecipeType.field_222149_a.func_222148_a((IRecipe)((ICraftingRecipe)recipe), this.field_145850_b, (IInventory)this.recipePattern));
            if (!craftingRecipe.isPresent()) {
                craftingRecipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.recipePattern, this.field_145850_b).filter(FabricatorTile::isRecipeCompatible);
            }
            ItemStack craftingResult = craftingRecipe.map(recipe -> recipe.func_77572_b((IInventory)this.recipePattern)).orElse(ItemStack.field_190927_a);
            this.setCraftingRecipeAndResult(craftingRecipe.orElse(null), craftingResult);
            this.pendingRecipe = null;
        }
        if (this.logic.updatePendingItems()) {
            return;
        }
        boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (this.mode.get().canCraft(this.lastPowered, powered)) {
            this.logic.tryCraft();
        }
        if (powered != this.lastPowered) {
            this.lastPowered = powered;
            this.func_70296_d();
        }
    }

    public int getColor(BlockState state) {
        return ((FabricatorMode)((Object)state.func_177229_b(FabricatorBlock.MODE))).rgb(this.field_145850_b.func_175640_z(this.field_174879_c));
    }

    public void dropItems() {
        InventoryUtils.dropInventoryItems(this.field_145850_b, this.field_174879_c, (IItemHandler)this.inventory);
        this.logic.dropPendingItems();
    }

    public int getAnalogOutputSignal() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inventory);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.lastPowered = tag.func_74767_n("LastPowered");
        if (tag.func_150297_b("Recipe", 8)) {
            this.pendingRecipe = new ResourceLocation(tag.func_74779_i("Recipe"));
        }
        this.recipePattern.load(tag.func_74775_l("RecipePattern"));
        this.inventory.deserializeNBT(tag.func_74775_l("Inventory"));
        this.logic.load(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.craftingRecipe != null) {
            tag.func_74778_a("Recipe", this.craftingRecipe.func_199560_c().toString());
        }
        tag.func_218657_a("RecipePattern", (INBT)this.recipePattern.save(new CompoundNBT()));
        tag.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        tag.func_74757_a("LastPowered", this.lastPowered);
        this.logic.save(tag);
        return tag;
    }

    public ITextComponent func_145748_c_() {
        return ZYLang.FABRICATOR;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new FabricatorContainer(id, playerInventory, this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> type, @Nullable Direction side) {
        return !this.field_145846_f && side != Direction.UP && type == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.capability.cast() : super.getCapability(type, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    public FabricatorLogic logic() {
        return this.logic;
    }

    public CraftingInventory recipePattern() {
        return this.recipePattern;
    }

    @Nullable
    public ICraftingRecipe craftingRecipe() {
        return this.craftingRecipe;
    }

    public void setCraftingRecipeAndResult(@Nullable ICraftingRecipe recipe, ItemStack result) {
        this.craftingRecipe = recipe != null && result.func_190926_b() ? null : recipe;
        this.craftingResult.setStackInSlot(0, result);
        this.logic.recheckSides();
        this.func_70296_d();
    }

    public ItemStackHandler craftingResult() {
        return this.craftingResult;
    }

    public ItemStack craftingResultStack() {
        return this.craftingResult.getStackInSlot(0).func_77946_l();
    }

    public ItemStackHandler inventory() {
        return this.inventory;
    }

    public FakePlayer player() {
        return (FakePlayer)this.player.get();
    }

    public FabricatorMode mode() {
        return this.mode.get();
    }

    public void setMode(FabricatorMode mode) {
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(FabricatorBlock.MODE, (Comparable)((Object)mode)), 2);
    }
}

