/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.tile;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import nikita488.zycraft.api.colorable.IColorable;
import nikita488.zycraft.tile.ZYTile;
import nikita488.zycraft.util.Color;

public class ColorableTile
extends ZYTile
implements IColorable {
    protected Color color;

    public ColorableTile(TileEntityType<?> type) {
        this(type, 0xFFFFFF);
    }

    public ColorableTile(TileEntityType<?> type, int defaultColor) {
        super(type);
        this.color = Color.fromRGB(defaultColor);
    }

    @Override
    public int getColor(BlockState state, IBlockDisplayReader getter, BlockPos pos) {
        return this.color.rgb();
    }

    @Override
    public void setColor(BlockState state, IBlockDisplayReader getter, BlockPos pos, int rgb) {
        this.color = Color.fromRGB(rgb);
        this.func_70296_d();
        this.sendUpdated();
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.color = Color.load(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.color.save(tag);
        return tag;
    }

    @Override
    public void decode(CompoundNBT tag) {
        this.color = Color.load(tag);
    }

    @Override
    public void decodeUpdate(CompoundNBT tag) {
        super.decodeUpdate(tag);
        this.blockChanged();
    }

    @Override
    public void encode(CompoundNBT tag) {
        this.color.save(tag);
    }

    public Color color() {
        return this.color;
    }

    public int rgb() {
        return this.color.rgb();
    }
}

