/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.network;

import java.util.Map;
import java.util.function.Supplier;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import nikita488.zycraft.menu.FabricatorContainer;
import nikita488.zycraft.tile.FabricatorTile;

public class SetFabricatorRecipePacket {
    private final int menuID;
    private final ResourceLocation recipeID;
    private final NonNullList<ItemStack> recipePattern = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private ItemStack craftingResult = ItemStack.field_190927_a;

    public SetFabricatorRecipePacket(int menuID, ICraftingRecipe recipe, Map<Integer, ? extends IGuiIngredient<ItemStack>> ingredients) {
        this.menuID = menuID;
        this.recipeID = recipe.func_199560_c();
        ingredients.forEach((index, ingredient) -> {
            ItemStack stack = (ItemStack)ingredient.getDisplayedIngredient();
            if (stack == null) {
                return;
            }
            if (ingredient.isInput()) {
                this.recipePattern.set(index - 1, (Object)stack);
            } else {
                this.craftingResult = stack;
            }
        });
    }

    public SetFabricatorRecipePacket(PacketBuffer buffer) {
        this.menuID = buffer.func_150792_a();
        this.recipeID = buffer.func_192575_l();
        for (int slot = 0; slot < 9; ++slot) {
            this.recipePattern.set(slot, (Object)buffer.func_150791_c());
        }
        this.craftingResult = buffer.func_150791_c();
    }

    public static SetFabricatorRecipePacket decode(PacketBuffer buffer) {
        return new SetFabricatorRecipePacket(buffer);
    }

    public static void encode(SetFabricatorRecipePacket packet, PacketBuffer buffer) {
        buffer.func_150787_b(packet.menuID());
        buffer.func_192572_a(packet.recipeID());
        for (int slot = 0; slot < 9; ++slot) {
            buffer.func_150788_a((ItemStack)packet.recipePattern().get(slot));
        }
        buffer.func_150788_a(packet.craftingResult());
    }

    public static boolean handle(SetFabricatorRecipePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            player.func_143004_u();
            Container menu = player.field_71070_bA;
            if (menu.field_75152_c == packet.menuID() && menu.func_75129_b((PlayerEntity)player) && menu instanceof FabricatorContainer && !player.func_175149_v()) {
                FabricatorTile fabricator = (FabricatorTile)((Object)((Object)((FabricatorContainer)menu).blockEntity()));
                if (fabricator == null) {
                    return;
                }
                for (int slot = 0; slot < 9; ++slot) {
                    fabricator.recipePattern().func_70299_a(slot, (ItemStack)packet.recipePattern().get(slot));
                }
                ICraftingRecipe recipe = player.func_71121_q().func_199532_z().func_215367_a(packet.recipeID()).orElse(null);
                fabricator.setCraftingRecipeAndResult(recipe, packet.craftingResult());
            }
        });
        return true;
    }

    public int menuID() {
        return this.menuID;
    }

    public ResourceLocation recipeID() {
        return this.recipeID;
    }

    public NonNullList<ItemStack> recipePattern() {
        return this.recipePattern;
    }

    public ItemStack craftingResult() {
        return this.craftingResult;
    }
}

