/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock.child.tile;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import nikita488.zycraft.block.state.properties.InterfaceAxis;
import nikita488.zycraft.block.state.properties.ZYBlockStateProperties;
import nikita488.zycraft.multiblock.MultiBlock;
import nikita488.zycraft.multiblock.child.IMultiChild;
import nikita488.zycraft.multiblock.child.tile.MultiChildTile;
import nikita488.zycraft.util.ZYConstants;

public class MultiInterfaceTile
extends MultiChildTile {
    public static final EnumProperty<InterfaceAxis> AXIS = ZYBlockStateProperties.INTERFACE_AXIS;
    private final Supplier<InterfaceAxis> axis = () -> (InterfaceAxis)((Object)((Object)this.func_195044_w().func_177229_b(AXIS)));
    private boolean updateAxis;
    @Nullable
    private Direction validSide;

    public MultiInterfaceTile(TileEntityType<?> type) {
        super(type);
    }

    protected void update() {
        if (this.field_145850_b.func_201670_d() || this.parentCount() != 1) {
            return;
        }
        this.updateAxis();
        for (Direction side : ZYConstants.DIRECTIONS) {
            if (this.validSide != null && side != this.validSide) continue;
            BlockPos relativePos = this.field_174879_c.func_177972_a(side);
            if (this.field_145850_b.func_195588_v(relativePos)) {
                this.processRelativePos(relativePos, side);
            }
            if (this.validSide != null) break;
        }
    }

    protected void updateAxis() {
        if (!this.updateAxis) {
            return;
        }
        this.updateAxis = false;
        if (!this.hasAxis()) {
            return;
        }
        for (Direction side : ZYConstants.DIRECTIONS) {
            TileEntity blockEntity;
            BlockPos relativePos = this.field_174879_c.func_177972_a(side);
            if (!this.field_145850_b.func_195588_v(relativePos) || (blockEntity = this.field_145850_b.func_175625_s(relativePos)) instanceof IMultiChild && ((IMultiChild)blockEntity).hasParent(this.getParent())) continue;
            InterfaceAxis interfaceAxis = InterfaceAxis.get(side.func_176740_k());
            if (interfaceAxis != this.axis.get()) {
                this.setAxis(interfaceAxis);
            }
            this.validSide = side;
            break;
        }
    }

    protected void processRelativePos(BlockPos pos, Direction side) {
    }

    @Override
    public void onMultiValidation(MultiBlock multiBlock) {
        super.onMultiValidation(multiBlock);
        multiBlock.addInterface(this.field_174879_c);
        if (!this.field_145850_b.func_201670_d() && this.parentCount() == 1) {
            this.updateAxis = true;
        }
    }

    @Override
    public void onMultiInvalidation(MultiBlock multiBlock) {
        super.onMultiInvalidation(multiBlock);
        if (!this.field_145850_b.func_201670_d() && !this.hasParents() && this.hasAxis() && this.axis.get() != InterfaceAxis.ALL) {
            this.setAxis(InterfaceAxis.ALL);
            this.validSide = null;
        }
    }

    public InterfaceAxis axis() {
        return this.axis.get();
    }

    protected void setAxis(InterfaceAxis axis) {
        InterfaceAxis.set(this.func_195044_w(), this.field_145850_b, this.field_174879_c, axis);
    }

    public boolean hasAxis() {
        return this.func_195044_w().func_235901_b_(AXIS);
    }
}

