/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock.child;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IBlockReader;
import nikita488.zycraft.init.ZYBlocks;
import nikita488.zycraft.multiblock.child.IMultiChild;
import nikita488.zycraft.multiblock.child.IMultiChildMatcher;
import nikita488.zycraft.multiblock.child.block.ConvertedMultiChildBlock;
import nikita488.zycraft.multiblock.child.tile.ConvertedMultiChildTile;
import nikita488.zycraft.repack.registrate.util.nullness.NonNullSupplier;
import nikita488.zycraft.util.ZYConstants;

public enum MultiChildType implements IMultiChildMatcher
{
    AIR(ZYBlocks.MULTI_AIR, (state, getter, pos) -> state.func_196958_f() || state.isAir(getter, pos)),
    FLAMMABLE(ZYBlocks.FLAMMABLE_BLOCK, (state, getter, pos) -> state.func_235785_r_(getter, pos) && state.func_200015_d(getter, pos) && Arrays.stream(ZYConstants.DIRECTIONS).anyMatch(side -> state.isFlammable(getter, pos, side))),
    HARD(ZYBlocks.HARD_BLOCK, (state, getter, pos) -> state.func_235785_r_(getter, pos) && state.func_200015_d(getter, pos) && state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151573_f || state.func_185904_a() == Material.field_151574_g),
    GLASS(ZYBlocks.GLASS_BLOCK, (state, getter, pos) -> state.func_235785_r_(getter, pos) && !state.func_200015_d(getter, pos) && (state.func_185904_a() == Material.field_151592_s || state.func_185904_a() == Material.field_151591_t));

    public static final MultiChildType[] VALUES;
    private final NonNullSupplier<? extends Block> blockSupplier;
    private final Matcher matcher;

    private MultiChildType(NonNullSupplier<? extends Block> blockSupplier, Matcher matcher) {
        this.blockSupplier = blockSupplier;
        this.matcher = matcher;
    }

    @Nullable
    public static MultiChildType get(IBlockReader getter, BlockPos pos) {
        return MultiChildType.get(getter.func_180495_p(pos), getter, pos);
    }

    @Nullable
    public static MultiChildType get(BlockState state, IBlockReader getter, BlockPos pos) {
        for (MultiChildType type : VALUES) {
            if (!type.matches(state, getter, pos)) continue;
            return type;
        }
        return null;
    }

    public static boolean convert(IBiomeReader accessor, BlockPos pos) {
        BlockState state = accessor.func_180495_p(pos);
        MultiChildType type = MultiChildType.get(state, (IBlockReader)accessor, pos);
        if (type == null) {
            return false;
        }
        BlockState childState = type.block().func_176223_P();
        if (childState.func_177230_c() instanceof ConvertedMultiChildBlock) {
            childState = (BlockState)((BlockState)((BlockState)childState.func_206870_a((Property)ConvertedMultiChildBlock.USE_SHAPE_FOR_LIGHT_OCCLUSION, (Comparable)Boolean.valueOf(state.func_215691_g()))).func_206870_a((Property)ConvertedMultiChildBlock.HAS_ANALOG_OUTPUT_SIGNAL, (Comparable)Boolean.valueOf(state.func_185912_n()))).func_206870_a((Property)ConvertedMultiChildBlock.SIGNAL_SOURCE, (Comparable)Boolean.valueOf(state.func_185897_m()));
        }
        accessor.func_180501_a(pos, childState, 2);
        TileEntity blockEntity = accessor.func_175625_s(pos);
        if (!(blockEntity instanceof IMultiChild)) {
            return false;
        }
        if (blockEntity instanceof ConvertedMultiChildTile) {
            ((ConvertedMultiChildTile)blockEntity).setInitialState(state);
        }
        return true;
    }

    public Block block() {
        return this.blockSupplier.get();
    }

    @Override
    public boolean matches(IBlockReader getter, BlockPos pos) {
        return MultiChildType.get(getter, pos) == this;
    }

    public boolean matches(BlockState state, IBlockReader getter, BlockPos pos) {
        return (!state.hasTileEntity() || state.func_177230_c() instanceof ConvertedMultiChildBlock) && this.matcher.matches(state, getter, pos);
    }

    static {
        VALUES = MultiChildType.values();
    }

    @FunctionalInterface
    private static interface Matcher {
        public boolean matches(BlockState var1, IBlockReader var2, BlockPos var3);
    }
}

