/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock.child;

import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import nikita488.zycraft.multiblock.MultiBlock;

public interface IMultiChild {
    default public void onMultiValidation(MultiBlock multiBlock) {
        if (!this.hasParent(multiBlock)) {
            this.addParent(multiBlock);
        }
    }

    default public void onMultiInvalidation(MultiBlock multiBlock) {
        this.removeParent(multiBlock);
    }

    public ObjectList<MultiBlock> parentMultiBlocks();

    default public int parentCount() {
        return this.parentMultiBlocks().size();
    }

    default public boolean hasParents() {
        return this.parentCount() > 0;
    }

    default public boolean hasParent(MultiBlock multiBlock) {
        return this.parentMultiBlocks().contains((Object)multiBlock);
    }

    default public boolean addParent(MultiBlock multiBlock) {
        return this.parentMultiBlocks().add((Object)multiBlock);
    }

    default public boolean removeParent(MultiBlock multiBlock) {
        return this.parentMultiBlocks().remove((Object)multiBlock);
    }

    default public MultiBlock getParent() {
        return this.getParent(0);
    }

    default public MultiBlock getParent(int index) {
        return (MultiBlock)this.parentMultiBlocks().get(index);
    }

    default public ActionResultType use(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        return this.parentCount() == 1 ? this.getParent().onBlockActivated(state, level, pos, player, hand, hitResult) : ActionResultType.CONSUME;
    }

    default public int getLightValue(BlockState state, IBlockReader getter, BlockPos pos) {
        int emission = state.func_185906_d();
        for (MultiBlock multiBlock : this.parentMultiBlocks()) {
            emission = Math.max(emission, multiBlock.getLightValue(state, getter, pos));
        }
        return emission;
    }

    default public int getAnalogOutputSignal(BlockState state, World level, BlockPos pos) {
        return 0;
    }
}

