/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.network.PacketDistributor;
import nikita488.zycraft.ZYCraft;
import nikita488.zycraft.entity.MultiEntity;
import nikita488.zycraft.event.PlayerLoadedChunkEvent;
import nikita488.zycraft.event.PostLoadChunkEvent;
import nikita488.zycraft.event.UnloadChunkEvent;
import nikita488.zycraft.multiblock.IDynamicMultiBlock;
import nikita488.zycraft.multiblock.MultiBlock;
import nikita488.zycraft.multiblock.MultiType;
import nikita488.zycraft.network.AddMultiPacket;
import nikita488.zycraft.network.RemoveMultiPacket;
import nikita488.zycraft.network.UpdateMultiPacket;

public class MultiManager
extends WorldSavedData {
    public static final String ID = ZYCraft.string("multi_blocks");
    public static final String MULTI_BLOCKS_TAG = ZYCraft.string("MultiBlocks");
    private static MultiManager instance = new MultiManager();
    private final Long2ObjectMap<ObjectSet<MultiBlock>> chunkMultiBlocks = new Long2ObjectOpenHashMap();
    private final Int2ObjectMap<MultiBlock> loadedMultiBlocks = new Int2ObjectOpenHashMap();
    private final ObjectSet<MultiBlock> pendingMultiBlocks = new ObjectOpenHashSet();
    private final ObjectList<MultiBlock> deferredMultiBlocks = new ObjectArrayList();
    private final ObjectList<MultiBlock> multiBlocksToSend = new ObjectArrayList();
    private final ObjectList<MultiBlock> multiBlocksToUpdate = new ObjectArrayList();
    private boolean updatingPendingMultiBlocks;

    public MultiManager() {
        super(ID);
    }

    public static void commonSetup() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(MultiManager::onWorldTick);
        bus.addListener(MultiManager::onPostLoadChunk);
        bus.addListener(MultiManager::onPlayerLoadedChunk);
        bus.addListener(MultiManager::onChunkDataSave);
        bus.addListener(MultiManager::onChunkUnload);
        bus.addListener(MultiManager::onTeleportCommand);
        bus.addListener(MultiManager::onSpreadPlayersCommand);
    }

    public static void clientSetup() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(MultiManager::onClientTick);
        bus.addListener(MultiManager::onWorldUnload);
    }

    public static MultiManager getInstance() {
        return instance;
    }

    public static MultiManager getInstance(IWorld accessor) {
        return !accessor.func_201670_d() ? (MultiManager)((ServerWorld)accessor).func_217481_x().func_215752_a(MultiManager::new, ID) : instance;
    }

    @Nullable
    public MultiBlock getMultiBlock(int id) {
        return (MultiBlock)this.loadedMultiBlocks.get(id);
    }

    @Nullable
    private ObjectSet<MultiBlock> getMultiFromChunk(ChunkPos pos) {
        return (ObjectSet)this.chunkMultiBlocks.get(pos.func_201841_a());
    }

    private boolean addMultiToChunk(ChunkPos chunkPos, MultiBlock multiBlock) {
        return ((ObjectSet)this.chunkMultiBlocks.computeIfAbsent(chunkPos.func_201841_a(), key -> new ObjectOpenHashSet())).add((Object)multiBlock);
    }

    private void removeMultiFromChunk(ChunkPos chunkPos, MultiBlock multiBlock) {
        ObjectSet multiBlocks = (ObjectSet)this.chunkMultiBlocks.get(chunkPos.func_201841_a());
        if (multiBlocks == null) {
            return;
        }
        if (multiBlocks.remove((Object)multiBlock) && multiBlock.isMainChunk(chunkPos)) {
            multiBlock.markUnsaved();
        }
        if (multiBlocks.isEmpty()) {
            this.chunkMultiBlocks.remove(chunkPos.func_201841_a());
        }
    }

    public void addMultiBlock(MultiBlock multiBlock, MultiBlock.AddingReason reason) {
        ZYCraft.LOGGER.debug("{} {}", (Object)(reason.isFormed() ? "Adding" : "Loading"), (Object)multiBlock);
        if (!multiBlock.isLoaded()) {
            this.addPendingMultiBlock(multiBlock);
            return;
        }
        multiBlock.validate(reason);
        if (!multiBlock.isValid()) {
            return;
        }
        this.loadedMultiBlocks.put(multiBlock.id(), (Object)multiBlock);
        for (ChunkPos pos : multiBlock.parentChunks()) {
            if (!this.addMultiToChunk(pos, multiBlock) || !multiBlock.isMainChunk(pos)) continue;
            multiBlock.markUnsaved();
        }
        if (multiBlock.isClientSide()) {
            return;
        }
        if (reason.isFormed()) {
            this.multiBlocksToSend.add((Object)multiBlock);
        }
        if (multiBlock instanceof IDynamicMultiBlock) {
            multiBlock.level().func_217376_c((Entity)new MultiEntity(multiBlock.level(), (IDynamicMultiBlock)((Object)multiBlock), multiBlock.id()));
        }
    }

    public void removeMultiBlock(MultiBlock multiBlock, MultiBlock.RemovalReason reason) {
        ZYCraft.LOGGER.debug("{} {}", (Object)(reason.isDestroyed() ? "Removing" : "Unloading"), (Object)multiBlock);
        if (!this.pendingMultiBlocks.isEmpty() && this.pendingMultiBlocks.remove((Object)multiBlock)) {
            ZYCraft.LOGGER.debug("{} was pending", (Object)multiBlock);
            return;
        }
        if (!this.loadedMultiBlocks.isEmpty() && this.loadedMultiBlocks.remove(multiBlock.id()) == null) {
            ZYCraft.LOGGER.debug("{} was not present", (Object)multiBlock);
            return;
        }
        for (ChunkPos pos : multiBlock.parentChunks()) {
            this.removeMultiFromChunk(pos, multiBlock);
        }
        if (!multiBlock.isClientSide() && reason.isDestroyed()) {
            multiBlock.sendToTracking(new RemoveMultiPacket(multiBlock));
        }
        multiBlock.invalidate(reason);
    }

    private void addPendingMultiBlock(MultiBlock multiBlock) {
        if (multiBlock.isValid() && !this.loadedMultiBlocks.isEmpty() && this.loadedMultiBlocks.remove(multiBlock.id()) == null) {
            return;
        }
        ZYCraft.LOGGER.debug("Adding pending {}", (Object)multiBlock);
        (this.updatingPendingMultiBlocks ? this.deferredMultiBlocks : this.pendingMultiBlocks).add((Object)multiBlock);
        if (!multiBlock.isValid()) {
            this.addMultiToChunk(multiBlock.mainChunk(), multiBlock);
            return;
        }
        for (ChunkPos pos : multiBlock.parentChunks()) {
            if (multiBlock.isMainChunk(pos)) continue;
            this.removeMultiFromChunk(pos, multiBlock);
        }
        multiBlock.invalidate(MultiBlock.RemovalReason.UNLOADED);
    }

    public void sendMultiUpdated(MultiBlock multiBlock) {
        if (!multiBlock.isChanged()) {
            multiBlock.setChanged(this.multiBlocksToUpdate.add((Object)multiBlock));
        }
    }

    private void sendPackets() {
        if (!this.multiBlocksToSend.isEmpty()) {
            for (MultiBlock multiBlock : this.multiBlocksToSend) {
                multiBlock.sendToTracking(new AddMultiPacket(multiBlock));
            }
            this.multiBlocksToSend.clear();
        }
        if (!this.multiBlocksToUpdate.isEmpty()) {
            for (MultiBlock multiBlock : this.multiBlocksToUpdate) {
                multiBlock.sendToTracking(new UpdateMultiPacket(multiBlock));
                multiBlock.setChanged(false);
            }
            this.multiBlocksToUpdate.clear();
        }
    }

    private void updatePendingMultiBlocks() {
        if (this.pendingMultiBlocks.isEmpty()) {
            return;
        }
        this.updatingPendingMultiBlocks = true;
        ObjectIterator iterator = this.pendingMultiBlocks.iterator();
        while (iterator.hasNext()) {
            MultiBlock multiBlock = (MultiBlock)iterator.next();
            if (!multiBlock.isLoaded()) continue;
            this.addMultiBlock(multiBlock, MultiBlock.AddingReason.LOADED);
            iterator.remove();
        }
        this.updatingPendingMultiBlocks = false;
        if (!this.deferredMultiBlocks.isEmpty()) {
            this.pendingMultiBlocks.addAll(this.deferredMultiBlocks);
            this.deferredMultiBlocks.clear();
        }
    }

    private void tick() {
        this.updatePendingMultiBlocks();
        this.sendPackets();
    }

    private static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MultiManager.getInstance((IWorld)event.world).tick();
        }
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            instance.tick();
        }
    }

    private static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            instance = new MultiManager();
        }
    }

    private static void onPostLoadChunk(PostLoadChunkEvent event) {
        CompoundNBT tag = event.getChunkTag();
        if (!tag.func_150297_b(MULTI_BLOCKS_TAG, 9)) {
            return;
        }
        ListNBT multiTags = tag.func_150295_c(MULTI_BLOCKS_TAG, 10);
        World level = (World)event.getWorld();
        MultiManager manager = MultiManager.getInstance((IWorld)level);
        ChunkPos pos = event.getChunk().func_76632_l();
        for (int i = 0; i < multiTags.size(); ++i) {
            MultiType.create(level, pos, multiTags.func_150305_b(i)).ifPresent(manager::addPendingMultiBlock);
        }
    }

    private static void onPlayerLoadedChunk(PlayerLoadedChunkEvent event) {
        ChunkPos pos;
        MultiManager manager = MultiManager.getInstance(event.getWorld());
        ObjectSet<MultiBlock> multiBlocks = manager.getMultiFromChunk(pos = event.getChunk().func_76632_l());
        if (multiBlocks != null) {
            for (MultiBlock multiBlock : multiBlocks) {
                if (!multiBlock.isMainChunk(pos)) continue;
                if (multiBlock.isValid()) {
                    ZYCraft.CHANNEL.send(PacketDistributor.PLAYER.with(event::getPlayer), (Object)new AddMultiPacket(multiBlock));
                    continue;
                }
                manager.multiBlocksToSend.add((Object)multiBlock);
            }
        }
    }

    private static void onChunkDataSave(ChunkDataEvent.Save event) {
        ChunkPos pos = event.getChunk().func_76632_l();
        ObjectSet<MultiBlock> multiBlocks = MultiManager.getInstance(event.getWorld()).getMultiFromChunk(pos);
        if (multiBlocks == null) {
            return;
        }
        ListNBT multiTags = new ListNBT();
        for (MultiBlock multiBlock : multiBlocks) {
            if (!multiBlock.isMainChunk(pos)) continue;
            ResourceLocation id = multiBlock.type().getRegistryName();
            if (id == null) {
                ZYCraft.LOGGER.error("{} doesn't have a registry name. Data will not be saved", (Object)multiBlock);
                continue;
            }
            CompoundNBT multiTag = new CompoundNBT();
            multiTag.func_74778_a("ID", id.toString());
            multiBlock.save(multiTag);
            multiTags.add((Object)multiTag);
        }
        if (!multiTags.isEmpty()) {
            event.getData().func_74775_l("Level").func_218657_a(MULTI_BLOCKS_TAG, (INBT)multiTags);
        }
    }

    private static void onChunkUnload(UnloadChunkEvent event) {
        ChunkPos pos;
        MultiManager manager = MultiManager.getInstance(event.getWorld());
        ObjectSet<MultiBlock> multiBlocks = manager.getMultiFromChunk(pos = event.getChunk().func_76632_l());
        if (multiBlocks != null) {
            for (MultiBlock multiBlock : multiBlocks) {
                if (multiBlock.isMainChunk(pos)) {
                    manager.removeMultiBlock(multiBlock, MultiBlock.RemovalReason.UNLOADED);
                    continue;
                }
                manager.addPendingMultiBlock(multiBlock);
            }
        }
        manager.chunkMultiBlocks.remove(pos.func_201841_a());
    }

    private static void onTeleportCommand(EntityTeleportEvent.TeleportCommand event) {
        if (event.getEntity() instanceof MultiEntity) {
            event.setCanceled(true);
        }
    }

    private static void onSpreadPlayersCommand(EntityTeleportEvent.SpreadPlayersCommand event) {
        if (event.getEntity() instanceof MultiEntity) {
            event.setCanceled(true);
        }
    }

    public void func_76184_a(CompoundNBT tag) {
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        return tag;
    }
}

