/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.item;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import nikita488.zycraft.api.colorable.IColorChanger;
import nikita488.zycraft.api.colorable.IColorable;
import nikita488.zycraft.enums.ZYType;
import nikita488.zycraft.util.Color;

public class ZychoriumItem
extends Item
implements IColorChanger {
    private final ZYType type;

    public ZychoriumItem(ZYType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Override
    public boolean canChangeColor(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult, int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        boolean sneaking = player.func_225608_bj_();
        switch (this.type) {
            case RED: {
                return this.canChangeComponent(red, sneaking);
            }
            case GREEN: {
                return this.canChangeComponent(green, sneaking);
            }
            case BLUE: {
                return this.canChangeComponent(blue, sneaking);
            }
            case DARK: {
                float brightness = Color.rgbToHSV(red, green, blue)[2];
                return sneaking ? brightness > 0.0f : brightness < 1.0f;
            }
            case LIGHT: {
                return sneaking ? rgb != 526344 : rgb != -1;
            }
        }
        return false;
    }

    private boolean canChangeComponent(int value, boolean sneaking) {
        return value != (sneaking ? 0 : 255);
    }

    @Override
    public int changeColor(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult, int rgb) {
        int rgba = Color.rgba(rgb, 255);
        boolean sneaking = player.func_225608_bj_();
        switch (this.type) {
            case RED: {
                return Color.rgb(sneaking ? Color.subtract(rgba, 0x8000000) : Color.add(rgba, 0x8000000));
            }
            case GREEN: {
                return Color.rgb(sneaking ? Color.subtract(rgba, 524288) : Color.add(rgba, 524288));
            }
            case BLUE: {
                return Color.rgb(sneaking ? Color.subtract(rgba, 2048) : Color.add(rgba, 2048));
            }
            case DARK: {
                float[] hsv = Color.rgbToHSV(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
                float brightness = hsv[2];
                brightness = !sneaking ? (brightness += 0.03137255f) : (brightness -= 0.03137255f);
                return Color.hsvToRGB(hsv[0], hsv[1], MathHelper.func_76131_a((float)brightness, (float)0.0f, (float)1.0f));
            }
            case LIGHT: {
                return sneaking ? 526344 : 0xFFFFFF;
            }
        }
        return rgb;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader reader, BlockPos pos, PlayerEntity player) {
        return IColorable.isColorable((IBlockReader)reader, pos);
    }
}

