/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.item;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import nikita488.zycraft.item.ZYFluidContainerItem;
import nikita488.zycraft.util.FluidUtils;

public class ZYBucketItem
extends ZYFluidContainerItem {
    public ZYBucketItem(Item.Properties properties) {
        this(properties, 1000);
    }

    public ZYBucketItem(Item.Properties properties, int capacity) {
        super(properties, capacity, 1);
    }

    protected ItemStack getEmptySuccessItem(IFluidHandlerItem handler, ItemStack stack, PlayerEntity player) {
        return !player.field_71075_bZ.field_75098_d ? new ItemStack((IItemProvider)this) : stack;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        Optional<IFluidHandlerItem> capability = FluidUtils.getItemFluidHandler(heldStack);
        if (!capability.isPresent()) {
            return ActionResult.func_226250_c_((Object)heldStack);
        }
        IFluidHandlerItem handler = capability.get();
        FluidStack containedFluid = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        BlockRayTraceResult hitResult = ZYBucketItem.func_219968_a((World)level, (PlayerEntity)player, (RayTraceContext.FluidMode)(containedFluid.isEmpty() ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        ActionResult eventResult = ForgeEventFactory.onBucketUse((PlayerEntity)player, (World)level, (ItemStack)heldStack, (RayTraceResult)hitResult);
        if (eventResult != null) {
            return eventResult;
        }
        if (hitResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)heldStack);
        }
        BlockPos pos = hitResult.func_216350_a();
        Direction side = hitResult.func_216354_b();
        BlockPos relativePos = pos.func_177972_a(side);
        if (!level.func_175660_a(player, pos) || !player.func_175151_a(relativePos, side, heldStack)) {
            return ActionResult.func_226251_d_((Object)heldStack);
        }
        BlockState state = level.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!containedFluid.isEmpty()) {
            BlockPos fluidPos;
            BlockPos blockPos = fluidPos = FluidUtils.canPlaceFluid(level, pos, state, containedFluid.getFluid()) ? pos : relativePos;
            if (!FluidUtils.tryPlaceFluid(containedFluid, player, level, fluidPos, hitResult)) {
                return ActionResult.func_226251_d_((Object)heldStack);
            }
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, fluidPos, heldStack);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_233538_a_((Object)this.getEmptySuccessItem(handler, heldStack, player), (boolean)level.func_201670_d());
        }
        if (block instanceof IBucketPickupHandler) {
            Fluid fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)level, pos, state);
            if (fluid == Fluids.field_204541_a) {
                return ActionResult.func_226251_d_((Object)heldStack);
            }
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) != fluidStack.getAmount()) {
                return ActionResult.func_226251_d_((Object)heldStack);
            }
            handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            player.func_184185_a(fluid.getAttributes().getFillSound(), 1.0f, 1.0f);
            ItemStack filledContainer = DrinkHelper.func_241445_a_((ItemStack)heldStack, (PlayerEntity)player, (ItemStack)handler.getContainer(), (boolean)false);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, filledContainer);
            }
            return ActionResult.func_233538_a_((Object)filledContainer, (boolean)level.func_201670_d());
        }
        return ActionResult.func_226251_d_((Object)heldStack);
    }
}

